/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.jetty;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.e6tech.elements.common.actor.typed.worker.WorkerPoolConfig;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.ServerEngine;
import net.e6tech.elements.web.cxf.jetty.JettyActorExecutor;
import net.e6tech.elements.web.cxf.jetty.JettySSL;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyEngine
implements ServerEngine {
    private static Logger logger = Logger.getLogger();
    private QueuedThreadPool queuedThreadPool;
    private boolean useActorThreadPool = false;
    private Provision provision;
    private WorkerPoolConfig workerPoolConfig = new WorkerPoolConfig();
    private JettyActorExecutor executor;
    private JettySSL jettySSL = new JettySSL();

    public QueuedThreadPool getQueuedThreadPool() {
        return this.queuedThreadPool;
    }

    @Inject(optional=true)
    public void setQueuedThreadPool(QueuedThreadPool queuedThreadPool) {
        this.queuedThreadPool = queuedThreadPool;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject(optional=true)
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public boolean isUseActorThreadPool() {
        return this.useActorThreadPool;
    }

    public void setUseActorThreadPool(boolean useActorThreadPool) {
        this.useActorThreadPool = useActorThreadPool;
    }

    public WorkerPoolConfig getWorkerPoolConfig() {
        return this.workerPoolConfig;
    }

    @Inject(optional=true)
    public void setWorkerPoolConfig(WorkerPoolConfig workerPoolConfig) {
        this.workerPoolConfig = workerPoolConfig;
    }

    public JettySSL getJettySSL() {
        return this.jettySSL;
    }

    @Inject(optional=true)
    public void setJettySSL(JettySSL jettySSL) {
        this.jettySSL = jettySSL;
    }

    @Override
    public void onException(Message message, CallFrame frame, Throwable th) {
    }

    @Override
    public void start(CXFServer cxfServer, ServerController<?> controller) {
        JettyHTTPDestination jetty;
        Server server;
        JAXRSServerFactoryBean bean;
        List servers = cxfServer.computeServerEngineData(LinkedList::new);
        try {
            this.jettySSL.initialize(cxfServer);
        }
        catch (Exception th) {
            throw new SystemException((Throwable)th);
        }
        if (controller.getFactory() instanceof JAXRSServerFactoryBean) {
            bean = (JAXRSServerFactoryBean)controller.getFactory();
            bean.setStart(false);
            server = bean.create();
        } else if (controller.getFactory() instanceof JaxWsServerFactoryBean) {
            bean = (JaxWsServerFactoryBean)controller.getFactory();
            bean.setStart(false);
            server = bean.create();
        } else {
            throw new SystemException("Don't know how to start " + controller.getFactory().getClass());
        }
        servers.add(server);
        Destination dest = server.getDestination();
        JettyHTTPServerEngine engine = null;
        if (dest instanceof JettyHTTPDestination && (jetty = (JettyHTTPDestination)dest).getEngine() instanceof JettyHTTPServerEngine) {
            engine = (JettyHTTPServerEngine)jetty.getEngine();
        }
        server.start();
        if (engine != null) {
            this.startThreadPool(engine);
        }
    }

    private void startThreadPool(JettyHTTPServerEngine engine) {
        if (this.queuedThreadPool != null) {
            engine.setThreadPool((ThreadPool)this.queuedThreadPool);
        } else if (this.useActorThreadPool && this.provision != null) {
            try {
                this.executor = (JettyActorExecutor)((Object)this.provision.newInstance(JettyActorExecutor.class));
                this.executor.setWorkerPoolConfig(this.getWorkerPoolConfig());
                this.executor.start();
                engine.setThreadPool((ThreadPool)this.executor);
            }
            catch (Exception ex) {
                logger.warn("Cannot start ActorThreadPool", (Throwable)ex);
            }
        }
    }

    @Override
    public void stop(CXFServer cxfServer) {
        List servers = cxfServer.computeServerEngineData(LinkedList::new);
        Iterator iterator = servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            try {
                server.stop();
                server.destroy();
                JettyHTTPDestination jettyDest = (JettyHTTPDestination)server.getDestination();
                JettyHTTPServerEngine jettyEngine = (JettyHTTPServerEngine)jettyDest.getEngine();
                jettyEngine.shutdown();
                iterator.remove();
            }
            catch (Exception ex) {
                logger.warn("Cannot stop Jetty {}", (Object)server.getDestination().getAddress().getAddress().getValue());
            }
        }
        if (this.executor != null) {
            try {
                this.executor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

