/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.reflection.ClassSignature;
import net.e6tech.elements.common.reflection.MethodSignature;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.reflection.Signature;
import net.e6tech.elements.common.resources.ResourcesFactory;
import net.e6tech.elements.common.resources.UnitOfWork;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.JaxRSServer;
import net.e6tech.elements.web.cxf.Observer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.message.Message;

class InstanceResourceProvider
extends PerRequestResourceProvider {
    private ResourcesFactory factory;
    private Observer observer;
    private Map<Method, String> methods = new ConcurrentHashMap<Method, String>();
    private Object prototype;
    private CXFServer server;
    private Map<Signature<?>, Map<Class<? extends Annotation>, Annotation>> annotations;

    InstanceResourceProvider(JaxRSServer server, Class resourceClass, Object prototype, Module module, ResourcesFactory factory, Observer observer) {
        super(resourceClass);
        this.server = server;
        this.observer = observer;
        this.factory = factory;
        this.prototype = prototype;
        factory.preOpen(res -> {
            if (module != null) {
                res.addModule(module);
            }
            if (server.getExceptionMapper() != null) {
                res.rebind(ExceptionMapper.class, (Object)server.getExceptionMapper());
                res.rebind(server.getExceptionMapper().getClass(), (Object)server.getExceptionMapper());
            }
        });
        this.annotations = Reflection.getAnnotations((Class)resourceClass);
    }

    protected Object createInstance(Message message) {
        Object instance = super.createInstance(message);
        if (this.prototype != null) {
            Reflection.copyInstance((Object)instance, (Object)this.prototype);
        }
        Observer cloneObserver = this.observer == null ? null : this.observer.clone();
        UnitOfWork uow = cloneObserver != null ? cloneObserver.open(this.factory) : this.factory.open();
        return this.server.getInterceptor().newInterceptor(instance, (InterceptorHandler)new Handler(uow, this.methods, cloneObserver, message));
    }

    private class Handler
    implements InterceptorHandler {
        UnitOfWork uow;
        Message message;
        Observer observer;
        Map<Method, String> methods;

        Handler(UnitOfWork uow, Map<Method, String> methods, Observer observer, Message message) {
            this.uow = uow;
            this.message = message;
            this.observer = observer;
            this.methods = methods;
        }

        private void open(Object target, Method method) {
            Class<?> cls = target.getClass();
            ClassSignature classSignature = new ClassSignature(cls);
            Map map = InstanceResourceProvider.this.annotations.getOrDefault(classSignature, new HashMap());
            MethodSignature methodSignature = new MethodSignature(method);
            Map map2 = InstanceResourceProvider.this.annotations.getOrDefault(methodSignature, new HashMap());
            for (Map.Entry entry : map.entrySet()) {
                this.uow.put((Class)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : map2.entrySet()) {
                this.uow.put((Class)entry.getKey(), entry.getValue());
            }
            this.uow.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(CallFrame frame) throws Throwable {
            boolean abort = false;
            Object result = null;
            boolean ignored = false;
            boolean uowOpen = false;
            if (frame.getAnnotation(PreDestroy.class) != null) {
                ignored = true;
            } else {
                try {
                    this.open(frame.getTarget(), frame.getMethod());
                    uowOpen = true;
                }
                catch (Exception th) {
                    JaxRSServer.getLogger().debug(th.getMessage(), (Throwable)th);
                    InstanceResourceProvider.this.server.handleException(this.message, frame, th);
                }
            }
            try {
                InstanceResourceProvider.this.server.checkInvocation(frame.getMethod(), frame.getArguments());
                Pair<HttpServletRequest, HttpServletResponse> pair = InstanceResourceProvider.this.server.getServletRequestResponse(this.message);
                if (!ignored) {
                    long start = System.currentTimeMillis();
                    result = this.uow.submit(() -> {
                        if (this.observer != null) {
                            this.uow.getResources().inject((Object)this.observer);
                            CachedOutputStream cachedOutputStream = (CachedOutputStream)this.message.getContent(CachedOutputStream.class);
                            if (cachedOutputStream != null) {
                                ((HttpServletRequest)pair.key()).setAttribute("Content", (Object)cachedOutputStream.getBytes());
                            }
                            this.observer.beforeInvocation((HttpServletRequest)pair.key(), (HttpServletResponse)pair.value(), frame.getTarget(), frame.getMethod(), frame.getArguments());
                        }
                        this.uow.getResources().inject(frame.getTarget());
                        Object ret = frame.invoke();
                        if (this.observer != null) {
                            this.observer.afterInvocation(ret);
                        }
                        return ret;
                    });
                    long duration = System.currentTimeMillis() - start;
                    InstanceResourceProvider.this.server.computePerformance(frame.getMethod(), this.methods, duration);
                } else {
                    result = frame.invoke();
                }
            }
            catch (Exception th) {
                if (!ignored && this.observer != null) {
                    try {
                        this.observer.onException(th);
                    }
                    catch (Exception ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                InstanceResourceProvider.this.server.recordFailure(frame.getMethod(), this.methods);
                abort = true;
                JaxRSServer.getLogger().debug(th.getMessage(), (Throwable)th);
                InstanceResourceProvider.this.server.handleException(this.message, frame, th);
            }
            finally {
                if (uowOpen) {
                    if (abort) {
                        this.uow.abort();
                    } else if (!this.uow.isAborted()) {
                        this.uow.commit();
                    }
                }
            }
            return result;
        }
    }
}

