/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.tomcat;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Servlet;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.JaxRSServlet;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.ServerEngine;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;

public class TomcatEngine
extends ServerEngine {
    private static Logger logger = Logger.getLogger();
    private int maxThreads = 250;
    private int minSpareThreads = 10;
    private int maxConnections = 10000;
    private String baseDir;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void start(CXFServer cxfServer, ServerController<?> controller) {
        List tomcats = cxfServer.computeServerEngineData(LinkedList::new);
        Tomcat tomcat = new Tomcat();
        tomcats.add(tomcat);
        JaxRSServlet servlet = new JaxRSServlet((JAXRSServerFactoryBean)controller.getFactory());
        String context = controller.getURL().getPath();
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        Context ctx = tomcat.addContext(context, null);
        tomcat.addServlet(context, "jaxrs", (Servlet)servlet);
        if (this.baseDir != null) {
            tomcat.setBaseDir(this.baseDir + "." + controller.getURL().getPort());
        }
        ctx.addServletMappingDecoded("/*", "jaxrs");
        try {
            Connector connector = this.createConnector(cxfServer, controller.getURL());
            connector.setPort(controller.getURL().getPort());
            tomcat.setConnector(connector);
            tomcat.start();
        }
        catch (LifecycleException e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Override
    public void stop(CXFServer cxfServer) {
        List tomcats = cxfServer.computeServerEngineData(LinkedList::new);
        Iterator iterator = tomcats.iterator();
        while (iterator.hasNext()) {
            Tomcat tomcat = (Tomcat)iterator.next();
            try {
                tomcat.stop();
                tomcat.destroy();
                iterator.remove();
            }
            catch (Exception ex) {
                StringBuilder builder = new StringBuilder();
                for (Container container : tomcat.getHost().findChildren()) {
                    if (!(container instanceof Context)) continue;
                    builder.append(" " + ((Context)container).getPath());
                }
                logger.warn("Cannot stop Tomcat" + builder.toString());
            }
        }
    }

    protected Connector createConnector(CXFServer cxfServer, URL url) {
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(url.getPort());
        connector.setAttribute("maxThreads", (Object)this.maxThreads);
        connector.setAttribute("maxConnections", (Object)this.maxConnections);
        connector.setAttribute("minSpareThreads", (Object)this.minSpareThreads);
        if ("https".equals(url.getProtocol())) {
            connector.setSecure(true);
            connector.setScheme("https");
            connector.setAttribute("protocol", (Object)"HTTP/1.1");
            connector.setAttribute("SSLEnabled", (Object)true);
            connector.setAttribute("defaultSSLHostConfigName", (Object)url.getHost());
            if (cxfServer.getKeyStoreFile() == null && cxfServer.getKeyStore() == null && cxfServer.getSelfSignedCert() == null) {
                throw new IllegalArgumentException("Missing keyStoreFile or keyStore");
            }
            SSLHostConfig config = new SSLHostConfig();
            config.setHostName(url.getHost());
            if (cxfServer.getKeyStoreFile() != null) {
                config.setCertificateKeystoreFile(cxfServer.getKeyStoreFile());
                if (cxfServer.getKeyStorePassword() != null) {
                    config.setCertificateKeystorePassword(new String(cxfServer.getKeyStorePassword()));
                }
                if (cxfServer.getKeyManagerPassword() != null) {
                    config.setCertificateKeyPassword(new String(cxfServer.getKeyManagerPassword()));
                }
                config.setCertificateKeystoreType(cxfServer.getKeyStoreFormat());
            } else if (cxfServer.getKeyStore() != null) {
                SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(config, SSLHostConfigCertificate.Type.UNDEFINED);
                certificate.setCertificateKeystore(cxfServer.getKeyStore());
                if (cxfServer.getKeyStorePassword() != null) {
                    certificate.setCertificateKeystorePassword(new String(cxfServer.getKeyStorePassword()));
                }
                if (cxfServer.getKeyManagerPassword() != null) {
                    certificate.setCertificateKeyPassword(new String(cxfServer.getKeyManagerPassword()));
                }
                config.addCertificate(certificate);
            } else {
                SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(config, SSLHostConfigCertificate.Type.UNDEFINED);
                certificate.setCertificateKeystore(cxfServer.getSelfSignedCert().getKeyStore());
                certificate.setCertificateKeystorePassword(new String(cxfServer.getSelfSignedCert().getPassword()));
                certificate.setCertificateKeyPassword(new String(cxfServer.getSelfSignedCert().getPassword()));
                config.addCertificate(certificate);
            }
            if (cxfServer.getClientAuth() != null) {
                config.setCertificateVerification(cxfServer.getClientAuth());
            }
            config.setSslProtocol(cxfServer.getSslProtocol());
            connector.addSslHostConfig(config);
        }
        return connector;
    }
}

