/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.InstanceResourceProvider;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.JaxRSServerController;
import net.e6tech.elements.web.cxf.Observer;
import net.e6tech.elements.web.cxf.SecurityAnnotationEngine;
import net.e6tech.elements.web.cxf.ServerController;
import net.e6tech.elements.web.cxf.SharedResourceProvider;
import net.e6tech.elements.web.cxf.StatusException;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;

public class JaxRSServer
extends CXFServer {
    private static final String CLASS = "class";
    private static final String CLASS_LOADER = "classLoader";
    private static final String SINGLETON = "singleton";
    private static final String BIND_HEADER_OBSERVER = "bindHeaderObserver";
    private static final String REGISTER_BEAN = "registerBean";
    private static final String NAME = "name";
    private static final String PROTOTYPE = "prototype";
    private static final Logger messageLogger;
    private static final Map<Integer, JaxRSServerController> entries;
    private static Logger logger;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    private Map<String, Object> instances = new ConcurrentHashMap<String, Object>();
    private boolean corsFilter = false;
    private SecurityAnnotationEngine securityAnnotationEngine;
    private Configuration.Resolver resolver;
    private ClassLoader classLoader;
    private LogEventSender logEventSender;

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        JaxRSServer.logger = logger;
    }

    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    public void setResources(List<Map<String, Object>> resources) {
        this.resources = resources;
    }

    public Map<String, Object> getInstances() {
        return this.instances;
    }

    public Object getInstance(String name) {
        return this.instances.get(name);
    }

    public boolean isCorsFilter() {
        return this.corsFilter;
    }

    public void setCorsFilter(boolean corsFilter) {
        this.corsFilter = corsFilter;
    }

    public SecurityAnnotationEngine getSecurityAnnotationEngine() {
        return this.securityAnnotationEngine;
    }

    @Inject(optional=true)
    public void setSecurityAnnotationEngine(SecurityAnnotationEngine securityAnnotationEngine) {
        this.securityAnnotationEngine = securityAnnotationEngine;
    }

    @Inject(optional=true)
    public Configuration.Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Configuration.Resolver resolver) {
        this.resolver = resolver;
    }

    public LogEventSender getLogEventSender() {
        return this.logEventSender;
    }

    public void setLogEventSender(LogEventSender logEventSender) {
        this.logEventSender = logEventSender;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Resources res) {
        if (this.getURLs().isEmpty()) {
            throw new IllegalStateException("address not set");
        }
        ArrayList<JaxRSServerController> entryList = new ArrayList<JaxRSServerController>();
        Map<Integer, JaxRSServerController> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                JaxRSServerController controller = entries.computeIfAbsent(uRL.getPort(), port -> new JaxRSServerController(url, new JAXRSServerFactoryBean()));
                if (!controller.getURL().equals(uRL)) {
                    throw new SystemException("Cannot register " + uRL.toExternalForm() + ".  Already a service at " + uRL.toExternalForm());
                }
                JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)controller.getFactory();
                bean.setAddress(uRL.toExternalForm());
                entries.put(uRL.getPort(), controller);
                entryList.add(controller);
            }
        }
        ArrayList resourceClasses = new ArrayList();
        for (Map map2 : this.resources) {
            Object resourceProvider;
            boolean bindHeaderObserver;
            boolean singleton = false;
            Class<?> resourceClass = null;
            String resourceClassName = (String)map2.get(CLASS);
            if (resourceClassName == null) {
                throw new SystemException("Missing resource class in resources map");
            }
            try {
                String classLoaderExpression = (String)map2.get(CLASS_LOADER);
                ClassLoader loader = null;
                if (classLoaderExpression != null && this.resolver != null) {
                    loader = (ClassLoader)this.resolver.resolve(classLoaderExpression);
                }
                if (loader == null) {
                    loader = this.classLoader == null ? this.getProvision().getClass().getClassLoader() : this.classLoader;
                }
                resourceClass = loader.loadClass(resourceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SystemException((Throwable)e);
            }
            Observer hObserver = this.getHeaderObserver();
            boolean bl = bindHeaderObserver = map2.get(BIND_HEADER_OBSERVER) == null ? true : (Boolean)map2.get(BIND_HEADER_OBSERVER);
            if (!bindHeaderObserver) {
                hObserver = null;
            }
            this.injectInitialize(res, hObserver);
            Object s = map2.get(SINGLETON);
            singleton = s instanceof String && "true".equalsIgnoreCase(s.toString().trim()) ? true : (s == null ? false : (Boolean)map2.get(SINGLETON));
            String resourceName = (String)map2.get(NAME);
            Object prototype = null;
            String prototypeExpression = (String)map2.get(PROTOTYPE);
            if (prototypeExpression != null && this.resolver != null) {
                prototype = this.resolver.resolve(prototypeExpression);
            }
            if (this.securityAnnotationEngine != null) {
                this.securityAnnotationEngine.register(resourceClass);
            }
            if (singleton) {
                if (prototype == null) {
                    try {
                        prototype = resourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new SystemException((Throwable)e);
                    }
                    this.injectInitialize(res, prototype);
                }
                resourceProvider = new SharedResourceProvider(this, prototype, hObserver);
                String beanName = (String)map2.get(REGISTER_BEAN);
                if (beanName != null) {
                    this.getProvision().getResourceManager().registerBean(beanName, prototype);
                }
            } else {
                Module module = res == null ? null : res.getModule();
                resourceProvider = new InstanceResourceProvider(this, resourceClass, prototype, module, this.getProvision(), hObserver);
            }
            for (JaxRSServerController entry : entryList) {
                ((JAXRSServerFactoryBean)entry.getFactory()).setResourceProvider(resourceClass, (ResourceProvider)resourceProvider);
            }
            if (resourceName != null && prototype != null) {
                this.instances.put(resourceName, prototype);
            }
            resourceClasses.add(resourceClass);
        }
        if (this.securityAnnotationEngine != null) {
            this.securityAnnotationEngine.logMethodMap();
        }
        for (JaxRSServerController jaxRSServerController : entryList) {
            jaxRSServerController.addResourceClasses(resourceClasses);
        }
        super.initialize(res);
    }

    private void injectInitialize(Resources res, Object object) {
        if (res != null) {
            if (object != null) {
                res.inject(object);
            }
        } else if (object != null) {
            this.getProvision().inject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        LinkedList beans = new LinkedList();
        LinkedList<JaxRSServerController> controllers = new LinkedList<JaxRSServerController>();
        Map<Integer, JaxRSServerController> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                JaxRSServerController controller = entries.get(uRL.getPort());
                if (controller == null) continue;
                beans.add(controller.getFactory());
                ((JAXRSServerFactoryBean)controller.getFactory()).setResourceClasses(controller.getResourceClasses());
                entries.remove(uRL.getPort());
                controllers.add(controller);
            }
        }
        for (JAXRSServerFactoryBean bean : beans) {
            bean.getBus().setProperty("skip.default.json.provider.registration", (Object)true);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.WRAP_ROOT_VALUE).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JacksonJaxbJsonProvider jackson = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        for (Object bean : beans) {
            bean.setProvider((Object)jackson);
        }
        if (this.isCorsFilter()) {
            logger.info("enabling CORS filter");
            CrossOriginResourceSharingFilter crossOriginResourceSharingFilter = new CrossOriginResourceSharingFilter();
            for (JAXRSServerFactoryBean bean : beans) {
                bean.setProvider((Object)crossOriginResourceSharingFilter);
            }
        }
        LoggingFeature loggingFeature = new LoggingFeature();
        DefaultLogEventSender sender = new DefaultLogEventSender();
        loggingFeature.setInSender((LogEventSender)sender);
        loggingFeature.setOutSender((LogEventSender)sender);
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.getFeatures().add(loggingFeature);
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.setProvider((Object)new InternalExceptionMapper(this.getExceptionMapper()));
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            logger.info("Starting Restful at address {} {} ", (Object)jAXRSServerFactoryBean.getAddress(), (Object)jAXRSServerFactoryBean.getResourceClasses());
        }
        for (ServerController serverController : controllers) {
            this.addController(serverController);
        }
        super.start();
    }

    static {
        System.setProperty("org.apache.cxf.useSpringClassHelpers", "false");
        messageLogger = Logger.getLogger((String)(JaxRSServer.class.getName() + ".message"));
        entries = new ConcurrentHashMap<Integer, JaxRSServerController>();
        logger = Logger.getLogger();
    }

    @Provider
    private static class InternalExceptionMapper
    implements ExceptionMapper<Exception> {
        net.e6tech.elements.common.util.ExceptionMapper mapper;

        InternalExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper mapper) {
            this.mapper = mapper;
        }

        public Response toResponse(Exception exception) {
            Object response;
            Response.Status status = Response.Status.BAD_REQUEST;
            if (exception instanceof BadRequestException) {
                status = Response.Status.BAD_REQUEST;
            } else if (exception instanceof NotAuthorizedException) {
                status = Response.Status.UNAUTHORIZED;
            } else if (exception instanceof ForbiddenException) {
                status = Response.Status.FORBIDDEN;
            } else if (exception instanceof NotFoundException) {
                status = Response.Status.NOT_FOUND;
            } else if (exception instanceof NotAllowedException) {
                status = Response.Status.METHOD_NOT_ALLOWED;
            } else if (exception instanceof NotAcceptableException) {
                status = Response.Status.NOT_ACCEPTABLE;
            } else if (exception instanceof NotSupportedException) {
                status = Response.Status.UNSUPPORTED_MEDIA_TYPE;
            } else if (exception instanceof InternalServerErrorException) {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            } else if (exception instanceof ServiceUnavailableException) {
                status = Response.Status.SERVICE_UNAVAILABLE;
            }
            if (exception instanceof InvocationException) {
                response = ((InvocationException)exception).getResponse();
            } else if (exception instanceof StatusException) {
                StatusException statusException = (StatusException)exception;
                status = statusException.getStatus();
                response = this.mapper != null ? this.mapper.toResponse(statusException.getCause()) : statusException.getCause().getMessage();
            } else {
                response = this.mapper != null ? this.mapper.toResponse((Throwable)exception) : exception.getMessage();
            }
            return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        }
    }

    private class DefaultLogEventSender
    implements LogEventSender {
        private DefaultLogEventSender() {
        }

        public void send(LogEvent event) {
            if (messageLogger.isTraceEnabled()) {
                messageLogger.trace(this.getLogMessage(event));
            }
            if (JaxRSServer.this.logEventSender != null) {
                JaxRSServer.this.logEventSender.send(event);
            }
        }

        private String getLogMessage(LogEvent event) {
            return LogMessageFormatter.format((LogEvent)event);
        }
    }
}

