/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.management.JMException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Configuration;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.web.JaxExceptionHandler;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.Observer;
import net.e6tech.elements.web.cxf.SecurityAnnotationEngine;
import net.e6tech.elements.web.cxf.StatusException;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.LogMessageFormatter;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;

public class JaxRSServer
extends CXFServer {
    private static final String CLASS = "class";
    private static final String SINGLETON = "singleton";
    private static final String BIND_HEADER_OBSERVER = "bindHeaderObserver";
    private static final String REGISTER_BEAN = "registerBean";
    private static final String NAME = "name";
    private static final String PROTOTYPE = "prototype";
    private static Logger messageLogger;
    private static Map<Integer, ServerFactorBeanEntry> entries;
    private static Logger logger;
    private Observer headerObserver;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    private net.e6tech.elements.common.util.ExceptionMapper exceptionMapper;
    private Map<String, Object> instances = new Hashtable<String, Object>();
    private boolean corsFilter = false;
    private boolean measurement = false;
    private SecurityAnnotationEngine securityAnnotationEngine;
    private Configuration.Resolver resolver;
    private Map<String, String> responseHeaders = new LinkedHashMap<String, String>();
    private LogEventSender logEventSender;

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        JaxRSServer.logger = logger;
    }

    @Inject(optional=true)
    public Observer getHeaderObserver() {
        return this.headerObserver;
    }

    public void setHeaderObserver(Observer headerObserver) {
        this.headerObserver = headerObserver;
    }

    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    public void setResources(List<Map<String, Object>> resources) {
        this.resources = resources;
    }

    public net.e6tech.elements.common.util.ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @Inject(optional=true)
    public void setExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public Map<String, Object> getInstances() {
        return this.instances;
    }

    public Object getInstance(String name) {
        return this.instances.get(name);
    }

    public boolean isCorsFilter() {
        return this.corsFilter;
    }

    public void setCorsFilter(boolean corsFilter) {
        this.corsFilter = corsFilter;
    }

    public SecurityAnnotationEngine getSecurityAnnotationEngine() {
        return this.securityAnnotationEngine;
    }

    @Inject(optional=true)
    public void setSecurityAnnotationEngine(SecurityAnnotationEngine securityAnnotationEngine) {
        this.securityAnnotationEngine = securityAnnotationEngine;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    @Inject(optional=true)
    public Configuration.Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Configuration.Resolver resolver) {
        this.resolver = resolver;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public LogEventSender getLogEventSender() {
        return this.logEventSender;
    }

    public void setLogEventSender(LogEventSender logEventSender) {
        this.logEventSender = logEventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Resources res) {
        if (this.getURLs().isEmpty()) {
            throw new IllegalStateException("address not set");
        }
        if (res != null) {
            res.getNotificationCenter().addNotificationListener(ShutdownNotification.class, NotificationListener.wrap((String)("JaxRSServer" + this.getURLs()), notification -> this.stop()));
        }
        ArrayList<ServerFactorBeanEntry> entryList = new ArrayList<ServerFactorBeanEntry>();
        Map<Integer, ServerFactorBeanEntry> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                ServerFactorBeanEntry entry = entries.computeIfAbsent(uRL.getPort(), port -> new ServerFactorBeanEntry(url, new JAXRSServerFactoryBean()));
                if (!entry.getURL().equals(uRL)) {
                    throw new SystemException("Cannot register " + uRL.toExternalForm() + ".  Already a service at " + uRL.toExternalForm());
                }
                JAXRSServerFactoryBean bean = entry.getFactoryBean();
                bean.setAddress(uRL.toExternalForm());
                entries.put(uRL.getPort(), entry);
                entryList.add(entry);
            }
        }
        ArrayList resourceClasses = new ArrayList();
        for (Map map2 : this.resources) {
            Object resourceProvider;
            boolean bindHeaderObserver;
            boolean singleton = false;
            Class<?> resourceClass = null;
            String prototypeExpression = null;
            String resourceClassName = (String)map2.get(CLASS);
            if (resourceClassName == null) {
                throw new SystemException("Missing resource class in resources map");
            }
            try {
                resourceClass = this.getProvision().getClass().getClassLoader().loadClass(resourceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SystemException((Throwable)e);
            }
            Observer hObserver = this.headerObserver;
            boolean bl = bindHeaderObserver = map2.get(BIND_HEADER_OBSERVER) == null ? true : (Boolean)map2.get(BIND_HEADER_OBSERVER);
            if (!bindHeaderObserver) {
                hObserver = null;
            }
            this.injectInitialize(res, hObserver);
            Object s = map2.get(SINGLETON);
            singleton = s instanceof String && "true".equalsIgnoreCase(s.toString().trim()) ? true : (s == null ? false : (Boolean)map2.get(SINGLETON));
            String resourceName = (String)map2.get(NAME);
            Object prototype = null;
            prototypeExpression = (String)map2.get(PROTOTYPE);
            if (prototypeExpression != null && this.resolver != null) {
                prototype = this.resolver.resolve(prototypeExpression);
            }
            Object instance = null;
            try {
                instance = resourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.injectInitialize(res, instance);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            if (this.securityAnnotationEngine != null) {
                this.securityAnnotationEngine.register(resourceClass);
            }
            if (singleton) {
                if (prototype == null) {
                    prototype = instance;
                }
                resourceProvider = new SharedResourceProvider(map2, prototype, hObserver);
                String beanName = (String)map2.get(REGISTER_BEAN);
                if (beanName != null) {
                    this.getProvision().getResourceManager().registerBean(beanName, prototype);
                }
            } else {
                resourceProvider = new InstanceResourceProvider(map2, resourceClass, prototype, res.getModule(), this.getProvision(), hObserver);
            }
            for (ServerFactorBeanEntry entry : entryList) {
                entry.getFactoryBean().setResourceProvider(resourceClass, (ResourceProvider)resourceProvider);
            }
            if (resourceName != null && prototype != null) {
                this.instances.put(resourceName, prototype);
            }
            resourceClasses.add(resourceClass);
        }
        if (this.securityAnnotationEngine != null) {
            this.securityAnnotationEngine.logMethodMap();
        }
        for (ServerFactorBeanEntry serverFactorBeanEntry : entryList) {
            serverFactorBeanEntry.addResourceClasses(resourceClasses);
        }
        super.initialize(res);
    }

    private void injectInitialize(Resources res, Object object) {
        if (res != null) {
            if (object != null) {
                res.inject(object);
            }
        } else if (object != null) {
            this.getProvision().inject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            this.initKeyStore();
        }
        catch (Exception th) {
            throw new SystemException((Throwable)th);
        }
        ArrayList<JAXRSServerFactoryBean> beans = new ArrayList<JAXRSServerFactoryBean>();
        Map<Integer, ServerFactorBeanEntry> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                ServerFactorBeanEntry serverFactorBeanEntry = entries.get(uRL.getPort());
                if (serverFactorBeanEntry == null) continue;
                beans.add(serverFactorBeanEntry.getFactoryBean());
                serverFactorBeanEntry.getFactoryBean().setResourceClasses(serverFactorBeanEntry.getResourceClasses());
                entries.remove(uRL.getPort());
            }
        }
        for (JAXRSServerFactoryBean bean : beans) {
            bean.getBus().setProperty("skip.default.json.provider.registration", (Object)true);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.WRAP_ROOT_VALUE).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JacksonJaxbJsonProvider jackson = new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.setProvider((Object)jackson);
        }
        if (this.isCorsFilter()) {
            logger.info("enabling CORS filter");
            CrossOriginResourceSharingFilter crossOriginResourceSharingFilter = new CrossOriginResourceSharingFilter();
            for (JAXRSServerFactoryBean bean : beans) {
                bean.setProvider((Object)crossOriginResourceSharingFilter);
            }
        }
        LoggingFeature loggingFeature = new LoggingFeature();
        DefaultLogEventSender defaultLogEventSender = new DefaultLogEventSender();
        loggingFeature.setInSender((LogEventSender)defaultLogEventSender);
        loggingFeature.setOutSender((LogEventSender)defaultLogEventSender);
        for (JAXRSServerFactoryBean bean : beans) {
            bean.getFeatures().add(loggingFeature);
        }
        for (JAXRSServerFactoryBean bean : beans) {
            bean.setProvider((Object)new InternalExceptionMapper(this.exceptionMapper));
        }
        for (JAXRSServerFactoryBean bean : beans) {
            logger.info("Starting Restful at address {} {} ", (Object)bean.getAddress(), (Object)bean.getResourceClasses());
        }
        for (JAXRSServerFactoryBean bean : beans) {
            try {
                bean.setStart(false);
                this.registerServer(bean.create());
            }
            catch (Exception ex) {
                throw new SystemException("Cannot start RESTful service at " + bean.getAddress(), (Throwable)ex);
            }
        }
        super.start();
    }

    private void handleException(CallFrame frame, Throwable th) throws Throwable {
        Throwable throwable = net.e6tech.elements.common.util.ExceptionMapper.unwrap((Throwable)th);
        if (frame.getTarget() instanceof JaxExceptionHandler) {
            Object response = ((JaxExceptionHandler)frame.getTarget()).handleException(frame, throwable);
            if (response != null) {
                throw new InvocationException(response);
            }
        } else {
            throw throwable;
        }
    }

    private Pair<HttpServletRequest, HttpServletResponse> getSevletRequestResponse(Message message) {
        Pair pair = new Pair(null, null);
        if (message != null) {
            HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            pair = new Pair((Object)request, (Object)response);
            if (response != null) {
                this.responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            }
        }
        return pair;
    }

    private void computePerformance(Method method, Map<Method, String> methods, Map<String, Object> map, long duration) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"add", (Object[])new Object[]{duration});
        }
        catch (Exception e) {
            logger.debug("Unable to record measurement for " + method, (Throwable)e);
        }
    }

    private void recordFailure(Method method, Map<Method, String> methods, Map<String, Object> map) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"fail", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Unable to record fail measurement for " + method, (Throwable)e);
        }
    }

    private ObjectInstance getMeasurement(Method method, Map<Method, String> methods) throws JMException {
        String methodName = methods.computeIfAbsent(method, m -> {
            StringBuilder builder = new StringBuilder();
            builder.append(m.getDeclaringClass().getTypeName());
            builder.append(".");
            builder.append(m.getName());
            Class<?>[] types = m.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                builder.append("|");
                builder.append(types[i].getSimpleName());
            }
            return builder.toString();
        });
        String objectName = "net.e6tech:type=Restful,name=" + methodName;
        return JMXService.registerIfAbsent((String)objectName, () -> new Measurement(methodName, "ms", this.measurement));
    }

    private static void checkInvocation(Method method, Object[] args) {
        Parameter[] params = method.getParameters();
        int idx = 0;
        StringBuilder builder = null;
        String CANNOT_BE_NULL = " cannot be null. \n";
        for (Parameter param : params) {
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            PathParam pathParam = param.getAnnotation(PathParam.class);
            if (args[idx] == null || args[idx] instanceof String && ((String)args[idx]).trim().isEmpty()) {
                if (pathParam != null) {
                    if (builder == null) {
                        builder = new StringBuilder();
                    }
                    builder.append("path parameter ").append(pathParam.value()).append(" cannot be null. \n");
                }
                if (param.getAnnotation(Nonnull.class) != null) {
                    if (queryParam != null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("query parameter ").append(queryParam.value()).append(" cannot be null. \n");
                    } else if (pathParam == null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("post parameter ").append("arg").append(idx).append(" cannot be null. \n");
                    }
                }
            }
            ++idx;
        }
        if (builder != null) {
            throw new IllegalArgumentException(builder.toString());
        }
    }

    static {
        System.setProperty("org.apache.cxf.useSpringClassHelpers", "false");
        messageLogger = Logger.getLogger((String)(JaxRSServer.class.getName() + ".message"));
        entries = new Hashtable<Integer, ServerFactorBeanEntry>();
        logger = Logger.getLogger();
    }

    @Provider
    private static class InternalExceptionMapper
    implements ExceptionMapper<Exception> {
        net.e6tech.elements.common.util.ExceptionMapper mapper;

        public InternalExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper mapper) {
            this.mapper = mapper;
        }

        public Response toResponse(Exception exception) {
            Object response;
            Response.Status status = Response.Status.BAD_REQUEST;
            if (exception instanceof BadRequestException) {
                status = Response.Status.BAD_REQUEST;
            } else if (exception instanceof NotAuthorizedException) {
                status = Response.Status.UNAUTHORIZED;
            } else if (exception instanceof ForbiddenException) {
                status = Response.Status.FORBIDDEN;
            } else if (exception instanceof NotFoundException) {
                status = Response.Status.NOT_FOUND;
            } else if (exception instanceof NotAllowedException) {
                status = Response.Status.METHOD_NOT_ALLOWED;
            } else if (exception instanceof NotAcceptableException) {
                status = Response.Status.NOT_ACCEPTABLE;
            } else if (exception instanceof NotSupportedException) {
                status = Response.Status.UNSUPPORTED_MEDIA_TYPE;
            } else if (exception instanceof InternalServerErrorException) {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            } else if (exception instanceof ServiceUnavailableException) {
                status = Response.Status.SERVICE_UNAVAILABLE;
            }
            if (exception instanceof InvocationException) {
                response = ((InvocationException)exception).getResponse();
            } else if (exception instanceof StatusException) {
                StatusException statusException = (StatusException)exception;
                status = statusException.getStatus();
                response = this.mapper != null ? this.mapper.toResponse(statusException.getCause()) : statusException.getCause().getMessage();
            } else {
                response = this.mapper != null ? this.mapper.toResponse((Throwable)exception) : exception.getMessage();
            }
            return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        }
    }

    private static class ServerFactorBeanEntry {
        JAXRSServerFactoryBean bean;
        URL url;
        List<Class<?>> resourceClasses = new ArrayList();

        ServerFactorBeanEntry(URL url, JAXRSServerFactoryBean bean) {
            this.url = url;
            this.bean = bean;
        }

        synchronized URL getURL() {
            return this.url;
        }

        JAXRSServerFactoryBean getFactoryBean() {
            return this.bean;
        }

        synchronized void addResourceClasses(List<Class<?>> list) {
            this.resourceClasses.addAll(list);
        }

        List<Class<?>> getResourceClasses() {
            return this.resourceClasses;
        }
    }

    private class SharedResourceProvider
    extends SingletonResourceProvider {
        Observer observer;
        Object proxy;
        Map<String, Object> map;
        Map<Method, String> methods;

        public SharedResourceProvider(Map<String, Object> map, Object instance, Observer observer) {
            super(instance, true);
            this.proxy = null;
            this.methods = new Hashtable<Method, String>();
            this.observer = observer;
            this.map = map;
        }

        public Object getInstance(Message m) {
            Observer cloneObserver;
            Observer observer = cloneObserver = this.observer != null ? this.observer.clone() : null;
            if (this.proxy == null) {
                this.proxy = JaxRSServer.this.getInterceptor().newInterceptor(super.getInstance(m), frame -> {
                    try {
                        JaxRSServer.checkInvocation(frame.getMethod(), frame.getArguments());
                        Pair pair = JaxRSServer.this.getSevletRequestResponse(m);
                        if (cloneObserver != null) {
                            JaxRSServer.this.getProvision().inject((Object)cloneObserver);
                            cloneObserver.beforeInvocation((HttpServletRequest)pair.key(), (HttpServletResponse)pair.value(), frame.getTarget(), frame.getMethod(), frame.getArguments());
                        }
                        long start = System.currentTimeMillis();
                        Object result = frame.invoke();
                        long duration = System.currentTimeMillis() - start;
                        JaxRSServer.this.computePerformance(frame.getMethod(), this.methods, this.map, duration);
                        if (cloneObserver != null) {
                            cloneObserver.afterInvocation(result);
                        }
                        return result;
                    }
                    catch (Exception th) {
                        if (cloneObserver != null) {
                            cloneObserver.onException(th);
                        }
                        JaxRSServer.this.recordFailure(frame.getMethod(), this.methods, this.map);
                        logger.debug(th.getMessage(), (Throwable)th);
                        JaxRSServer.this.handleException(frame, th);
                        return null;
                    }
                });
            }
            return this.proxy;
        }
    }

    private class Handler
    implements InterceptorHandler {
        UnitOfWork uow;
        Message message;
        Observer observer;
        Map<String, Object> map;
        Map<Method, String> methods;

        public Handler(UnitOfWork uow, Map<String, Object> map, Map<Method, String> methods, Observer observer, Message message) {
            this.uow = uow;
            this.message = message;
            this.observer = observer;
            this.map = map;
            this.methods = methods;
        }

        private void open(Object target, Method method) {
            Class<?> cls = target.getClass();
            for (Annotation annotation : cls.getAnnotations()) {
                this.uow.put(annotation.annotationType(), (Object)annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                this.uow.put(annotation.annotationType(), (Object)annotation);
            }
            this.uow.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(CallFrame frame) throws Throwable {
            boolean abort = false;
            Object result = null;
            boolean ignored = false;
            boolean uowOpen = false;
            if (frame.getAnnotation(PreDestroy.class) != null) {
                ignored = true;
            } else {
                try {
                    this.open(frame.getTarget(), frame.getMethod());
                    uowOpen = true;
                }
                catch (Exception th) {
                    logger.debug(th.getMessage(), (Throwable)th);
                    JaxRSServer.this.handleException(frame, th);
                }
            }
            try {
                JaxRSServer.checkInvocation(frame.getMethod(), frame.getArguments());
                Pair pair = JaxRSServer.this.getSevletRequestResponse(this.message);
                if (!ignored) {
                    long start = System.currentTimeMillis();
                    result = this.uow.submit(() -> {
                        if (this.observer != null) {
                            this.uow.getResources().inject((Object)this.observer);
                            this.observer.beforeInvocation((HttpServletRequest)pair.key(), (HttpServletResponse)pair.value(), frame.getTarget(), frame.getMethod(), frame.getArguments());
                        }
                        this.uow.getResources().inject(frame.getTarget());
                        Object ret = frame.invoke();
                        if (this.observer != null) {
                            this.observer.afterInvocation(ret);
                        }
                        return ret;
                    });
                    long duration = System.currentTimeMillis() - start;
                    JaxRSServer.this.computePerformance(frame.getMethod(), this.methods, this.map, duration);
                } else {
                    result = frame.invoke();
                }
            }
            catch (Exception th) {
                if (!ignored && this.observer != null) {
                    try {
                        this.observer.onException(th);
                    }
                    catch (Exception ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                JaxRSServer.this.recordFailure(frame.getMethod(), this.methods, this.map);
                abort = true;
                logger.debug(th.getMessage(), (Throwable)th);
                JaxRSServer.this.handleException(frame, th);
            }
            finally {
                if (uowOpen) {
                    if (abort) {
                        this.uow.abort();
                    } else if (!this.uow.isAborted()) {
                        this.uow.commit();
                    }
                }
            }
            return result;
        }
    }

    private class InstanceResourceProvider
    extends PerRequestResourceProvider {
        private Provision provision;
        private Observer observer;
        private Module module;
        private Map<String, Object> map;
        private Map<Method, String> methods;
        private Object prototype;

        public InstanceResourceProvider(Map<String, Object> map, Class resourceClass, Object prototype, Module module, Provision provision, Observer observer) {
            super(resourceClass);
            this.methods = new Hashtable<Method, String>();
            this.provision = provision;
            this.observer = observer;
            this.module = module;
            this.map = map;
            this.prototype = prototype;
        }

        protected Object createInstance(Message message) {
            Object instance = super.createInstance(message);
            if (this.prototype != null) {
                Reflection.copyInstance((Object)instance, (Object)this.prototype);
            }
            Observer cloneObserver = this.observer == null ? null : this.observer.clone();
            UnitOfWork uow = this.provision.preOpen(res -> {
                res.addModule(this.module);
                if (JaxRSServer.this.exceptionMapper != null) {
                    res.rebind(net.e6tech.elements.common.util.ExceptionMapper.class, (Object)JaxRSServer.this.exceptionMapper);
                    res.rebind(JaxRSServer.this.exceptionMapper.getClass(), (Object)JaxRSServer.this.exceptionMapper);
                }
            });
            return JaxRSServer.this.getInterceptor().newInterceptor(instance, (InterceptorHandler)new Handler(uow, this.map, this.methods, cloneObserver, message));
        }
    }

    private class DefaultLogEventSender
    implements LogEventSender {
        private DefaultLogEventSender() {
        }

        public void send(LogEvent event) {
            if (messageLogger.isTraceEnabled()) {
                messageLogger.trace(this.getLogMessage(event));
            }
            if (JaxRSServer.this.logEventSender != null) {
                JaxRSServer.this.logEventSender.send(event);
            }
        }

        private String getLogMessage(LogEvent event) {
            return LogMessageFormatter.format((LogEvent)event);
        }
    }
}

