/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.management.JMException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.SelfSignedCert;
import net.e6tech.elements.web.JaxExceptionHandler;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.Observer;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class CXFServer
implements Initializable,
Startable {
    private static final String CANNOT_BE_NULL = " cannot be null. \n";
    private static final Logger logger = Logger.getLogger();
    private Provision provision;
    private Interceptor interceptor;
    private List<Server> servers = new ArrayList<Server>();
    private List<URL> urls = new ArrayList<URL>();
    private String keyStoreFile;
    private String keyStoreFormat = "PKCS12";
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private char[] keyManagerPassword;
    private SelfSignedCert selfSignedCert;
    private ExecutorService executor;
    private QueuedThreadPool queuedThreadPool;
    private boolean initialized = false;
    private boolean started = false;
    private boolean measurement = false;
    private Observer headerObserver;
    private ExceptionMapper exceptionMapper;
    private Map<String, String> responseHeaders = new LinkedHashMap<String, String>();

    public void setAddresses(List<String> addresses) throws MalformedURLException {
        for (String address : addresses) {
            URL url = new URL(address);
            this.urls.add(url);
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Inject
    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected List<URL> getURLs() {
        return this.urls;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public SelfSignedCert getSelfSignedCert() {
        return this.selfSignedCert;
    }

    public void setSelfSignedCert(SelfSignedCert selfSignedCert) {
        this.selfSignedCert = selfSignedCert;
    }

    public ExecutorService getThreadPool() {
        return this.executor;
    }

    @Inject(optional=true)
    public void setThreadPool(ExecutorService executor) {
        this.executor = executor;
    }

    public QueuedThreadPool getQueuedThreadPool() {
        return this.queuedThreadPool;
    }

    @Inject(optional=true)
    public void setQueuedThreadPool(QueuedThreadPool queuedThreadPool) {
        this.queuedThreadPool = queuedThreadPool;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    @Inject(optional=true)
    public Observer getHeaderObserver() {
        return this.headerObserver;
    }

    public void setHeaderObserver(Observer headerObserver) {
        this.headerObserver = headerObserver;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @Inject(optional=true)
    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    protected void registerServer(Server server) {
        if (!this.servers.contains(server)) {
            this.servers.add(server);
        }
    }

    protected void initKeyStore() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        if (this.keyStoreFile == null && this.selfSignedCert == null && this.keyStore == null) {
            return;
        }
        if (this.keyStore != null || this.keyStoreFile != null) {
            JavaKeyStore jceKeyStore = this.keyStore != null ? new JavaKeyStore(this.keyStore) : new JavaKeyStore(this.keyStoreFile, this.keyStorePassword, this.keyStoreFormat);
            if (this.keyManagerPassword == null) {
                this.keyManagerPassword = this.keyStorePassword;
            }
            jceKeyStore.init(this.keyManagerPassword);
            keyManagers = jceKeyStore.getKeyManagers();
            trustManagers = jceKeyStore.getTrustManagers();
        } else {
            keyManagers = this.selfSignedCert.getKeyManagers();
            trustManagers = this.selfSignedCert.getTrustManagers();
        }
        TLSServerParameters tlsParams = new TLSServerParameters();
        tlsParams.setKeyManagers(keyManagers);
        tlsParams.setTrustManagers(trustManagers);
        ClientAuthentication ca = new ClientAuthentication();
        ca.setRequired(Boolean.valueOf(false));
        ca.setWant(Boolean.valueOf(false));
        tlsParams.setClientAuthentication(ca);
        JettyHTTPServerEngineFactory factory = new JettyHTTPServerEngineFactory();
        for (URL url : this.urls) {
            TLSServerParameters existingParams;
            if (!"https".equals(url.getProtocol())) continue;
            JettyHTTPServerEngine engine = factory.retrieveJettyHTTPServerEngine(url.getPort());
            TLSServerParameters tLSServerParameters = existingParams = engine == null ? null : engine.getTlsServerParameters();
            if (existingParams != null) {
                LinkedHashSet keyManagerSet = new LinkedHashSet();
                if (existingParams.getKeyManagers() != null) {
                    Collections.addAll(keyManagerSet, existingParams.getKeyManagers());
                }
                if (keyManagers != null) {
                    Collections.addAll(keyManagerSet, keyManagers);
                }
                LinkedHashSet trustManagerSet = new LinkedHashSet();
                if (existingParams.getTrustManagers() != null) {
                    Collections.addAll(trustManagerSet, existingParams.getTrustManagers());
                }
                if (trustManagers != null) {
                    Collections.addAll(trustManagerSet, trustManagers);
                }
                existingParams.setKeyManagers(keyManagerSet.toArray(new KeyManager[0]));
                existingParams.setTrustManagers(trustManagerSet.toArray(new TrustManager[0]));
                continue;
            }
            factory.setTLSServerParametersForPort(url.getPort(), tlsParams);
        }
    }

    public void initialize(Resources resources) {
        this.initialized = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.initialized) {
            this.initialize(null);
        }
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.queuedThreadPool != null) {
            for (Server server : this.servers) {
                JettyHTTPDestination jetty;
                Destination dest = server.getDestination();
                if (!(dest instanceof JettyHTTPDestination) || !((jetty = (JettyHTTPDestination)dest).getEngine() instanceof JettyHTTPServerEngine)) continue;
                ((JettyHTTPServerEngine)jetty.getEngine()).setThreadPool((ThreadPool)this.queuedThreadPool);
            }
        }
        for (Server server : this.servers) {
            server.start();
        }
    }

    public void stop() {
        for (Server server : this.servers) {
            server.stop();
        }
        this.started = false;
    }

    Pair<HttpServletRequest, HttpServletResponse> getServletRequestResponse(Message message) {
        Pair pair = new Pair(null, null);
        if (message != null) {
            HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            HttpServletResponse response = (HttpServletResponse)message.get((Object)"HTTP.RESPONSE");
            pair = new Pair((Object)request, (Object)response);
            if (response != null) {
                this.getResponseHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            }
        }
        return pair;
    }

    void handleException(CallFrame frame, Throwable th) throws Throwable {
        Throwable throwable = ExceptionMapper.unwrap((Throwable)th);
        if (frame.getTarget() instanceof JaxExceptionHandler) {
            Object response = ((JaxExceptionHandler)frame.getTarget()).handleException(frame, throwable);
            if (response != null) {
                throw new InvocationException(response);
            }
        } else {
            throw throwable;
        }
    }

    void computePerformance(Method method, Map<Method, String> methods, long duration) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            logger.trace("{} call took {}ms", (Object)instance.getObjectName().getCanonicalName(), (Object)duration);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"add", (Object[])new Object[]{duration});
        }
        catch (Exception e) {
            logger.debug("Unable to record measurement for " + method, (Throwable)e);
        }
    }

    void recordFailure(Method method, Map<Method, String> methods) {
        try {
            ObjectInstance instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"fail", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Unable to record fail measurement for " + method, (Throwable)e);
        }
    }

    private ObjectInstance getMeasurement(Method method, Map<Method, String> methods) throws JMException {
        String methodName = methods.computeIfAbsent(method, m -> {
            StringBuilder builder = new StringBuilder();
            builder.append(m.getDeclaringClass().getTypeName());
            builder.append(".");
            builder.append(m.getName());
            Class<?>[] types = m.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                builder.append("|");
                builder.append(types[i].getSimpleName());
            }
            return builder.toString();
        });
        String objectName = "net.e6tech:type=Restful,name=" + methodName;
        return JMXService.registerIfAbsent((String)objectName, () -> new Measurement(methodName, "ms", this.isMeasurement()));
    }

    void checkInvocation(Method method, Object[] args) {
        Parameter[] params = method.getParameters();
        int idx = 0;
        StringBuilder builder = null;
        for (Parameter param : params) {
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            PathParam pathParam = param.getAnnotation(PathParam.class);
            if (args[idx] == null || args[idx] instanceof String && ((String)args[idx]).trim().isEmpty()) {
                if (pathParam != null) {
                    if (builder == null) {
                        builder = new StringBuilder();
                    }
                    builder.append("path parameter ").append(pathParam.value()).append(CANNOT_BE_NULL);
                }
                if (param.getAnnotation(Nonnull.class) != null) {
                    if (queryParam != null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("query parameter ").append(queryParam.value()).append(CANNOT_BE_NULL);
                    } else if (pathParam == null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("post parameter ").append("arg").append(idx).append(CANNOT_BE_NULL);
                    }
                }
            }
            ++idx;
        }
        if (builder != null) {
            throw new IllegalArgumentException(builder.toString());
        }
    }
}

