/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.security.vault.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.SecretKey;
import javax.ws.rs.NotAuthorizedException;
import net.e6tech.elements.common.cache.CacheFacade;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;
import net.e6tech.elements.security.AsymmetricCipher;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Credential;
import net.e6tech.elements.web.security.vault.client.Action;
import net.e6tech.elements.web.security.vault.client.Decrypt;
import net.e6tech.elements.web.security.vault.client.Encrypt;
import net.e6tech.elements.web.security.vault.client.GetSecret;
import net.e6tech.elements.web.security.vault.client.PasswordUnlock;
import net.e6tech.elements.web.security.vault.client.Request;
import net.e6tech.elements.web.security.vault.client.SharedKey;

public class KeyClient
implements Startable {
    private AsymmetricCipher asym = AsymmetricCipher.getInstance((String)"RSA");
    private SymmetricCipher sym = SymmetricCipher.getInstance((String)"AES");
    private String clientKey;
    private SecretKey secretKey;
    private RestfulClient client;
    private String address = "http://localhost:10000/restful/keyserver/v1";
    private Credential credential;
    private String authorization;
    private boolean started;
    private boolean remoteEncryption = true;
    private CacheFacade<String, SecretKey> cachedSecretKeys;
    private CacheFacade<String, ClearText> cachedSecrets;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public boolean isRemoteEncryption() {
        return this.remoteEncryption;
    }

    public void setRemoteEncryption(boolean remoteEncryption) {
        this.remoteEncryption = remoteEncryption;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.cachedSecretKeys = new CacheFacade<String, SecretKey>("secretKeys"){};
        this.cachedSecretKeys.initPool();
        this.cachedSecrets = new CacheFacade<String, ClearText>("secrets"){};
        this.cachedSecrets.initPool();
        this.initCredential();
    }

    private void initCredential() {
        PublicKey publicKey;
        this.client = new RestfulClient();
        this.client.setAddress(this.address);
        try {
            Response response = this.client.get("publicKey", new Param[0]);
            SharedKey sharedKey = (SharedKey)response.read(SharedKey.class);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(sharedKey.getModulus(), sharedKey.getPublicExponent());
            this.secretKey = this.sym.generateKeySpec();
            publicKey = this.asym.getKeyFactory().generatePublic(publicKeySpec);
            this.clientKey = this.asym.encrypt(publicKey, this.secretKey.getEncoded());
        }
        catch (Throwable e) {
            Logger.suppress((Throwable)e);
            throw new NotAuthorizedException((Object)("Unable to authenticate with key server at " + this.address), new Object[0]);
        }
        try {
            if (this.credential == null) {
                this.credential = new Credential();
            }
            this.credential.run("Authenticating key client");
            String encryptedData = this.asym.encrypt(publicKey, Constants.mapper.writeValueAsString((Object)this.credential).getBytes(StandardCharsets.UTF_8));
            this.authorization = this.sym.encrypt(this.secretKey, this.sym.toBytes(encryptedData), null);
        }
        catch (Exception ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public boolean isAuthorized() {
        return this.authorization != null;
    }

    public ClearText getSecret(String alias) throws GeneralSecurityException {
        this.checkAuthorize();
        return (ClearText)this.cachedSecrets.get((Object)alias, () -> {
            GetSecret request = new GetSecret();
            request.setAlias(alias);
            String ret = this.submit(request);
            return this.decryptResult(ret, ClearText.class);
        });
    }

    public ClearText passwordUnlock(String alias) throws GeneralSecurityException {
        this.checkAuthorize();
        PasswordUnlock request = new PasswordUnlock();
        request.setAlias(alias);
        String ret = this.submit(request);
        return this.decryptResult(ret, ClearText.class);
    }

    public String encrypt(String key, byte[] data, String iv) throws GeneralSecurityException {
        if (this.remoteEncryption) {
            this.checkAuthorize();
            Encrypt request = new Encrypt();
            request.setKeyBlock(key);
            request.setData(data);
            request.setIv(iv);
            String ret = this.submit(request);
            return new String(this.decryptResult(ret), StandardCharsets.UTF_8);
        }
        SecretKey skey = this.getSecretKey(key);
        return this.sym.encrypt(skey, data, iv);
    }

    public byte[] decrypt(String key, String secret, String iv) throws GeneralSecurityException {
        if (this.remoteEncryption) {
            this.checkAuthorize();
            Decrypt request = new Decrypt();
            request.setKeyBlock(key);
            request.setSecret(secret);
            request.setIv(iv);
            String ret = this.submit(request);
            return this.decryptResult(ret);
        }
        SecretKey skey = this.getSecretKey(key);
        return this.sym.decrypt(skey, secret, iv);
    }

    private SecretKey getSecretKey(String key) {
        return (SecretKey)this.cachedSecretKeys.get((Object)key, () -> {
            byte[] keyBytes = this.decrypt(key);
            return this.sym.getKeySpec(keyBytes);
        });
    }

    public byte[] decrypt(String key) throws GeneralSecurityException {
        this.checkAuthorize();
        Decrypt request = new Decrypt();
        request.setSecret(key);
        String ret = this.submit(request);
        return this.decryptResult(ret);
    }

    private String submit(Action action) throws GeneralSecurityException {
        Request request = new Request();
        request.setAction(action.getType());
        request.setAuthorization(this.authorization);
        String encryptedData = null;
        try {
            encryptedData = this.sym.encrypt(this.secretKey, Constants.mapper.writeValueAsString((Object)action).getBytes(StandardCharsets.UTF_8), null);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
        request.setEncryptedData(encryptedData);
        request.setClientKey(this.clientKey);
        Response response = null;
        try {
            response = this.client.post("request", (Object)request, new Param[0]);
            int code = response.getResponseCode();
            if (code < 200 || code > 202) {
                throw new GeneralSecurityException();
            }
        }
        catch (Throwable e) {
            throw new GeneralSecurityException(e);
        }
        return response.getResult();
    }

    private byte[] decryptResult(String ret) throws GeneralSecurityException {
        return this.sym.decrypt(this.secretKey, ret, null);
    }

    private <T> T decryptResult(String ret, Class<T> cls) throws GeneralSecurityException {
        byte[] result = this.sym.decrypt(this.secretKey, ret, null);
        try {
            String value = new String(result, StandardCharsets.UTF_8);
            return (T)Constants.mapper.readValue(value, cls);
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    private void checkAuthorize() throws GeneralSecurityException {
        if (this.authorization == null) {
            throw new GeneralSecurityException("Not authenticated");
        }
    }
}

