/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import net.e6tech.elements.common.logging.Logger;
import org.apache.cxf.common.util.ClassHelper;

public class SecurityAnnotationEngine {
    private static Logger logger = Logger.getLogger();
    private static final Set<MethodSignature> SKIP_METHODS = new HashSet<MethodSignature>();
    private Map<Object, Class> securityProviders = new HashMap<Object, Class>();
    private Map<String, Map<MethodSignature, Set<String>>> scannedClassMap = new HashMap<String, Map<MethodSignature, Set<String>>>();

    public Map<Object, Class> getSecurityProviders() {
        return this.securityProviders;
    }

    public void setSecurityProviders(Map<Object, Class> securityProviders) throws ClassNotFoundException {
        this.securityProviders = securityProviders;
    }

    public <T> Class<? extends T> getSecurityProvider(Class<T> cls) {
        Class roleProvider = this.securityProviders.get(cls);
        if (roleProvider == null) {
            roleProvider = this.securityProviders.get(cls.getName());
        }
        if (roleProvider == null) {
            roleProvider = cls;
        }
        return roleProvider;
    }

    public <T> SecurityAnnotationEngine register(Class<T> cls) {
        Class<T> roleProvider = this.getSecurityProvider(cls);
        Map methodMap = this.scannedClassMap.computeIfAbsent(cls.getName(), key -> new HashMap());
        this.scanRoles(roleProvider, methodMap, RolesAllowed.class);
        this.scanRoles(roleProvider, methodMap, DenyAll.class);
        this.scanRoles(roleProvider, methodMap, PermitAll.class);
        if (methodMap.isEmpty()) {
            logger.warn("The roles map is empty, the service object is not protected: " + cls.getName());
        }
        this.scannedClassMap.put(cls.getName(), methodMap);
        return this;
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, String userRole) {
        if (userRole == null) {
            return this.hasAccess(instance, method, args, Collections.emptyList());
        }
        return this.hasAccess(instance, method, args, Arrays.asList(userRole));
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, List<String> userRoles) {
        Set<String> value = this.lookupRole(instance, method, args);
        if (value == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("no security map entry found: class: {} method:{}", (Object)instance.getClass().getName(), (Object)this.createMethodSig(method));
            }
            return true;
        }
        if (value.contains(DenyAll.class.getSimpleName())) {
            return false;
        }
        if (value.contains(PermitAll.class.getSimpleName())) {
            return true;
        }
        for (String userRole : userRoles) {
            if (!value.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    public Set<String> lookupRole(Object instance, Method method, Object[] args) {
        Class cls = ClassHelper.getRealClass((Object)instance);
        return this.lookupRole(cls, method);
    }

    public Set<String> lookupRole(Class cls, Method method) {
        MethodSignature methodSig = this.createMethodSig(method);
        logger.trace("lookupRole: class: {} method:{}", (Object)cls.getName(), (Object)methodSig);
        Map<MethodSignature, Set<String>> methodMap = this.scannedClassMap.get(cls.getName());
        if (methodMap == null) {
            return Collections.emptySet();
        }
        Set<String> roles = methodMap.get(methodSig);
        logger.trace("==> cls:{} m:{} roles:{}", new Object[]{cls, methodSig, roles});
        return roles;
    }

    public void logMethodMap() {
        if (logger.isTraceEnabled()) {
            ArrayList<String> clsNameList = new ArrayList<String>(this.scannedClassMap.keySet());
            Collections.sort(clsNameList);
            for (String clsName : clsNameList) {
                logger.trace("registered class: {}", (Object)clsName);
                Map<MethodSignature, Set<String>> methodMap = this.scannedClassMap.get(clsName);
                ArrayList<MethodSignature> methodNameList = new ArrayList<MethodSignature>(methodMap.keySet());
                for (MethodSignature signature : methodNameList) {
                    Set<String> roles = methodMap.get(signature);
                    logger.trace("  method:{} roles:{}", (Object)signature, roles);
                }
            }
        }
    }

    private void scanRoles(Class<?> cls, Map<MethodSignature, Set<String>> rolesMap, Class<? extends Annotation> annotationClass) {
        if (cls == null || cls == Object.class) {
            return;
        }
        Set<String> classRoles = this.getRoles(cls, annotationClass);
        for (Method m : cls.getDeclaredMethods()) {
            Set<String> resultRoles;
            MethodSignature signature = this.createMethodSig(m);
            if (SKIP_METHODS.contains(signature) || rolesMap.get(signature) != null) continue;
            Set<String> methodRoles = this.getRoles(m, annotationClass);
            Set<String> set = resultRoles = !methodRoles.isEmpty() ? methodRoles : classRoles;
            if (resultRoles.isEmpty()) continue;
            rolesMap.put(signature, resultRoles);
        }
        this.scanRoles(cls.getSuperclass(), rolesMap, annotationClass);
    }

    private Set<String> getRoles(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        if (annotationClass.equals(RolesAllowed.class)) {
            RolesAllowed rolesAllowed = element.getAnnotation(RolesAllowed.class);
            if (rolesAllowed != null) {
                HashSet<String> set = new HashSet<String>();
                Collections.addAll(set, rolesAllowed.value());
                return set;
            }
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        Annotation annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            set.add(annotationClass.getSimpleName());
            return set;
        }
        return Collections.emptySet();
    }

    private MethodSignature createMethodSig(Method method) {
        return new MethodSignature(method);
    }

    static {
        for (Method method : Object.class.getDeclaredMethods()) {
            SKIP_METHODS.add(new MethodSignature(method));
        }
    }

    static class MethodSignature {
        private String name;
        private Class returnType;
        private Class<?>[] parameterTypes;
        private String signature;

        MethodSignature(Method method) {
            this.name = method.getName();
            this.returnType = method.getReturnType();
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)obj;
                if (this.name.equals(other.name)) {
                    if (!this.returnType.equals(other.returnType)) {
                        return false;
                    }
                    return this.equalParamTypes(this.parameterTypes, other.parameterTypes);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.returnType.hashCode();
        }

        boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
            if (params1.length == params2.length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.signature == null) {
                StringBuilder b = new StringBuilder(this.returnType.getName());
                b.append(' ').append(this.name).append('(');
                boolean first = true;
                for (Class<?> cls : this.parameterTypes) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(cls.getName());
                }
                b.append(')');
                this.signature = b.toString();
            }
            return this.signature;
        }
    }
}

