/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.common.logging.Logger;
import org.apache.cxf.common.util.ClassHelper;

public class SecurityAnnotationEngine {
    private static Logger logger = Logger.getLogger();
    private static final String ROLES_ALLOWED_CLASS_NAME = "javax.annotation.security.RolesAllowed";
    private static final String PERMIT_ALL_CLASS_NAME = "javax.annotation.security.PermitAll";
    private static final String DENY_ALL_CLASS_NAME = "javax.annotation.security.DenyAll";
    private static final String ROLE_KEY_PERMIT_ALL = "PERMITALL";
    private static final String ROLE_KEY_DENY_ALL = "DENYALL";
    private static final Set<String> SKIP_METHODS = new HashSet<String>();
    private Map<String, Map<MethodSignature, Set<String>>> scannedClassMap = new HashMap<String, Map<MethodSignature, Set<String>>>();

    public void register(Object object) {
        Class cls = ClassHelper.getRealClass((Object)object);
        if (this.scannedClassMap.containsKey(cls.getName())) {
            return;
        }
        HashMap<MethodSignature, Set<String>> methodMap = new HashMap<MethodSignature, Set<String>>();
        this.scanForPermitAll(cls, methodMap);
        this.scanForDenyAll(cls, methodMap);
        this.scanForRolesAllowed(cls, methodMap);
        if (methodMap.isEmpty()) {
            logger.warn("The roles map is empty, the service object is not protected: " + cls.getName());
        }
        this.scannedClassMap.put(cls.getName(), methodMap);
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, String userRole) {
        if (userRole == null) {
            return this.hasAccess(instance, method, args, Collections.emptyList());
        }
        return this.hasAccess(instance, method, args, Arrays.asList(userRole));
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, List<String> userRoles) {
        Set<String> value = this.lookupRole(instance, method, args);
        if (value == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("no security map entry found: class: {} method:{}", (Object)instance.getClass().getName(), (Object)this.createMethodSig(method));
            }
            return true;
        }
        if (value.contains(ROLE_KEY_DENY_ALL)) {
            return false;
        }
        if (value.contains(ROLE_KEY_PERMIT_ALL)) {
            return true;
        }
        for (String userRole : userRoles) {
            if (!value.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    public Set<String> lookupRole(Object instance, Method method, Object[] args) {
        Class cls = ClassHelper.getRealClass((Object)instance);
        MethodSignature methodSig = this.createMethodSig(method);
        logger.trace("lookupRole: class: {} method:{}", (Object)cls.getName(), (Object)methodSig);
        Map<MethodSignature, Set<String>> methodMap = this.scannedClassMap.get(cls.getName());
        if (methodMap == null) {
            return Collections.emptySet();
        }
        Set<String> roles = methodMap.get(methodSig);
        logger.trace("==> cls:{} m:{} roles:{}", new Object[]{cls, methodSig, roles});
        return roles;
    }

    public void logMethodMap() {
        if (logger.isTraceEnabled()) {
            ArrayList<String> clsNameList = new ArrayList<String>(this.scannedClassMap.keySet());
            Collections.sort(clsNameList);
            for (String clsName : clsNameList) {
                logger.trace("registered class: {}", (Object)clsName);
                Map<MethodSignature, Set<String>> methodMap = this.scannedClassMap.get(clsName);
                ArrayList<MethodSignature> methodNameList = new ArrayList<MethodSignature>(methodMap.keySet());
                for (MethodSignature signature : methodNameList) {
                    Set<String> roles = methodMap.get(signature);
                    logger.trace("  method:{} roles:{}", (Object)signature, roles);
                }
            }
        }
    }

    private void scanForPermitAll(Class<?> cls, Map<MethodSignature, Set<String>> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        boolean clsLevelPermitAll = this.isAnnotationPresent(cls.getAnnotations(), PERMIT_ALL_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            if (SKIP_METHODS.contains(m.getName())) continue;
            boolean methodLevelPermitAll = this.isAnnotationPresent(m.getAnnotations(), PERMIT_ALL_CLASS_NAME);
            if (!clsLevelPermitAll && !methodLevelPermitAll) continue;
            HashSet<String> set = new HashSet<String>();
            set.add(ROLE_KEY_PERMIT_ALL);
            rolesMap.put(this.createMethodSig(m), set);
        }
        if (clsLevelPermitAll) {
            return;
        }
        this.scanForPermitAll(cls.getSuperclass(), rolesMap);
    }

    private void scanForDenyAll(Class<?> cls, Map<MethodSignature, Set<String>> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        boolean clsLevelDenyAll = this.isAnnotationPresent(cls.getAnnotations(), DENY_ALL_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            if (SKIP_METHODS.contains(m.getName())) continue;
            boolean methodLevelDenyAll = this.isAnnotationPresent(m.getAnnotations(), DENY_ALL_CLASS_NAME);
            if (!clsLevelDenyAll && !methodLevelDenyAll) continue;
            HashSet<String> set = new HashSet<String>();
            set.add(ROLE_KEY_DENY_ALL);
            rolesMap.put(this.createMethodSig(m), set);
        }
        if (clsLevelDenyAll) {
            return;
        }
        this.scanForDenyAll(cls.getSuperclass(), rolesMap);
    }

    private boolean isAnnotationPresent(Annotation[] anns, String annName) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            return true;
        }
        return false;
    }

    private void scanForRolesAllowed(Class<?> cls, Map<MethodSignature, Set<String>> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        Set<String> classRolesAllowed = this.getRoles(cls.getAnnotations(), ROLES_ALLOWED_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            Set<String> theRoles;
            if (SKIP_METHODS.contains(m.getName())) continue;
            Set<String> methodRolesAllowed = this.getRoles(m.getAnnotations(), ROLES_ALLOWED_CLASS_NAME);
            Set<String> set = theRoles = !methodRolesAllowed.isEmpty() ? methodRolesAllowed : classRolesAllowed;
            if (theRoles.isEmpty()) continue;
            rolesMap.put(this.createMethodSig(m), theRoles);
        }
        if (!rolesMap.isEmpty()) {
            return;
        }
        this.scanForRolesAllowed(cls.getSuperclass(), rolesMap);
    }

    private Set<String> getRoles(Annotation[] anns, String annName) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            try {
                Method valueMethod = ann.annotationType().getMethod("value", new Class[0]);
                String[] roles = (String[])valueMethod.invoke((Object)ann, new Object[0]);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < roles.length; ++i) {
                    sb.append(roles[i]);
                    if (i + 1 >= roles.length) continue;
                    sb.append(" ");
                }
                HashSet<String> set = new HashSet<String>();
                for (String role : roles) {
                    set.add(role);
                }
                return set;
            }
            catch (Exception ex) {
                Logger.suppress((Throwable)ex);
                break;
            }
        }
        return Collections.emptySet();
    }

    private MethodSignature createMethodSig(Method method) {
        return new MethodSignature(method);
    }

    static {
        SKIP_METHODS.addAll(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    }

    static class MethodSignature {
        private String name;
        private Class returnType;
        private Class<?>[] parameterTypes;
        private String signature;

        MethodSignature(Method method) {
            this.name = method.getName();
            this.returnType = method.getReturnType();
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodSignature) {
                MethodSignature other = (MethodSignature)obj;
                if (this.name.equals(other.name)) {
                    if (!this.returnType.equals(other.returnType)) {
                        return false;
                    }
                    return this.equalParamTypes(this.parameterTypes, other.parameterTypes);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.returnType.hashCode();
        }

        boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
            if (params1.length == params2.length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.signature == null) {
                StringBuilder b = new StringBuilder(this.returnType.getName());
                b.append(' ').append(this.name).append('(');
                boolean first = true;
                for (Class<?> cls : this.parameterTypes) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(cls.getName());
                }
                b.append(')');
                this.signature = b.toString();
            }
            return this.signature;
        }
    }
}

