/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.SelfSignedCert;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class CXFServer
implements Initializable,
Startable {
    private Provision provision;
    private Interceptor interceptor;
    private List<Server> servers = new ArrayList<Server>();
    private List<URL> urls = new ArrayList<URL>();
    private String keyStoreFile;
    private String keyStoreFormat = "PKCS12";
    private KeyStore keyStore;
    private char[] keyStorePassword;
    private char[] keyManagerPassword;
    private SelfSignedCert selfSignedCert;
    private ExecutorService executor;
    private QueuedThreadPool queuedThreadPool;
    private boolean initialized = false;
    private boolean started = false;

    public void setAddresses(List<String> addresses) throws MalformedURLException {
        for (String address : addresses) {
            URL url = new URL(address);
            this.urls.add(url);
        }
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Inject
    public void setProvision(Provision provision) {
        this.provision = provision;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Inject
    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected List<URL> getURLs() {
        return this.urls;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public SelfSignedCert getSelfSignedCert() {
        return this.selfSignedCert;
    }

    public void setSelfSignedCert(SelfSignedCert selfSignedCert) {
        this.selfSignedCert = selfSignedCert;
    }

    public ExecutorService getThreadPool() {
        return this.executor;
    }

    @Inject(optional=true)
    public void setThreadPool(ExecutorService executor) {
        this.executor = executor;
    }

    public QueuedThreadPool getQueuedThreadPool() {
        return this.queuedThreadPool;
    }

    @Inject(optional=true)
    public void setQueuedThreadPool(QueuedThreadPool queuedThreadPool) {
        this.queuedThreadPool = queuedThreadPool;
    }

    protected void registerServer(Server server) {
        if (!this.servers.contains(server)) {
            this.servers.add(server);
        }
    }

    protected void initKeyStore() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        if (this.keyStoreFile == null && this.selfSignedCert == null && this.keyStore == null) {
            return;
        }
        if (this.keyStore != null || this.keyStoreFile != null) {
            JavaKeyStore jceKeyStore = this.keyStore != null ? new JavaKeyStore(this.keyStore) : new JavaKeyStore(this.keyStoreFile, this.keyStorePassword, this.keyStoreFormat);
            if (this.keyManagerPassword == null) {
                this.keyManagerPassword = this.keyStorePassword;
            }
            jceKeyStore.init(this.keyManagerPassword);
            keyManagers = jceKeyStore.getKeyManagers();
            trustManagers = jceKeyStore.getTrustManagers();
        } else {
            keyManagers = this.selfSignedCert.getKeyManagers();
            trustManagers = this.selfSignedCert.getTrustManagers();
        }
        TLSServerParameters tlsParams = new TLSServerParameters();
        tlsParams.setKeyManagers(keyManagers);
        tlsParams.setTrustManagers(trustManagers);
        ClientAuthentication ca = new ClientAuthentication();
        ca.setRequired(Boolean.valueOf(false));
        ca.setWant(Boolean.valueOf(false));
        tlsParams.setClientAuthentication(ca);
        JettyHTTPServerEngineFactory factory = new JettyHTTPServerEngineFactory();
        for (URL url : this.urls) {
            TLSServerParameters existingParams;
            if (!"https".equals(url.getProtocol())) continue;
            JettyHTTPServerEngine engine = factory.retrieveJettyHTTPServerEngine(url.getPort());
            TLSServerParameters tLSServerParameters = existingParams = engine == null ? null : engine.getTlsServerParameters();
            if (existingParams != null) {
                LinkedHashSet<KeyManager> keyManagerSet = new LinkedHashSet<KeyManager>();
                for (KeyManager km : existingParams.getKeyManagers()) {
                    keyManagerSet.add(km);
                }
                for (KeyManager km : keyManagers) {
                    if (keyManagerSet.contains(km)) continue;
                    keyManagerSet.add(km);
                }
                LinkedHashSet<TrustManager> trustManagerSet = new LinkedHashSet<TrustManager>();
                for (TrustManager tm : existingParams.getTrustManagers()) {
                    trustManagerSet.add(tm);
                }
                for (TrustManager tm : trustManagers) {
                    if (trustManagerSet.contains(tm)) continue;
                    trustManagerSet.add(tm);
                }
                existingParams.setKeyManagers(keyManagerSet.toArray(new KeyManager[keyManagerSet.size()]));
                existingParams.setTrustManagers(trustManagerSet.toArray(new TrustManager[trustManagerSet.size()]));
                continue;
            }
            factory.setTLSServerParametersForPort(url.getPort(), tlsParams);
        }
    }

    public void initialize(Resources resources) {
        this.initialized = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.initialized) {
            this.initialize(null);
        }
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.queuedThreadPool != null) {
            for (Server server : this.servers) {
                JettyHTTPDestination jetty;
                Destination dest = server.getDestination();
                if (!(dest instanceof JettyHTTPDestination) || !((jetty = (JettyHTTPDestination)dest).getEngine() instanceof JettyHTTPServerEngine)) continue;
                ((JettyHTTPServerEngine)jetty.getEngine()).setThreadPool((ThreadPool)this.queuedThreadPool);
            }
        }
        for (Server server : this.servers) {
            server.start();
        }
    }

    public void stop() {
        for (Server server : this.servers) {
            server.stop();
        }
        this.started = false;
    }
}

