/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.management.JMException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.inject.Module;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.notification.NotificationListener;
import net.e6tech.elements.common.notification.ShutdownNotification;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.UnitOfWork;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.jmx.JMXService;
import net.e6tech.elements.jmx.stat.Measurement;
import net.e6tech.elements.web.JaxExceptionHandler;
import net.e6tech.elements.web.cxf.CXFServer;
import net.e6tech.elements.web.cxf.InvocationException;
import net.e6tech.elements.web.cxf.Observer;
import net.e6tech.elements.web.cxf.SecurityAnnotationEngine;
import net.e6tech.elements.web.cxf.StatusException;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;

public class JaxRSServer
extends CXFServer {
    private static final String CLASS = "class";
    private static final String SINGLETON = "singleton";
    private static final String BIND_HEADER_OBSERVER = "bindHeaderObserver";
    private static final String REGISTER_BEAN = "registerBean";
    private static final String NAME = "name";
    private static net.e6tech.elements.common.logging.Logger messageLogger;
    private static Map<Integer, ServerFactorBeanEntry> entries;
    private static net.e6tech.elements.common.logging.Logger logger;
    @Inject(optional=true)
    private Observer headerObserver;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    @Inject(optional=true)
    private net.e6tech.elements.common.util.ExceptionMapper exceptionMapper;
    @Inject(optional=true)
    private ExecutorService threadPool;
    private Map<String, Object> instances = new Hashtable<String, Object>();
    private boolean corsFilter = false;
    private boolean measurement = false;
    @Inject(optional=true)
    private SecurityAnnotationEngine securityAnnotationEngine;

    public static net.e6tech.elements.common.logging.Logger getLogger() {
        return logger;
    }

    public static void setLogger(net.e6tech.elements.common.logging.Logger logger) {
        JaxRSServer.logger = logger;
    }

    public Observer getHeaderObserver() {
        return this.headerObserver;
    }

    public void setHeaderObserver(Observer headerObserver) {
        this.headerObserver = headerObserver;
    }

    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    public void setResources(List<Map<String, Object>> resources) {
        this.resources = resources;
    }

    public net.e6tech.elements.common.util.ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public void setExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public Map<String, Object> getInstances() {
        return this.instances;
    }

    public Object getInstance(String name) {
        return this.instances.get(name);
    }

    public boolean isCorsFilter() {
        return this.corsFilter;
    }

    public void setCorsFilter(boolean corsFilter) {
        this.corsFilter = corsFilter;
    }

    public SecurityAnnotationEngine getSecurityAnnotationEngine() {
        return this.securityAnnotationEngine;
    }

    public void setSecurityAnnotationEngine(SecurityAnnotationEngine securityAnnotationEngine) {
        this.securityAnnotationEngine = securityAnnotationEngine;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Resources res) {
        if (this.getURLs().isEmpty()) {
            throw new IllegalStateException("address not set");
        }
        res.getNotificationCenter().addNotificationListener(ShutdownNotification.class, NotificationListener.wrap((String)("JaxRSServer" + this.getURLs()), notification -> this.stop()));
        ArrayList<ServerFactorBeanEntry> entryList = new ArrayList<ServerFactorBeanEntry>();
        Map<Integer, ServerFactorBeanEntry> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                ServerFactorBeanEntry entry = entries.computeIfAbsent(uRL.getPort(), port -> new ServerFactorBeanEntry(url, new JAXRSServerFactoryBean()));
                if (!entry.getURL().equals(uRL)) {
                    throw new SystemException("Cannot register " + uRL.toExternalForm() + ".  Already a service at " + uRL.toExternalForm());
                }
                JAXRSServerFactoryBean bean = entry.getFactoryBean();
                bean.setAddress(uRL.toExternalForm());
                entries.put(uRL.getPort(), entry);
                entryList.add(entry);
            }
        }
        ArrayList resourceClasses = new ArrayList();
        for (Map map2 : this.resources) {
            Object resourceProvider;
            boolean bindHeaderObserver;
            boolean singleton = false;
            Class<?> resourceClass = null;
            String resourceClassName = (String)map2.get(CLASS);
            if (resourceClassName == null) {
                throw new SystemException("Missing resource class in resources map");
            }
            try {
                resourceClass = this.provision.getClass().getClassLoader().loadClass(resourceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SystemException((Throwable)e);
            }
            Observer hObserver = this.headerObserver;
            boolean bl = bindHeaderObserver = map2.get(BIND_HEADER_OBSERVER) == null ? true : (Boolean)map2.get(BIND_HEADER_OBSERVER);
            if (!bindHeaderObserver) {
                hObserver = null;
            }
            singleton = map2.get(SINGLETON) == null ? false : (Boolean)map2.get(SINGLETON);
            String resourceName = (String)map2.get(NAME);
            Object instance = null;
            try {
                instance = resourceClass.newInstance();
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            if (res != null) {
                res.inject(instance);
                if (hObserver != null) {
                    res.inject((Object)hObserver);
                }
            } else {
                this.provision.inject(instance);
                if (hObserver != null) {
                    this.provision.inject((Object)hObserver);
                }
            }
            if (this.securityAnnotationEngine != null) {
                this.securityAnnotationEngine.register(instance);
            }
            if (singleton) {
                resourceProvider = new SharedResourceProvider(map2, instance, hObserver);
                String beanName = (String)map2.get(REGISTER_BEAN);
                if (beanName != null) {
                    this.provision.getResourceManager().registerBean(beanName, instance);
                }
            } else {
                resourceProvider = new InstanceResourceProvider(map2, resourceClass, res.getModule(), this.provision, hObserver);
            }
            for (ServerFactorBeanEntry entry : entryList) {
                entry.getFactoryBean().setResourceProvider(resourceClass, (ResourceProvider)resourceProvider);
            }
            if (resourceName != null) {
                this.instances.put(resourceName, instance);
            }
            resourceClasses.add(resourceClass);
        }
        if (this.securityAnnotationEngine != null) {
            this.securityAnnotationEngine.logMethodMap();
        }
        for (ServerFactorBeanEntry serverFactorBeanEntry : entryList) {
            serverFactorBeanEntry.addResourceClasses(resourceClasses);
        }
        super.initialize(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            this.initKeyStore();
        }
        catch (Exception th) {
            throw new SystemException((Throwable)th);
        }
        ArrayList<JAXRSServerFactoryBean> beans = new ArrayList<JAXRSServerFactoryBean>();
        Map<Integer, ServerFactorBeanEntry> map = entries;
        synchronized (map) {
            for (URL uRL : this.getURLs()) {
                ServerFactorBeanEntry entry = entries.get(uRL.getPort());
                if (entry == null) continue;
                beans.add(entry.getFactoryBean());
                entry.getFactoryBean().setResourceClasses(entry.getResourceClasses());
                entries.remove(uRL.getPort());
            }
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.getBus().setProperty("skip.default.json.provider.registration", (Object)true);
        }
        JacksonJaxbJsonProvider jackson = new JacksonJaxbJsonProvider();
        ((JacksonJsonProvider)((JacksonJsonProvider)((JacksonJsonProvider)((JacksonJsonProvider)jackson.disable(SerializationFeature.WRAP_ROOT_VALUE)).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.setProvider((Object)jackson);
        }
        if (this.isCorsFilter()) {
            logger.info("enabling CORS filter");
            CrossOriginResourceSharingFilter crossOriginResourceSharingFilter = new CrossOriginResourceSharingFilter();
            for (JAXRSServerFactoryBean bean : beans) {
                bean.setProvider((Object)crossOriginResourceSharingFilter);
            }
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.getInInterceptors().add(new LoggingInInterceptor(){

                protected void log(Logger otherLogger, String message) {
                    JaxRSServer.this.log(message);
                }
            });
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.getOutInterceptors().add(new LoggingOutInterceptor(){

                protected void log(Logger otherLogger, String message) {
                    JaxRSServer.this.log(message);
                }
            });
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            jAXRSServerFactoryBean.setProvider((Object)new InternalExceptionMapper(this.exceptionMapper));
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            logger.info("Starting Restful at address {} {} ", (Object)jAXRSServerFactoryBean.getAddress(), (Object)jAXRSServerFactoryBean.getResourceClasses());
        }
        for (JAXRSServerFactoryBean jAXRSServerFactoryBean : beans) {
            try {
                jAXRSServerFactoryBean.setStart(false);
                this.registerServer(jAXRSServerFactoryBean.create());
            }
            catch (Exception ex) {
                throw new SystemException("Cannot start RESTful service at " + jAXRSServerFactoryBean.getAddress(), (Throwable)ex);
            }
        }
        super.start();
    }

    protected void log(String message) {
        Runnable runnable = () -> messageLogger.trace(message);
        if (messageLogger.isTraceEnabled()) {
            if (this.threadPool != null) {
                this.threadPool.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void handleException(CallFrame frame, Throwable th) throws Throwable {
        Throwable throwable = net.e6tech.elements.common.util.ExceptionMapper.unwrap((Throwable)th);
        if (frame.getTarget() instanceof JaxExceptionHandler) {
            Object response = ((JaxExceptionHandler)frame.getTarget()).handleException(frame, throwable);
            if (response != null) {
                throw new InvocationException(response);
            }
        } else {
            throw throwable;
        }
    }

    private void computePerformance(Method method, Map<Method, String> methods, Map<String, Object> map, long duration) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"add", (Object[])new Object[]{duration});
        }
        catch (Exception e) {
            logger.debug("Unable to record measurement for " + method, (Throwable)e);
        }
    }

    private void recordFailure(Method method, Map<Method, String> methods, Map<String, Object> map) {
        ObjectInstance instance = null;
        try {
            instance = this.getMeasurement(method, methods);
            JMXService.invoke((ObjectName)instance.getObjectName(), (String)"fail", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Unable to record fail measurement for " + method, (Throwable)e);
        }
    }

    private ObjectInstance getMeasurement(Method method, Map<Method, String> methods) throws JMException {
        String methodName = methods.computeIfAbsent(method, m -> {
            StringBuilder builder = new StringBuilder();
            builder.append(m.getDeclaringClass().getTypeName());
            builder.append(".");
            builder.append(m.getName());
            Class<?>[] types = m.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                builder.append("|");
                builder.append(types[i].getSimpleName());
            }
            return builder.toString();
        });
        String objectName = "net.e6tech:type=Restful,name=" + methodName;
        return JMXService.registerIfAbsent((String)objectName, () -> new Measurement(methodName, "ms", this.measurement));
    }

    private static void checkInvocation(Method method, Object[] args) {
        Parameter[] params = method.getParameters();
        int idx = 0;
        StringBuilder builder = null;
        String CANNOT_BE_NULL = " cannot be null. \n";
        for (Parameter param : params) {
            QueryParam queryParam = param.getAnnotation(QueryParam.class);
            PathParam pathParam = param.getAnnotation(PathParam.class);
            if (args[idx] == null || args[idx] instanceof String && ((String)args[idx]).trim().isEmpty()) {
                if (pathParam != null) {
                    if (builder == null) {
                        builder = new StringBuilder();
                    }
                    builder.append("path parameter ").append(pathParam.value()).append(" cannot be null. \n");
                }
                if (param.getAnnotation(Nonnull.class) != null) {
                    if (queryParam != null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("query parameter ").append(queryParam.value()).append(" cannot be null. \n");
                    } else if (pathParam == null) {
                        if (builder == null) {
                            builder = new StringBuilder();
                        }
                        builder.append("post parameter ").append("arg").append(idx).append(" cannot be null. \n");
                    }
                }
            }
            ++idx;
        }
        if (builder != null) {
            throw new IllegalArgumentException(builder.toString());
        }
    }

    static {
        System.setProperty("org.apache.cxf.useSpringClassHelpers", "false");
        messageLogger = net.e6tech.elements.common.logging.Logger.getLogger((String)(JaxRSServer.class.getName() + ".message"));
        entries = new Hashtable<Integer, ServerFactorBeanEntry>();
        logger = net.e6tech.elements.common.logging.Logger.getLogger();
    }

    @Provider
    private static class InternalExceptionMapper
    implements ExceptionMapper<Exception> {
        net.e6tech.elements.common.util.ExceptionMapper mapper;

        public InternalExceptionMapper(net.e6tech.elements.common.util.ExceptionMapper mapper) {
            this.mapper = mapper;
        }

        public Response toResponse(Exception exception) {
            Object response;
            Response.Status status = Response.Status.BAD_REQUEST;
            if (exception instanceof BadRequestException) {
                status = Response.Status.BAD_REQUEST;
            } else if (exception instanceof NotAuthorizedException) {
                status = Response.Status.UNAUTHORIZED;
            } else if (exception instanceof ForbiddenException) {
                status = Response.Status.FORBIDDEN;
            } else if (exception instanceof NotFoundException) {
                status = Response.Status.NOT_FOUND;
            } else if (exception instanceof NotAllowedException) {
                status = Response.Status.METHOD_NOT_ALLOWED;
            } else if (exception instanceof NotAcceptableException) {
                status = Response.Status.NOT_ACCEPTABLE;
            } else if (exception instanceof NotSupportedException) {
                status = Response.Status.UNSUPPORTED_MEDIA_TYPE;
            } else if (exception instanceof InternalServerErrorException) {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            } else if (exception instanceof ServiceUnavailableException) {
                status = Response.Status.SERVICE_UNAVAILABLE;
            }
            if (exception instanceof InvocationException) {
                response = ((InvocationException)exception).getResponse();
            } else if (exception instanceof StatusException) {
                StatusException statusException = (StatusException)exception;
                status = statusException.getStatus();
                response = this.mapper != null ? this.mapper.toResponse(statusException.getCause()) : statusException.getCause().getMessage();
            } else {
                response = this.mapper != null ? this.mapper.toResponse((Throwable)exception) : exception.getMessage();
            }
            return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        }
    }

    private static class ServerFactorBeanEntry {
        JAXRSServerFactoryBean bean;
        URL url;
        List<Class<?>> resourceClasses = new ArrayList();

        ServerFactorBeanEntry(URL url, JAXRSServerFactoryBean bean) {
            this.url = url;
            this.bean = bean;
        }

        synchronized URL getURL() {
            return this.url;
        }

        JAXRSServerFactoryBean getFactoryBean() {
            return this.bean;
        }

        synchronized void addResourceClasses(List<Class<?>> list) {
            this.resourceClasses.addAll(list);
        }

        List<Class<?>> getResourceClasses() {
            return this.resourceClasses;
        }
    }

    private class SharedResourceProvider
    extends SingletonResourceProvider {
        Observer observer;
        Object proxy;
        Map<String, Object> map;
        Map<Method, String> methods;

        public SharedResourceProvider(Map<String, Object> map, Object instance, Observer observer) {
            super(instance, true);
            this.proxy = null;
            this.methods = new Hashtable<Method, String>();
            this.observer = observer;
            this.map = map;
        }

        public Object getInstance(Message m) {
            Observer cloneObserver;
            Observer observer = cloneObserver = this.observer != null ? this.observer.clone() : null;
            if (this.proxy == null) {
                this.proxy = JaxRSServer.this.interceptor.newInterceptor(super.getInstance(m), frame -> {
                    try {
                        JaxRSServer.checkInvocation(frame.getMethod(), frame.getArguments());
                        if (cloneObserver != null) {
                            HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
                            JaxRSServer.this.provision.inject((Object)cloneObserver);
                            cloneObserver.beforeInvocation(request, frame.getTarget(), frame.getMethod(), frame.getArguments());
                        }
                        long start = System.currentTimeMillis();
                        Object result = frame.invoke();
                        long duration = System.currentTimeMillis() - start;
                        JaxRSServer.this.computePerformance(frame.getMethod(), this.methods, this.map, duration);
                        if (cloneObserver != null) {
                            cloneObserver.afterInvocation(result);
                        }
                        return result;
                    }
                    catch (Exception th) {
                        if (cloneObserver != null) {
                            cloneObserver.onException(th);
                        }
                        JaxRSServer.this.recordFailure(frame.getMethod(), this.methods, this.map);
                        logger.debug(th.getMessage(), (Throwable)th);
                        JaxRSServer.this.handleException(frame, th);
                        return null;
                    }
                });
            }
            return this.proxy;
        }
    }

    private class Handler
    implements InterceptorHandler {
        UnitOfWork uow;
        Message message;
        Observer observer;
        Map<String, Object> map;
        Map<Method, String> methods;

        public Handler(UnitOfWork uow, Map<String, Object> map, Map<Method, String> methods, Observer observer, Message message) {
            this.uow = uow;
            this.message = message;
            this.observer = observer;
            this.map = map;
            this.methods = methods;
        }

        private void open(Object target, Method method) {
            Class<?> cls = target.getClass();
            for (Annotation annotation : cls.getAnnotations()) {
                this.uow.put(annotation.annotationType(), (Object)annotation);
            }
            for (Annotation annotation : method.getAnnotations()) {
                this.uow.put(annotation.annotationType(), (Object)annotation);
            }
            this.uow.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(CallFrame frame) throws Throwable {
            boolean abort = false;
            Object result = null;
            boolean ignored = false;
            boolean uowOpen = false;
            if (frame.getAnnotation(PreDestroy.class) != null) {
                ignored = true;
            } else {
                try {
                    this.open(frame.getTarget(), frame.getMethod());
                    uowOpen = true;
                }
                catch (Exception th) {
                    logger.debug(th.getMessage(), (Throwable)th);
                    JaxRSServer.this.handleException(frame, th);
                }
            }
            try {
                JaxRSServer.checkInvocation(frame.getMethod(), frame.getArguments());
                if (!ignored) {
                    long start = System.currentTimeMillis();
                    result = this.uow.submit(() -> {
                        if (this.observer != null) {
                            HttpServletRequest request = (HttpServletRequest)this.message.get((Object)"HTTP.REQUEST");
                            this.uow.getResources().inject((Object)this.observer);
                            this.observer.beforeInvocation(request, frame.getTarget(), frame.getMethod(), frame.getArguments());
                        }
                        this.uow.getResources().inject(frame.getTarget());
                        Object ret = frame.invoke();
                        if (this.observer != null) {
                            this.observer.afterInvocation(ret);
                        }
                        return ret;
                    });
                    long duration = System.currentTimeMillis() - start;
                    JaxRSServer.this.computePerformance(frame.getMethod(), this.methods, this.map, duration);
                } else {
                    result = frame.invoke();
                }
            }
            catch (Exception th) {
                if (!ignored && this.observer != null) {
                    try {
                        this.observer.onException(th);
                    }
                    catch (Exception ex) {
                        net.e6tech.elements.common.logging.Logger.suppress((Throwable)ex);
                    }
                }
                JaxRSServer.this.recordFailure(frame.getMethod(), this.methods, this.map);
                abort = true;
                logger.debug(th.getMessage(), (Throwable)th);
                JaxRSServer.this.handleException(frame, th);
            }
            finally {
                if (uowOpen) {
                    if (abort) {
                        this.uow.abort();
                    } else if (!this.uow.isAborted()) {
                        this.uow.commit();
                    }
                }
            }
            return result;
        }
    }

    private class InstanceResourceProvider
    extends PerRequestResourceProvider {
        private Provision provision;
        private Observer observer;
        private Module module;
        private Map<String, Object> map;
        private Map<Method, String> methods;

        public InstanceResourceProvider(Map<String, Object> map, Class resourceClass, Module module, Provision provision, Observer observer) {
            super(resourceClass);
            this.methods = new Hashtable<Method, String>();
            this.provision = provision;
            this.observer = observer;
            this.module = module;
            this.map = map;
        }

        protected Object createInstance(Message message) {
            Object instance = super.createInstance(message);
            Observer cloneObserver = this.observer == null ? null : this.observer.clone();
            UnitOfWork uow = this.provision.preOpen(res -> {
                res.addModule(this.module);
                if (JaxRSServer.this.exceptionMapper != null) {
                    res.rebind(net.e6tech.elements.common.util.ExceptionMapper.class, (Object)JaxRSServer.this.exceptionMapper);
                    res.rebind(JaxRSServer.this.exceptionMapper.getClass(), (Object)JaxRSServer.this.exceptionMapper);
                }
            });
            return JaxRSServer.this.interceptor.newInterceptor(instance, (InterceptorHandler)new Handler(uow, this.map, this.methods, cloneObserver, message));
        }
    }
}

