/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.net.URL;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.cxf.CXFServer;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

public class JaxWSServer
extends CXFServer {
    Object implementor;
    Class serviceClass;

    @Override
    public void initialize(Resources resources) {
        for (URL url : this.getURLs()) {
            JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
            svrFactory.setServiceClass(this.serviceClass);
            svrFactory.setAddress(url.toExternalForm());
            svrFactory.setServiceBean(this.implementor);
            svrFactory.getInInterceptors().add(new LoggingInInterceptor());
            svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
            svrFactory.setStart(false);
            this.registerServer(svrFactory.create());
        }
        try {
            this.initKeyStore();
        }
        catch (Exception th) {
            throw new SystemException((Throwable)th);
        }
        super.initialize(resources);
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void setImplementor(Object implementor) {
        Object impl = implementor;
        if (implementor instanceof String) {
            impl = Reflection.newInstance((String)implementor.toString(), null);
        }
        this.implementor = impl;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = Reflection.loadClass((String)serviceClass, null);
    }
}

