/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Startable;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServer
implements Startable {
    protected static Logger logger = Logger.getLogger();
    int maxIdleTime = 0;
    int maxThreads = 0;
    int minThreads = 0;
    protected Server server;
    int httpPort = 0;
    int httpsPort = 0;
    String keyStoreFile;
    String keyStorePassword;
    protected String rootContext = "/";
    protected Map<String, Servlet> servlets = new LinkedHashMap<String, Servlet>();
    protected Map<String, String> webapps = new LinkedHashMap<String, String>();

    protected void init() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (this.maxThreads > 0) {
            threadPool.setMaxThreads(this.maxThreads);
        }
        if (this.minThreads > 0) {
            threadPool.setMinThreads(this.minThreads);
        }
        this.server = new Server((ThreadPool)threadPool);
        if (this.httpPort > 0) {
            ServerConnector http = new ServerConnector(this.server);
            http.setPort(this.httpPort);
            this.server.addConnector((Connector)http);
        }
        if (this.httpsPort > 0) {
            if (this.keyStoreFile == null) {
                throw logger.systemException("Null keystore");
            }
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.keyStoreFile);
            sslContextFactory.setKeyStorePassword(this.keyStorePassword);
            sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.setSecureScheme("https");
            httpsConfig.setSecurePort(this.httpsPort);
            httpsConfig.setSendDateHeader(false);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            sslConnector.setPort(this.httpsPort);
            this.server.addConnector((Connector)sslConnector);
        }
    }

    public void start() {
        this.init();
        HandlerCollection handlers = new HandlerCollection();
        this.initServlets(handlers);
        this.initWebApps(handlers);
        this.server.setHandler((Handler)handlers);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw logger.systemException((Throwable)e);
        }
    }

    protected void initServlets(HandlerCollection handlers) {
        if (this.servlets.size() > 0) {
            ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, this.rootContext);
            for (Map.Entry<String, Servlet> entry : this.servlets.entrySet()) {
                handler.addServlet(new ServletHolder(entry.getValue()), entry.getKey());
            }
            handlers.addHandler((Handler)handler);
        }
    }

    protected void initWebApps(HandlerCollection handlers) {
        if (this.webapps.size() > 0) {
            for (Map.Entry<String, String> entry : this.webapps.entrySet()) {
                String context = entry.getKey();
                WebAppContext webapp = new WebAppContext();
                String root = this.rootContext;
                while (root.endsWith("/")) {
                    root = root.substring(0, root.length() - 1);
                }
                String fullContext = context.startsWith("/") ? root + context : root + "/" + context;
                webapp.setContextPath(fullContext);
                File warFile = new File(entry.getValue());
                webapp.setWar(warFile.getAbsolutePath());
                webapp.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
                handlers.addHandler((Handler)webapp);
            }
        }
    }

    public void addServlet(String context, Servlet servlet) {
        this.servlets.put(context, servlet);
    }

    public void addWebApp(String context, String path) {
        this.webapps.put(context, path);
    }

    public void addWebApps(String path) {
        if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(Paths.get(path, new String[0]));){
                stream.forEach(subdir -> {
                    String context = subdir.getFileName().toString();
                    this.webapps.put(context, subdir.toFile().getAbsolutePath());
                });
            }
            catch (IOException e) {
                logger.systemException((Throwable)e);
            }
        }
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public long getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(String rootContext) {
        this.rootContext = rootContext;
    }
}

