/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.security.JCEKS;
import net.e6tech.elements.security.SelfSignedCert;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class CXFServer
implements Initializable,
Startable {
    @javax.inject.Inject
    protected Provision provision;
    @Inject
    protected Interceptor interceptor;
    protected List<Server> servers = new ArrayList<Server>();
    protected List<URL> URLs = new ArrayList<URL>();
    protected String keyStoreFile;
    protected char[] keyStorePassword;
    protected char[] keyManagerPassword;
    protected SelfSignedCert selfSignedCert;
    @Inject(optional=true)
    protected ExecutorService executor;
    @Inject(optional=true)
    protected QueuedThreadPool queuedThreadPool;
    protected boolean initialized = false;
    private boolean started = false;

    public void setAddresses(List<String> addresses) throws MalformedURLException {
        for (String address : addresses) {
            URL url = new URL(address);
            this.URLs.add(url);
        }
    }

    protected List<URL> getURLs() {
        return this.URLs;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public SelfSignedCert getSelfSignedCert() {
        return this.selfSignedCert;
    }

    public void setSelfSignedCert(SelfSignedCert selfSignedCert) {
        this.selfSignedCert = selfSignedCert;
    }

    public ExecutorService getThreadPool() {
        return this.executor;
    }

    public void setThreadPool(ExecutorService executor) {
        this.executor = executor;
    }

    protected void registerServer(Server server) {
        if (!this.servers.contains(server)) {
            this.servers.add(server);
        }
    }

    protected void initKeyStore() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        KeyManager[] keyManagers;
        if (this.keyStoreFile == null && this.selfSignedCert == null) {
            return;
        }
        if (this.selfSignedCert != null) {
            keyManagers = this.selfSignedCert.getKeyManagers();
            trustManagers = this.selfSignedCert.getTrustManagers();
        } else {
            JCEKS jceKeyStore = new JCEKS(this.keyStoreFile, this.keyStorePassword);
            if (this.keyManagerPassword == null) {
                this.keyManagerPassword = this.keyStorePassword;
            }
            jceKeyStore.init(this.keyManagerPassword);
            keyManagers = jceKeyStore.getKeyManagers();
            trustManagers = jceKeyStore.getTrustManagers();
        }
        TLSServerParameters tlsParams = new TLSServerParameters();
        tlsParams.setKeyManagers(keyManagers);
        tlsParams.setTrustManagers(trustManagers);
        ClientAuthentication ca = new ClientAuthentication();
        ca.setRequired(false);
        ca.setWant(false);
        tlsParams.setClientAuthentication(ca);
        JettyHTTPServerEngineFactory factory = new JettyHTTPServerEngineFactory();
        for (URL url : this.URLs) {
            TLSServerParameters existingParams;
            if (!url.getProtocol().equals("https")) continue;
            JettyHTTPServerEngine engine = factory.retrieveJettyHTTPServerEngine(url.getPort());
            TLSServerParameters tLSServerParameters = existingParams = engine == null ? null : engine.getTlsServerParameters();
            if (existingParams != null) {
                LinkedHashSet<KeyManager> keyManagerSet = new LinkedHashSet<KeyManager>();
                for (KeyManager km : existingParams.getKeyManagers()) {
                    keyManagerSet.add(km);
                }
                for (KeyManager km : keyManagers) {
                    if (keyManagerSet.contains(km)) continue;
                    keyManagerSet.add(km);
                }
                LinkedHashSet<TrustManager> trustManagerSet = new LinkedHashSet<TrustManager>();
                for (TrustManager tm : existingParams.getTrustManagers()) {
                    trustManagerSet.add(tm);
                }
                for (TrustManager tm : trustManagers) {
                    if (trustManagerSet.contains(tm)) continue;
                    trustManagerSet.add(tm);
                }
                existingParams.setKeyManagers(keyManagerSet.toArray(new KeyManager[keyManagerSet.size()]));
                existingParams.setTrustManagers(trustManagerSet.toArray(new TrustManager[trustManagerSet.size()]));
                continue;
            }
            factory.setTLSServerParametersForPort(url.getPort(), tlsParams);
        }
    }

    public void initialize(Resources resources) {
        this.initialized = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.initialized) {
            this.initialize(null);
        }
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.queuedThreadPool != null) {
            for (Server server : this.servers) {
                JettyHTTPDestination jetty;
                Destination dest = server.getDestination();
                if (!(dest instanceof JettyHTTPDestination) || !((jetty = (JettyHTTPDestination)dest).getEngine() instanceof JettyHTTPServerEngine)) continue;
                JettyHTTPServerEngine engine = (JettyHTTPServerEngine)jetty.getEngine();
                ((JettyHTTPServerEngine)jetty.getEngine()).setThreadPool((ThreadPool)this.queuedThreadPool);
            }
        }
        for (Server server : this.servers) {
            server.start();
        }
    }

    public void stop() {
        for (Server server : this.servers) {
            server.stop();
        }
        this.initialized = false;
        this.started = false;
    }
}

