/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.security.vault;

import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.e6tech.elements.common.cache.CacheFacade;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Provision;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Credential;
import net.e6tech.elements.security.vault.VaultManager;
import net.e6tech.elements.web.security.vault.client.Action;
import net.e6tech.elements.web.security.vault.client.Authenticate;
import net.e6tech.elements.web.security.vault.client.Decrypt;
import net.e6tech.elements.web.security.vault.client.Encrypt;
import net.e6tech.elements.web.security.vault.client.GetSecret;
import net.e6tech.elements.web.security.vault.client.PasswordUnlock;
import net.e6tech.elements.web.security.vault.client.Renew;
import net.e6tech.elements.web.security.vault.client.Request;
import net.e6tech.elements.web.security.vault.client.SharedKey;

@Path(value="/keyserver/v1")
public class KeyServer {
    private static Logger logger = Logger.getLogger();
    @Inject
    VaultManager vaultManager;
    @Inject
    Provision provision;
    @Inject
    CacheFacade<String, SecretKey> clientKeys;

    @GET
    @Produces(value={"application/json"})
    @Path(value="publicKey")
    public String getPublicKey() {
        try {
            RSAPublicKeySpec keySpec = this.vaultManager.getPublicKey();
            SharedKey sharedKey = new SharedKey();
            sharedKey.setModulus(keySpec.getModulus());
            sharedKey.setPublicExponent(keySpec.getPublicExponent());
            return Constants.mapper.writeValueAsString((Object)sharedKey);
        }
        catch (BadPaddingException ex) {
            logger.error("bad vault");
            throw new RuntimeException(ex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="request")
    public String request(Request request) {
        String clsName = Action.class.getPackage().getName() + "." + request.getAction();
        Action action = null;
        SecretKey clientKey = null;
        try {
            clientKey = (SecretKey)this.clientKeys.get((Object)request.getClientKey(), () -> {
                byte[] decrypted = this.vaultManager.decryptPrivate(request.getClientKey());
                return new SecretKeySpec(decrypted, this.vaultManager.getSymmetricCipher().getAlgorithm());
            });
            byte[] decrypted = this.vaultManager.getSymmetricCipher().decrypt(clientKey, request.getEncryptedData(), null);
            String encoded = new String(decrypted, "UTF-8");
            Class<?> requestClass = this.getClass().getClassLoader().loadClass(clsName);
            action = (Action)Constants.mapper.readValue(encoded, requestClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String value = null;
        try {
            ClearText ct;
            if (action instanceof Authenticate) {
                Authenticate auth = (Authenticate)action;
                value = this.vaultManager.authorize(new Credential(auth.getUserName(), auth.getPassword()));
            } else if (action instanceof Renew) {
                Renew renew = (Renew)action;
                value = this.vaultManager.renew(renew.getToken());
            } else if (action instanceof GetSecret) {
                GetSecret getSecret = (GetSecret)action;
                ct = this.vaultManager.getSecretData(getSecret.getToken(), getSecret.getAlias());
                value = Constants.mapper.writeValueAsString((Object)ct);
            } else if (action instanceof PasswordUnlock) {
                PasswordUnlock unlock = (PasswordUnlock)action;
                ct = this.vaultManager.passphraseUnlock(unlock.getToken(), unlock.getAlias());
                value = Constants.mapper.writeValueAsString((Object)ct);
            } else if (action instanceof Encrypt) {
                Encrypt encrypt = (Encrypt)action;
                value = this.vaultManager.encrypt(encrypt.getToken(), encrypt.getKeyBlock(), encrypt.getData(), encrypt.getIv());
            } else {
                if (action instanceof Decrypt) {
                    Decrypt decrypt = (Decrypt)action;
                    byte[] result = decrypt.getKeyBlock() == null ? this.vaultManager.decrypt(decrypt.getToken(), decrypt.getSecret()) : this.vaultManager.decrypt(decrypt.getToken(), decrypt.getKeyBlock(), decrypt.getSecret(), decrypt.getIv());
                    return this.vaultManager.getSymmetricCipher().encrypt(clientKey, result, null);
                }
                throw new RuntimeException("Unsupported action " + action);
            }
            return this.vaultManager.getSymmetricCipher().encrypt(clientKey, value.getBytes("UTF-8"), null);
        }
        catch (LoginException ex) {
            logger.warn("" + action, (Throwable)ex);
            throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("" + action, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

