/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.common.logging.Logger;
import org.apache.cxf.common.util.ClassHelper;

public class SecurityAnnotationEngine {
    private static Logger logger = Logger.getLogger();
    private static final String ROLES_ALLOWED_CLASS_NAME = "javax.annotation.security.RolesAllowed";
    private static final String PERMIT_ALL_CLASS_NAME = "javax.annotation.security.PermitAll";
    private static final String DENY_ALL_CLASS_NAME = "javax.annotation.security.DenyAll";
    private static final String ROLE_KEY_PERMIT_ALL = "PERMITALL";
    private static final String ROLE_KEY_DENY_ALL = "DENYALL";
    private static final Set<String> SKIP_METHODS = new HashSet<String>();
    private Map<String, Map<String, String>> scannedClassMap = new HashMap<String, Map<String, String>>();

    public void register(Object object) {
        Class cls = ClassHelper.getRealClass((Object)object);
        if (this.scannedClassMap.containsKey(cls.getName())) {
            return;
        }
        HashMap<String, String> methodMap = new HashMap<String, String>();
        this.scanForPermitAll(cls, methodMap);
        this.scanForDenyAll(cls, methodMap);
        this.scanForRolesAllowed(cls, methodMap);
        if (methodMap.isEmpty()) {
            logger.warn("The roles map is empty, the service object is not protected: " + cls.getName());
        }
        this.scannedClassMap.put(cls.getName(), methodMap);
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, String userRole) {
        return this.hasAccess(instance, method, args, Arrays.asList(userRole));
    }

    public boolean hasAccess(Object instance, Method method, Object[] args, List<String> userRoles) {
        String value = this.lookupRole(instance, method, args);
        if (value == null) {
            logger.warn("no security map entry found: class:" + instance.getClass().getName() + " method:" + this.createMethodSig(method));
            return true;
        }
        if (value.equals(ROLE_KEY_DENY_ALL)) {
            return false;
        }
        if (value.equals(ROLE_KEY_PERMIT_ALL)) {
            return true;
        }
        for (String userRole : userRoles) {
            if (!value.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    public String lookupRole(Object instance, Method method, Object[] args) {
        Class cls = ClassHelper.getRealClass((Object)instance);
        String methodSig = this.createMethodSig(method);
        logger.debug("lookupRole: class:" + cls.getName() + " method:" + methodSig);
        Map<String, String> methodMap = this.scannedClassMap.get(cls.getName());
        if (methodMap == null) {
            return null;
        }
        String roles = methodMap.get(methodSig);
        logger.debug("==> cls:" + cls + " m:" + methodSig + " roles:" + roles);
        return roles;
    }

    public void logMethodMap() {
        ArrayList<String> clsNameList = new ArrayList<String>(this.scannedClassMap.keySet());
        Collections.sort(clsNameList);
        for (String clsName : clsNameList) {
            logger.debug("registered class: " + clsName);
            Map<String, String> methodMap = this.scannedClassMap.get(clsName);
            ArrayList<String> methodNameList = new ArrayList<String>(methodMap.keySet());
            for (String methodName : methodNameList) {
                String roles = methodMap.get(methodName);
                logger.debug("  method: " + methodName + " roles: " + roles);
            }
        }
    }

    private void scanForPermitAll(Class<?> cls, Map<String, String> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        boolean clsLevelPermitAll = this.isAnnotationPresent(cls.getAnnotations(), PERMIT_ALL_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            if (SKIP_METHODS.contains(m.getName())) continue;
            boolean methodLevelPerimitAll = this.isAnnotationPresent(m.getAnnotations(), PERMIT_ALL_CLASS_NAME);
            if (!clsLevelPermitAll && !methodLevelPerimitAll) continue;
            rolesMap.put(this.createMethodSig(m), ROLE_KEY_PERMIT_ALL);
        }
        if (clsLevelPermitAll) {
            return;
        }
        this.scanForPermitAll(cls.getSuperclass(), rolesMap);
    }

    private void scanForDenyAll(Class<?> cls, Map<String, String> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        boolean clsLevelDenyAll = this.isAnnotationPresent(cls.getAnnotations(), DENY_ALL_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            if (SKIP_METHODS.contains(m.getName())) continue;
            boolean methodLevelDenyAll = this.isAnnotationPresent(m.getAnnotations(), DENY_ALL_CLASS_NAME);
            if (!clsLevelDenyAll && !methodLevelDenyAll) continue;
            rolesMap.put(this.createMethodSig(m), ROLE_KEY_DENY_ALL);
        }
        if (clsLevelDenyAll) {
            return;
        }
        this.scanForDenyAll(cls.getSuperclass(), rolesMap);
    }

    private boolean isAnnotationPresent(Annotation[] anns, String annName) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            return true;
        }
        return false;
    }

    private void scanForRolesAllowed(Class<?> cls, Map<String, String> rolesMap) {
        if (cls == null || cls == Object.class) {
            return;
        }
        String classRolesAllowed = this.getRoles(cls.getAnnotations(), ROLES_ALLOWED_CLASS_NAME);
        for (Method m : cls.getMethods()) {
            String theRoles;
            if (SKIP_METHODS.contains(m.getName())) continue;
            String methodRolesAllowed = this.getRoles(m.getAnnotations(), ROLES_ALLOWED_CLASS_NAME);
            String string = theRoles = methodRolesAllowed != null ? methodRolesAllowed : classRolesAllowed;
            if (theRoles == null) continue;
            rolesMap.put(m.getName(), theRoles);
            rolesMap.put(this.createMethodSig(m), theRoles);
        }
        if (!rolesMap.isEmpty()) {
            return;
        }
        this.scanForRolesAllowed(cls.getSuperclass(), rolesMap);
    }

    private String getRoles(Annotation[] anns, String annName) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().getName().equals(annName)) continue;
            try {
                Method valueMethod = ann.annotationType().getMethod("value", new Class[0]);
                String[] roles = (String[])valueMethod.invoke((Object)ann, new Object[0]);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < roles.length; ++i) {
                    sb.append(roles[i]);
                    if (i + 1 >= roles.length) continue;
                    sb.append(" ");
                }
                return sb.toString();
            }
            catch (Exception exception) {
                break;
            }
        }
        return null;
    }

    private String createMethodSig(Method method) {
        StringBuilder b = new StringBuilder(method.getReturnType().getName());
        b.append(' ').append(method.getName()).append('(');
        boolean first = true;
        for (Class<?> cls : method.getParameterTypes()) {
            if (!first) {
                b.append(", ");
                first = false;
            }
            b.append(cls.getName());
        }
        b.append(')');
        return b.toString();
    }

    static {
        SKIP_METHODS.addAll(Arrays.asList("wait", "notify", "notifyAll", "equals", "toString", "hashCode"));
    }
}

