/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.security.vault.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.SecretKey;
import javax.ws.rs.NotAuthorizedException;
import net.e6tech.elements.common.cache.CacheFacade;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;
import net.e6tech.elements.security.AsymmetricCipher;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Credential;
import net.e6tech.elements.web.security.vault.client.Action;
import net.e6tech.elements.web.security.vault.client.Authenticate;
import net.e6tech.elements.web.security.vault.client.Decrypt;
import net.e6tech.elements.web.security.vault.client.Encrypt;
import net.e6tech.elements.web.security.vault.client.GetSecret;
import net.e6tech.elements.web.security.vault.client.PasswordUnlock;
import net.e6tech.elements.web.security.vault.client.Renew;
import net.e6tech.elements.web.security.vault.client.Request;
import net.e6tech.elements.web.security.vault.client.SharedKey;

public class KeyClient
implements Startable {
    private AsymmetricCipher asym = AsymmetricCipher.getInstance((String)"RSA");
    private SymmetricCipher sym = SymmetricCipher.getInstance((String)"AES");
    private String clientKey;
    private SecretKey secretKey;
    private PublicKey publicKey;
    private RestfulClient client;
    private String address = "http://localhost:10000/restful/keyserver/v1";
    private Credential credential;
    private String user;
    private String obfuscatedPassword;
    private long renewInterval = 660000L;
    private boolean started;
    private boolean remoteEncryption = true;
    private CacheFacade<String, SecretKey> cachedSecretKeys;
    private CacheFacade<String, ClearText> cachedSecrets;
    private String clusterAddress;
    private String token;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public long getRenewInterval() {
        return this.renewInterval;
    }

    public void setRenewInterval(long renewInterval) {
        this.renewInterval = renewInterval;
    }

    public boolean isRemoteEncryption() {
        return this.remoteEncryption;
    }

    public void setRemoteEncryption(boolean remoteEncryption) {
        this.remoteEncryption = remoteEncryption;
    }

    public String getClusterAddress() {
        return this.clusterAddress;
    }

    public void setClusterAddress(String clusterAddress) {
        this.clusterAddress = clusterAddress;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.cachedSecretKeys = new CacheFacade<String, SecretKey>("secretKeys"){};
        this.cachedSecretKeys.initPool();
        this.cachedSecrets = new CacheFacade<String, ClearText>("secrets"){};
        this.cachedSecrets.initPool();
        this.initialAuthorization();
        this.startRenewalThread();
    }

    private void initialAuthorization() {
        this.client = new RestfulClient();
        this.client.setAddress(this.address);
        this.client.setClusterAddress(this.clusterAddress);
        try {
            Response response = this.client.get("publicKey", new Param[0]);
            SharedKey sharedKey = (SharedKey)response.read(SharedKey.class);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(sharedKey.getModulus(), sharedKey.getPublicExponent());
            this.secretKey = this.sym.generateKeySpec();
            this.publicKey = this.asym.getKeyFactory().generatePublic(publicKeySpec);
            this.clientKey = this.asym.encrypt(this.publicKey, this.secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new NotAuthorizedException((Object)("Unable to authenticate with keyserver at " + this.address), new Object[0]);
        }
        ServerSocket serverSocket = null;
        try {
            if (this.credential == null) {
                this.credential = new Credential();
            }
            this.credential.run("Authenticating key client");
            this.user = this.credential.getUser();
            byte[] buffer = new byte[this.credential.getPassword().length * 2];
            char[] chars = this.credential.getPassword();
            for (int i = 0; i < chars.length; ++i) {
                buffer[i * 2] = (byte)(chars[i] >> 8);
                buffer[i * 2 + 1] = (byte)chars[i];
            }
            this.obfuscatedPassword = this.sym.encrypt(this.secretKey, buffer, null);
            this.authorize(this.user, this.credential.getPassword());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void startRenewalThread() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(this.renewInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    this.renew();
                    continue;
                }
                catch (GeneralSecurityException e) {
                    this.reAuthorize();
                    continue;
                }
                break;
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    protected void reAuthorize() {
        try {
            byte[] bytes = this.sym.decrypt(this.secretKey, this.obfuscatedPassword, null);
            char[] chars = new char[bytes.length / 2];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (char)(((bytes[i * 2] & 0xFF) << 8) + (bytes[i * 2 + 1] & 0xFF));
            }
            this.authorize(this.user, chars);
        }
        catch (GeneralSecurityException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void authorize(String user, char[] password) throws GeneralSecurityException {
        Authenticate auth = new Authenticate();
        auth.setUserName(user);
        auth.setPassword(password);
        String ret = this.submit(auth);
        byte[] result = this.decryptResult(ret);
        try {
            this.token = new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public boolean isAuthorized() {
        return this.token != null;
    }

    public void renew() throws GeneralSecurityException {
        this.checkToken();
        Renew request = new Renew();
        String ret = this.submit(request);
        byte[] result = this.decryptResult(ret);
        try {
            this.token = new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public ClearText getSecret(String alias) throws GeneralSecurityException {
        this.checkToken();
        return (ClearText)this.cachedSecrets.get((Object)alias, () -> {
            GetSecret request = new GetSecret();
            request.setAlias(alias);
            String ret = this.submit(request);
            return this.decryptResult(ret, ClearText.class);
        });
    }

    public ClearText passwordUnlock(String alias) throws GeneralSecurityException {
        this.checkToken();
        PasswordUnlock request = new PasswordUnlock();
        request.setAlias(alias);
        String ret = this.submit(request);
        return this.decryptResult(ret, ClearText.class);
    }

    public String encrypt(String key, byte[] data, String iv) throws GeneralSecurityException {
        if (this.remoteEncryption) {
            this.checkToken();
            Encrypt request = new Encrypt();
            request.setKeyBlock(key);
            request.setData(data);
            request.setIv(iv);
            String ret = this.submit(request);
            try {
                return new String(this.decryptResult(ret), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new GeneralSecurityException(e);
            }
        }
        SecretKey secretKey = this.getSecretKey(key);
        return this.sym.encrypt(secretKey, data, iv);
    }

    public byte[] decrypt(String key, String secret, String iv) throws GeneralSecurityException {
        if (this.remoteEncryption) {
            this.checkToken();
            Decrypt request = new Decrypt();
            request.setKeyBlock(key);
            request.setSecret(secret);
            request.setIv(iv);
            String ret = this.submit(request);
            return this.decryptResult(ret);
        }
        SecretKey secretKey = this.getSecretKey(key);
        return this.sym.decrypt(secretKey, secret, iv);
    }

    private SecretKey getSecretKey(String key) throws GeneralSecurityException {
        return (SecretKey)this.cachedSecretKeys.get((Object)key, () -> {
            byte[] keyBytes = this.decrypt(key);
            return this.sym.getKeySpec(keyBytes);
        });
    }

    public byte[] decrypt(String key) throws GeneralSecurityException {
        this.checkToken();
        Decrypt request = new Decrypt();
        request.setSecret(key);
        String ret = this.submit(request);
        return this.decryptResult(ret);
    }

    private String submit(Action action) throws GeneralSecurityException {
        Request request = new Request();
        request.setAction(action.getType());
        if (!(action instanceof Authenticate)) {
            action.setToken(this.token);
        }
        String encryptedData = null;
        try {
            encryptedData = this.sym.encrypt(this.secretKey, Constants.mapper.writeValueAsString((Object)action).getBytes("UTF-8"), null);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
        request.setEncryptedData(encryptedData);
        request.setClientKey(this.clientKey);
        Response response = null;
        try {
            response = this.client.post("request", (Object)request, new Param[0]);
            int code = response.getResponseCode();
            if (code == 401 && !(action instanceof Authenticate)) {
                this.reAuthorize();
                action.setToken(this.token);
                response = this.client.post("request", (Object)request, new Param[0]);
            } else if (code < 200 || code > 202) {
                throw new GeneralSecurityException();
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return response.getResult();
    }

    private byte[] decryptResult(String ret) throws GeneralSecurityException {
        return this.sym.decrypt(this.secretKey, ret, null);
    }

    private <T> T decryptResult(String ret, Class<T> cls) throws GeneralSecurityException {
        byte[] result = this.sym.decrypt(this.secretKey, ret, null);
        try {
            String value = new String(result, "UTF-8");
            return (T)Constants.mapper.readValue(value, cls);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    private void checkToken() throws GeneralSecurityException {
        if (this.token == null) {
            throw new GeneralSecurityException("Not authenticated");
        }
    }
}

