/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.cxf.tomcat;

import java.net.URL;
import java.util.Objects;
import net.e6tech.elements.web.cxf.CXFServer;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;

public class TomcatSSL {
    protected Connector createConnector() {
        return new Connector("org.apache.coyote.http11.Http11Nio2Protocol");
    }

    protected Connector initialize(CXFServer cxfServer, URL url, Connector connector) {
        if ("https".equals(url.getProtocol())) {
            connector.setSecure(true);
            connector.setScheme("https");
            connector.setProperty("protocol", "HTTP/1.1");
            connector.setProperty("SSLEnabled", "true");
            connector.setProperty("defaultSSLHostConfigName", url.getHost());
            if (cxfServer.getKeyStoreFile() == null && cxfServer.getKeyStore() == null && cxfServer.getSelfSignedCert() == null) {
                throw new IllegalArgumentException("Missing keyStoreFile or keyStore");
            }
            SSLHostConfig config = new SSLHostConfig();
            config.setHostName(url.getHost());
            this.initializeHostConfig(cxfServer, connector, config);
            if (cxfServer.getClientAuth() != null) {
                config.setCertificateVerification(cxfServer.getClientAuth());
            }
            config.setSslProtocol(cxfServer.getSslProtocol());
            this.customize(cxfServer, connector, config);
            connector.addSslHostConfig(config);
        }
        if (!cxfServer.isSendServerVersion()) {
            connector.setProperty("server", "Elements");
        }
        return connector;
    }

    protected void initializeHostConfig(CXFServer cxfServer, Connector connector, SSLHostConfig config) {
        Objects.requireNonNull(connector);
        if (cxfServer.getKeyStoreFile() != null) {
            config.setCertificateKeystoreFile(cxfServer.getKeyStoreFile());
            if (cxfServer.getKeyStorePassword() != null) {
                config.setCertificateKeystorePassword(new String(cxfServer.getKeyStorePassword()));
            }
            if (cxfServer.getKeyManagerPassword() != null) {
                config.setCertificateKeyPassword(new String(cxfServer.getKeyManagerPassword()));
            }
            config.setCertificateKeystoreType(cxfServer.getKeyStoreFormat());
        } else if (cxfServer.getKeyStore() != null) {
            SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(config, SSLHostConfigCertificate.Type.UNDEFINED);
            certificate.setCertificateKeystore(cxfServer.getKeyStore());
            if (cxfServer.getKeyStorePassword() != null) {
                certificate.setCertificateKeystorePassword(new String(cxfServer.getKeyStorePassword()));
            }
            if (cxfServer.getKeyManagerPassword() != null) {
                certificate.setCertificateKeyPassword(new String(cxfServer.getKeyManagerPassword()));
            }
            config.addCertificate(certificate);
        } else {
            SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(config, SSLHostConfigCertificate.Type.UNDEFINED);
            certificate.setCertificateKeystore(cxfServer.getSelfSignedCert().getKeyStore());
            certificate.setCertificateKeystorePassword(new String(cxfServer.getSelfSignedCert().getPassword()));
            certificate.setCertificateKeyPassword(new String(cxfServer.getSelfSignedCert().getPassword()));
            config.addCertificate(certificate);
        }
    }

    protected void customize(CXFServer cxfServer, Connector connector, SSLHostConfig config) {
    }
}

