/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.web.webserver.tomcat;

import java.net.URL;
import java.util.Map;
import javax.servlet.Servlet;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.web.webserver.WebEngine;
import net.e6tech.elements.web.webserver.WebServer;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.net.SSLHostConfig;

public class TomcatWebEngine
implements WebEngine {
    private static Logger logger = Logger.getLogger();
    private int maxThreads = 250;
    private int minSpareThreads = 10;
    private int maxConnections = 10000;
    private String baseDir;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void start(WebServer server) {
        Connector connector;
        Tomcat tomcat = (Tomcat)server.computeServerData(Tomcat::new);
        tomcat.setHostname(server.getHost());
        this.registerServlets(server, tomcat);
        if (this.baseDir != null) {
            if (server.getHttpPort() > 0) {
                tomcat.setBaseDir(this.baseDir + "." + server.getHttpPort());
            } else if (server.getHttpsPort() > 0) {
                tomcat.setBaseDir(this.baseDir + "." + server.getHttpsPort());
            }
        }
        if (server.getHttpPort() >= 0) {
            try {
                connector = this.createConnector(server, new URL("http://" + server.getHost() + ":" + server.getHttpPort()));
                connector.setPort(server.getHttpPort());
                tomcat.setConnector(connector);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        if (server.getHttpsPort() >= 0) {
            try {
                connector = this.createConnector(server, new URL("https://" + server.getHost() + ":" + server.getHttpsPort()));
                connector.setPort(server.getHttpsPort());
                tomcat.setConnector(connector);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        try {
            tomcat.start();
        }
        catch (LifecycleException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void stop(WebServer webServer) {
        Tomcat tomcat = (Tomcat)webServer.getServerData();
        if (tomcat == null) {
            return;
        }
        try {
            tomcat.stop();
            tomcat.destroy();
            webServer.setServerData(null);
        }
        catch (Exception ex) {
            logger.warn("Cannot stop Tomcat {}:{}/{}", new Object[]{webServer.getHost(), webServer.getHttpPort(), webServer.getHttpsPort()});
        }
    }

    private void registerServlets(WebServer server, Tomcat tomcat) {
        for (Map.Entry entry : server.getServlets().entrySet()) {
            Context ctx = tomcat.addContext((String)entry.getKey(), null);
            tomcat.addServlet((String)entry.getKey(), "servlet", (Servlet)entry.getValue());
            ctx.addServletMappingDecoded("/*", "servlet");
        }
    }

    protected Connector createConnector(WebServer server, URL url) {
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(url.getPort());
        connector.setProperty("maxThreads", String.valueOf(this.maxThreads));
        connector.setProperty("maxConnections", String.valueOf(this.maxConnections));
        connector.setProperty("minSpareThreads", String.valueOf(this.minSpareThreads));
        connector.setProperty("address", url.getHost());
        if ("https".equals(url.getProtocol())) {
            connector.setSecure(true);
            connector.setScheme("https");
            connector.setProperty("protocol", "HTTP/1.1");
            connector.setProperty("SSLEnabled", String.valueOf(true));
            connector.setProperty("defaultSSLHostConfigName", url.getHost());
            if (server.getKeyStoreFile() == null) {
                throw new IllegalArgumentException("Missing keyStoreFile or keyStore");
            }
            SSLHostConfig config = new SSLHostConfig();
            config.setHostName(url.getHost());
            if (server.getKeyStoreFile() != null) {
                config.setCertificateKeystoreFile(server.getKeyStoreFile());
                if (server.getKeyStorePassword() != null) {
                    config.setCertificateKeystorePassword(new String(server.getKeyStorePassword()));
                }
                if (server.getKeyManagerPassword() != null) {
                    config.setCertificateKeyPassword(new String(server.getKeyManagerPassword()));
                }
                config.setCertificateKeystoreType(server.getKeyStoreFormat());
            }
            if (server.getClientAuth() != null) {
                config.setCertificateVerification(server.getClientAuth());
            }
            config.setSslProtocol(server.getSslProtocol());
            connector.addSslHostConfig(config);
        }
        return connector;
    }
}

