/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;

public class TranslateISOPINBlock
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        if (!"1".equals(this.getField(1))) {
            throw new CommandException(1, (Throwable)new IllegalArgumentException("only ANSI pin block is supported"));
        }
        if (!"1".equals(this.getField(2))) {
            throw new CommandException(2, (Throwable)new IllegalArgumentException("only ANSI pin block is supported"));
        }
        if (!"M".equals(this.getField(4))) {
            throw new CommandException(2, (Throwable)new IllegalArgumentException("only M, master session, is supported for incoming key management"));
        }
        if (!"M".equals(this.getField(7))) {
            throw new CommandException(2, (Throwable)new IllegalArgumentException("only M, master session, is supported for outgoing key management"));
        }
        AnsiPinBlock pinBlock = this.getPinBlock(3, 9, 10);
        AnsiPinBlock outgoing = new AnsiPinBlock(this.getField(11), pinBlock.getPIN());
        AKB kpeIn = new AKB(this.getField(3));
        AKB kpeOut = new AKB(this.getField(6));
        TranslateISOPINBlock.run(3, () -> this.simulator.decryptKey(kpeIn));
        TranslateISOPINBlock.run(6, () -> this.simulator.decryptKey(kpeOut));
        byte[] encrypted = TranslateISOPINBlock.run(6, () -> this.simulator.encrypt(new AKB(this.getField(6)), outgoing.getEncoding()));
        return "4E#" + Hex.toString(encrypted) + "#Y#" + kpeIn.getCheckDigits() + "#" + kpeOut.getCheckDigits() + "##";
    }
}

