/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.SSLBaseConfig;

public class SSLServerSocketConfig
extends SSLBaseConfig {
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private SSLServerSocketFactory sslServerSocketFactory;

    public SSLServerSocketFactory getSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        if (this.sslServerSocketFactory != null) {
            return this.sslServerSocketFactory;
        }
        this.sslServerSocketFactory = new JavaKeyStore(this.getKeyStore(), this.getKeyStorePassword(), this.getKeyStoreFormat()).includeSystem(this.isIncludeSystem()).init(this.getKeyManagerPassword()).createServerSocketFactory(this.getTlsProtocol());
        this.erasePasswords();
        return this.sslServerSocketFactory;
    }

    public ServerSocket createServerSocket(int port) throws GeneralSecurityException, IOException {
        if (this.getKeyStore() != null) {
            SSLServerSocket sslServerSocket = (SSLServerSocket)this.getSSLServerSocketFactory().createServerSocket(port);
            if (this.enabledProtocols != null) {
                sslServerSocket.setEnabledProtocols(this.enabledProtocols);
            }
            if (this.enabledCipherSuites != null) {
                sslServerSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslServerSocket;
        }
        return new ServerSocket(port);
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }
}

