/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Vault;
import net.e6tech.elements.security.vault.VaultFormat;
import net.e6tech.elements.security.vault.VaultImpl;
import net.e6tech.elements.security.vault.VaultStore;

public class FileStore
implements VaultStore {
    private static Logger logger = Logger.getLogger();
    private Map<String, VaultImpl> vaults = new LinkedHashMap<String, VaultImpl>();
    private Set<String> managedVaults = new HashSet<String>();
    private String fileName;

    public FileStore() {
    }

    public FileStore(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public VaultStore manage(String ... vaultNames) {
        if (vaultNames == null) {
            return this;
        }
        for (String vaultName : vaultNames) {
            this.vaults.computeIfAbsent(vaultName, key -> new VaultImpl());
            this.managedVaults.add(vaultName);
        }
        return this;
    }

    @Override
    public VaultStore unmanage(String vaultName) {
        this.vaults.remove(vaultName);
        this.managedVaults.remove(vaultName);
        return this;
    }

    @Override
    public Vault getVault(String vaultName) {
        Vault vault = this.vaults.get(vaultName);
        if (vault == null && this.managedVaults.contains(vaultName)) {
            this.manage(vaultName);
            vault = this.vaults.get(vaultName);
        }
        return vault;
    }

    @Override
    public void backup(String version) throws IOException {
        this.copy(true, version);
    }

    @Override
    public void restore(String version) throws IOException {
        this.copy(false, version);
        this.open();
    }

    protected void copy(boolean backup, String version) throws IOException {
        File file;
        String backupFile;
        int index = this.fileName.lastIndexOf(46);
        if (index > 0) {
            String extension = this.fileName.substring(index);
            backupFile = this.fileName.substring(0, index) + "_" + version + extension;
        } else {
            backupFile = this.fileName + "_" + version;
        }
        if (backup) {
            file = new File(this.fileName);
            if (!file.exists()) {
                throw new IOException("Vault file does not exist: " + this.fileName);
            }
            if (!Paths.get(backupFile, new String[0]).toFile().exists()) {
                Files.copy(Paths.get(this.fileName, new String[0]), Paths.get(backupFile, new String[0]), new CopyOption[0]);
            }
        } else {
            file = new File(backupFile);
            if (!file.exists()) {
                throw new IOException("Backup vault file does not exist: " + this.fileName);
            }
            Files.copy(Paths.get(backupFile, new String[0]), Paths.get(this.fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public void save() throws IOException {
        File file;
        if (this.fileName == null) {
            throw new IOException("null fileName");
        }
        boolean shouldBackup = false;
        for (VaultImpl vault2 : this.vaults.values()) {
            if (!vault2.isModified()) continue;
            shouldBackup = true;
            break;
        }
        if (shouldBackup && (file = new File(this.fileName)).exists()) {
            String backupFileName = this.backupFileName();
            File backupFile = new File(backupFileName);
            while (backupFile.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                backupFileName = this.backupFileName();
                backupFile = new File(backupFileName);
            }
            Files.copy(Paths.get(this.fileName, new String[0]), Paths.get(backupFileName, new String[0]), new CopyOption[0]);
        }
        Constants.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(this.fileName), (Object)new VaultFormat(this.vaults));
        this.vaults.values().forEach(vault -> vault.setModified(false));
    }

    private String backupFileName() {
        String backupFile;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        int index = this.fileName.lastIndexOf(46);
        if (index > 0) {
            String extension = this.fileName.substring(index);
            backupFile = this.fileName.substring(0, index) + "-" + format.format(new Date()) + "-backup" + extension;
        } else {
            backupFile = this.fileName + "-" + format.format(new Date());
        }
        return backupFile;
    }

    @Override
    public void open() throws IOException {
        if (this.fileName == null) {
            throw new IOException("null fileName");
        }
        logger.info("Opening file vault {}", (Object)this.fileName);
        File file = new File(this.fileName);
        if (!file.exists()) {
            for (String v : this.managedVaults) {
                this.vaults.put(v, new VaultImpl());
            }
            return;
        }
        VaultFormat format = (VaultFormat)Constants.mapper.readValue(new File(this.fileName), VaultFormat.class);
        format.checkVersion();
        for (String v : this.managedVaults) {
            VaultImpl impl = format.getVaults().get(v);
            if (impl == null) continue;
            this.vaults.put(v, impl);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String writeString() throws IOException {
        try {
            return Constants.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VaultFormat(this.vaults));
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }
}

