/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;

public class GenerateHMAC
extends Command {
    @Override
    public String doProcess() {
        try {
            AKB akb = this.simulator.getKey("KMAC");
            byte[] kmac = akb.decryptKey(this.simulator.masterKeyBytes());
            String mac = this.generateMAC(this.getField(4), kmac);
            return "49B#" + mac + "#" + akb.checkDigits + "##";
        }
        catch (GeneralSecurityException e) {
            Logger.suppress((Throwable)e);
            return "00#000000";
        }
    }

    public String generateMAC(String verificationData, byte[] key) throws GeneralSecurityException {
        String hmacAlg;
        if (key.length != 16) {
            throw new GeneralSecurityException("Must be a dual length DES key.");
        }
        String algorithm = this.getField(3);
        if (algorithm.equalsIgnoreCase("h")) {
            hmacAlg = "HmacSHA1";
        } else if (algorithm.equals("2")) {
            hmacAlg = "HmacSHA256";
        } else {
            throw new GeneralSecurityException("Unsupported HMAC algorithm");
        }
        Mac sha256HMAC = Mac.getInstance(hmacAlg);
        SecretKeySpec secretkey = new SecretKeySpec(key, hmacAlg);
        sha256HMAC.init(secretkey);
        byte[] mac = sha256HMAC.doFinal(DatatypeConverter.parseHexBinary((String)verificationData));
        return DatatypeConverter.printHexBinary((byte[])mac);
    }
}

