/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.CryptoUtil;

public class EMVPINChange
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        Request request = new Request();
        Response response = new Response();
        if ("0".equals(request.getDerivationType())) {
            return this.processCommonSession(request, response, false);
        }
        if ("1".equals(request.getDerivationType())) {
            return this.processDerivationType1(request, response);
        }
        if ("8".equals(request.getDerivationType())) {
            return this.processCommonSession(request, response, true);
        }
        return "000100";
    }

    protected String processDerivationType1(Request request, Response response) throws CommandException {
        byte[] encipheredPaddedPINBytesD2;
        byte[] encipheredPaddedPINBytesD1;
        byte[] inputBytesBasedOnUDKA = new byte[8];
        Arrays.fill(inputBytesBasedOnUDKA, 0, 4, (byte)0);
        try {
            String kpeDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getKpe(), 6);
            response.setKpeDigits(kpeDigits);
            byte[] iccMasterKeyBytes = CryptoUtil.derivativeICCMasterKeyBytes(this.simulator, new AKB(request.getKpe()), request.getPan(), request.getPanSequenceNumber());
            System.arraycopy(iccMasterKeyBytes, 4, inputBytesBasedOnUDKA, 4, 4);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(4, (Throwable)e);
        }
        byte[] inputPINBytes = new byte[8];
        try {
            byte[] newPINBlockByte = this.simulator.decrypt(new AKB(request.getKpe()), Hex.toBytes(request.getNewPINBlock()));
            AnsiPinBlock ansiPinBlock = new AnsiPinBlock(newPINBlockByte, request.getPinBlockBlockData());
            String newPIN = ansiPinBlock.getPIN();
            inputPINBytes[0] = (byte)newPIN.length();
            byte[] newPINBytes = Hex.toBytes(newPIN);
            System.arraycopy(newPINBytes, 0, inputPINBytes, 1, newPINBytes.length);
            Arrays.fill(inputPINBytes, 1 + newPINBytes.length, inputPINBytes.length, (byte)-1);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(8, (Throwable)e);
        }
        byte[] plainPINBytes = new byte[8];
        for (int i = 0; i < plainPINBytes.length; ++i) {
            plainPINBytes[i] = (byte)(inputBytesBasedOnUDKA[i] ^ inputPINBytes[i]);
        }
        if (!StringUtil.isNullOrEmpty((String)request.getOldPINBlockBlockData())) {
            try {
                byte[] oldPINBlockBytes = this.simulator.decrypt(new AKB(request.getKpe()), Hex.toBytes(request.getOldPINBlockBlockData()));
                AnsiPinBlock ansiPinBlock = new AnsiPinBlock(oldPINBlockBytes, request.getPinBlockBlockData());
                String oldPIN = ansiPinBlock.getPIN();
                String paddedOldPIN = StringUtil.padRight((String)oldPIN, (int)16, (char)'0');
                byte[] paddedOldPINBytes = Hex.toBytes(paddedOldPIN);
                for (int i = 0; i < plainPINBytes.length; ++i) {
                    plainPINBytes[i] = (byte)(paddedOldPINBytes[i] ^ inputPINBytes[i]);
                }
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(15, (Throwable)e);
            }
        }
        byte[] plainPaddedPINBytesD1 = new byte[8];
        byte[] plainPaddedPINBytesD2 = new byte[8];
        plainPaddedPINBytesD1[0] = 8;
        System.arraycopy(plainPINBytes, 0, plainPaddedPINBytesD1, 1, 7);
        plainPaddedPINBytesD2[0] = plainPINBytes[7];
        plainPaddedPINBytesD2[1] = -128;
        Arrays.fill(plainPaddedPINBytesD2, 2, 8, (byte)0);
        byte[] sessionKeySmEncKeyBytes = this.deriveSessionKeySmEncKeyBytes(request, response);
        try {
            encipheredPaddedPINBytesD1 = CryptoUtil.encrypt(sessionKeySmEncKeyBytes, plainPaddedPINBytesD1);
            encipheredPaddedPINBytesD2 = CryptoUtil.encrypt(sessionKeySmEncKeyBytes, plainPaddedPINBytesD2);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(12, (Throwable)e);
        }
        byte[] encipheredPaddedPINBytes = Hex.concat(encipheredPaddedPINBytesD1, encipheredPaddedPINBytesD2);
        response.setEncipheredPaddedPINBytes(encipheredPaddedPINBytes);
        this.addMac(request, response, encipheredPaddedPINBytes);
        this.calculateImkACCheckDigits(request, response);
        response.setSanityCheck("Y");
        return response.output();
    }

    protected String processCommonSession(Request request, Response response, boolean withMandatoryPadding) throws CommandException {
        byte[] encipheredPaddedPINBytes;
        try {
            String kpeDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getKpe(), 6);
            response.setKpeDigits(kpeDigits);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(4, (Throwable)e);
        }
        byte[] paddedPINBytes = new byte[withMandatoryPadding ? 16 : 8];
        try {
            byte[] newPINBlockByte = this.simulator.decrypt(new AKB(request.getKpe()), Hex.toBytes(request.getNewPINBlock()));
            AnsiPinBlock ansiPinBlock = new AnsiPinBlock(newPINBlockByte, request.getPinBlockBlockData());
            String newPIN = ansiPinBlock.getPIN();
            paddedPINBytes[0] = (byte)(32 + newPIN.length());
            if (newPIN.length() % 2 == 1) {
                newPIN = newPIN + "F";
            }
            byte[] newPINBytes = Hex.toBytes(newPIN);
            System.arraycopy(newPINBytes, 0, paddedPINBytes, 1, newPINBytes.length);
            Arrays.fill(paddedPINBytes, 1 + newPINBytes.length, 8, (byte)-1);
            if (withMandatoryPadding) {
                paddedPINBytes[8] = -128;
            }
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(8, (Throwable)e);
        }
        byte[] sessionKeySmEncKeyBytes = this.deriveSessionKeySmEncKeyBytes(request, response);
        try {
            encipheredPaddedPINBytes = CryptoUtil.encrypt(sessionKeySmEncKeyBytes, paddedPINBytes);
            response.setEncipheredPaddedPINBytes(encipheredPaddedPINBytes);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(12, (Throwable)e);
        }
        this.addMac(request, response, encipheredPaddedPINBytes);
        this.calculateImkACCheckDigits(request, response);
        response.setSanityCheck("Y");
        return response.output();
    }

    private byte[] deriveSessionKeySmEncKeyBytes(Request request, Response response) throws CommandException {
        byte[] sessionKeySmEncKeyBytes;
        byte[] iccMasterKeySmEncKeys;
        try {
            String imkSmEncKeyCheckDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getImkSmEnc(), 6);
            response.setImkSmEncKeyCheckDigits(imkSmEncKeyCheckDigits);
            iccMasterKeySmEncKeys = CryptoUtil.derivativeICCMasterKeyBytes(this.simulator, new AKB(request.getImkSmEnc()), request.getPan(), request.getPanSequenceNumber());
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(5, (Throwable)e);
        }
        try {
            sessionKeySmEncKeyBytes = CryptoUtil.deriveSessionKeyBytes(iccMasterKeySmEncKeys, request.getDiversificationData());
            String sessionKeySmEncKeyCheckDigits = CryptoUtil.calculateKeyBytesCheckDigits(sessionKeySmEncKeyBytes, 6);
            response.setSessionKeySmEncKeyCheckDigits(sessionKeySmEncKeyCheckDigits);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(12, (Throwable)e);
        }
        return sessionKeySmEncKeyBytes;
    }

    protected void addMac(Request request, Response response, byte[] encipheredPaddedPINBytes) throws CommandException {
        byte[] iccMasterSmMacBytes;
        byte[] dataToCalculateMac = Hex.toBytes(request.getApplicationData() + Hex.toString(encipheredPaddedPINBytes));
        byte[] paddedDataToCalculateMac = EMVPINChange.padDatablock(dataToCalculateMac);
        try {
            String imkSmMacCheckDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getImkSmMac(), 6);
            response.setImkSmMacCheckDigits(imkSmMacCheckDigits);
            iccMasterSmMacBytes = CryptoUtil.derivativeICCMasterKeyBytes(this.simulator, new AKB(request.getImkSmMac()), request.getPan(), request.getPanSequenceNumber());
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(6, (Throwable)e);
        }
        try {
            byte[] sessionSmMacBytes = CryptoUtil.deriveSessionKeyBytes(iccMasterSmMacBytes, request.getDiversificationData());
            SecretKey sessionSmMac = CryptoUtil.createSecretKey(sessionSmMacBytes);
            String sessionSmMacCheckDigits = CryptoUtil.calculateCheckDigits(sessionSmMac, 6);
            response.setSessionSmMacCheckDigits(sessionSmMacCheckDigits);
            String mac = CryptoUtil.iso9797Alg3Mac(sessionSmMacBytes, paddedDataToCalculateMac, 16);
            response.setMac(mac);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(12, (Throwable)e);
        }
    }

    public static byte[] padDatablock(byte[] data) {
        int paddedEndCharCountExcept80 = (8 - (data.length + 1) % 8) % 8;
        byte[] result = new byte[data.length + 1 + paddedEndCharCountExcept80];
        System.arraycopy(data, 0, result, 0, data.length);
        result[data.length] = -128;
        Arrays.fill(result, data.length + 1, result.length, (byte)0);
        return result;
    }

    protected void calculateImkACCheckDigits(Request request, Response response) throws CommandException {
        if (StringUtil.isNullOrEmpty((String)request.getImkAC())) {
            response.setImkACCheckDigits("");
        } else {
            try {
                String imkACCheckDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getImkAC(), 6);
                response.setImkACCheckDigits(imkACCheckDigits);
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(7, (Throwable)e);
            }
        }
    }

    class Response {
        private String commandIdentifier = "451";
        private String sanityCheck;
        byte[] encipheredPaddedPINBytes;
        String mac;
        String kpeDigits;
        String imkSmEncKeyCheckDigits;
        String imkSmMacCheckDigits;
        String imkACCheckDigits;
        String sessionKeySmEncKeyCheckDigits;
        String sessionSmMacCheckDigits;

        Response() {
        }

        public String output() {
            StringBuilder response = new StringBuilder(this.commandIdentifier);
            response.append("#" + this.sanityCheck).append("#").append(Hex.toString(this.encipheredPaddedPINBytes)).append("#").append(this.mac).append("#" + this.kpeDigits).append("#" + this.imkSmEncKeyCheckDigits).append("#" + this.imkSmMacCheckDigits).append("#" + this.imkACCheckDigits).append("#" + this.sessionKeySmEncKeyCheckDigits).append("#" + this.sessionSmMacCheckDigits).append("#");
            return response.toString();
        }

        public void setCommandIdentifier(String commandIdentifier) {
            this.commandIdentifier = commandIdentifier;
        }

        public void setSanityCheck(String sanityCheck) {
            this.sanityCheck = sanityCheck;
        }

        public void setEncipheredPaddedPINBytes(byte[] encipheredPaddedPINBytes) {
            this.encipheredPaddedPINBytes = encipheredPaddedPINBytes;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public void setKpeDigits(String kpeDigits) {
            this.kpeDigits = kpeDigits;
        }

        public void setImkSmEncKeyCheckDigits(String imkSmEncKeyCheckDigits) {
            this.imkSmEncKeyCheckDigits = imkSmEncKeyCheckDigits;
        }

        public void setImkSmMacCheckDigits(String imkSmMacCheckDigits) {
            this.imkSmMacCheckDigits = imkSmMacCheckDigits;
        }

        public void setImkACCheckDigits(String imkACCheckDigits) {
            this.imkACCheckDigits = imkACCheckDigits;
        }

        public void setSessionKeySmEncKeyCheckDigits(String sessionKeySmEncKeyCheckDigits) {
            this.sessionKeySmEncKeyCheckDigits = sessionKeySmEncKeyCheckDigits;
        }

        public void setSessionSmMacCheckDigits(String sessionSmMacCheckDigits) {
            this.sessionSmMacCheckDigits = sessionSmMacCheckDigits;
        }
    }

    class Request {
        private String derivationType;
        private String incomingPINBlockType;
        private String kpe;
        private String imkSmEnc;
        private String imkSmMac;
        private String imkAC;
        private String newPINBlock;
        private String pinIssueNumber;
        private String pan;
        String panSequenceNumber;
        private String diversificationData;
        private String applicationData;
        private String pinBlockBlockData;
        private String oldPINBlockBlockData;

        public Request() {
            this.derivationType = EMVPINChange.this.getField(1);
            this.incomingPINBlockType = EMVPINChange.this.getField(2);
            this.kpe = EMVPINChange.this.getField(4);
            this.imkSmEnc = EMVPINChange.this.getField(5);
            this.imkSmMac = EMVPINChange.this.getField(6);
            this.imkAC = EMVPINChange.this.getField(7);
            this.newPINBlock = EMVPINChange.this.getField(8);
            this.pinIssueNumber = EMVPINChange.this.getField(9);
            this.pan = EMVPINChange.this.getField(10);
            this.panSequenceNumber = EMVPINChange.this.getField(11);
            this.diversificationData = EMVPINChange.this.getField(12);
            this.applicationData = EMVPINChange.this.getField(13);
            this.pinBlockBlockData = EMVPINChange.this.getField(14);
            if (EMVPINChange.this.fields.length > 15) {
                this.oldPINBlockBlockData = EMVPINChange.this.getField(15);
            }
        }

        public String getDerivationType() {
            return this.derivationType;
        }

        public void setDerivationType(String derivationType) {
            this.derivationType = derivationType;
        }

        public String getIncomingPINBlockType() {
            return this.incomingPINBlockType;
        }

        public void setIncomingPINBlockType(String incomingPINBlockType) {
            this.incomingPINBlockType = incomingPINBlockType;
        }

        public String getKpe() {
            return this.kpe;
        }

        public void setKpe(String kpe) {
            this.kpe = kpe;
        }

        public String getImkSmEnc() {
            return this.imkSmEnc;
        }

        public void setImkSmEnc(String imkSmEnc) {
            this.imkSmEnc = imkSmEnc;
        }

        public String getImkSmMac() {
            return this.imkSmMac;
        }

        public void setImkSmMac(String imkSmMac) {
            this.imkSmMac = imkSmMac;
        }

        public String getImkAC() {
            return this.imkAC;
        }

        public void setImkAC(String imkAC) {
            this.imkAC = imkAC;
        }

        public String getNewPINBlock() {
            return this.newPINBlock;
        }

        public void setNewPINBlock(String newPINBlock) {
            this.newPINBlock = newPINBlock;
        }

        public String getPinIssueNumber() {
            return this.pinIssueNumber;
        }

        public void setPinIssueNumber(String pinIssueNumber) {
            this.pinIssueNumber = pinIssueNumber;
        }

        public String getPan() {
            return this.pan;
        }

        public void setPan(String pan) {
            this.pan = pan;
        }

        public String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        public String getDiversificationData() {
            return this.diversificationData;
        }

        public void setDiversificationData(String diversificationData) {
            this.diversificationData = diversificationData;
        }

        public String getApplicationData() {
            return this.applicationData;
        }

        public void setApplicationData(String applicationData) {
            this.applicationData = applicationData;
        }

        public String getPinBlockBlockData() {
            return this.pinBlockBlockData;
        }

        public void setPinBlockBlockData(String pinBlockBlockData) {
            this.pinBlockBlockData = pinBlockBlockData;
        }

        public String getOldPINBlockBlockData() {
            return this.oldPINBlockBlockData;
        }

        public void setOldPINBlockBlockData(String oldPINBlockBlockData) {
            this.oldPINBlockBlockData = oldPINBlockBlockData;
        }
    }
}

