/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.CryptoUtil;

public class EMVGenerateMAC
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        Request request = new Request();
        Response response = new Response();
        response.setMacLengthType(request.getMacLengthType());
        if ("0".equals(request.getDerivationType()) || "1".equals(request.getDerivationType())) {
            byte[] iccMasterSmMacBytes;
            try {
                String imkSmMacCheckDigits = CryptoUtil.calculateCheckDigits(this.simulator, request.getImkSmMac(), 6);
                response.setImkSmMacCheckDigits(imkSmMacCheckDigits);
                iccMasterSmMacBytes = CryptoUtil.derivativeICCMasterKeyBytes(this.simulator, new AKB(request.getImkSmMac()), request.getPan(), request.getPanSequenceNumber());
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(2, (Throwable)e);
            }
            try {
                byte[] sessionSmMacBytes = CryptoUtil.deriveSessionKeyBytes(iccMasterSmMacBytes, request.getDiversificationData());
                String sessionSmMacCheckDigits = CryptoUtil.calculateKeyBytesCheckDigits(sessionSmMacBytes, 6);
                response.setSessionSmMacCheckDigits(sessionSmMacCheckDigits);
                String mac = CryptoUtil.iso9797Alg3Mac(sessionSmMacBytes, Hex.toBytes(request.getPaddedData()), request.getMacLength());
                response.setMac(mac);
            }
            catch (GeneralSecurityException e) {
                throw new CommandException(8, (Throwable)e);
            }
            return response.output();
        }
        return "000100";
    }

    class Response {
        private String commandIdentifier = "452";
        String macLengthType;
        String mac;
        String sessionSmMacCheckDigits;
        String imkSmMacCheckDigits;

        Response() {
        }

        public String output() {
            StringBuilder response = new StringBuilder(this.commandIdentifier);
            response.append("#" + this.macLengthType);
            response.append("#" + this.mac.replaceAll("(.{4})", "$1 ").trim());
            response.append("#" + this.sessionSmMacCheckDigits);
            response.append("#" + this.imkSmMacCheckDigits);
            response.append("#");
            return response.toString();
        }

        public String getCommandIdentifier() {
            return this.commandIdentifier;
        }

        public void setCommandIdentifier(String commandIdentifier) {
            this.commandIdentifier = commandIdentifier;
        }

        public String getMacLengthType() {
            return this.macLengthType;
        }

        public void setMacLengthType(String macLengthType) {
            this.macLengthType = macLengthType;
        }

        public String getMac() {
            return this.mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public String getSessionSmMacCheckDigits() {
            return this.sessionSmMacCheckDigits;
        }

        public void setSessionSmMacCheckDigits(String sessionSmMacCheckDigits) {
            this.sessionSmMacCheckDigits = sessionSmMacCheckDigits;
        }

        public String getImkSmMacCheckDigits() {
            return this.imkSmMacCheckDigits;
        }

        public void setImkSmMacCheckDigits(String imkSmMacCheckDigits) {
            this.imkSmMacCheckDigits = imkSmMacCheckDigits;
        }
    }

    class Request {
        private String derivationType;
        private String imkSmMac;
        private String pan;
        private String panSequenceNumber;
        private String diversificationData;
        private String macLengthType;
        int macLength;
        private String continuationIV;
        private String paddedData;

        public Request() {
            this.derivationType = EMVGenerateMAC.this.getField(1);
            this.imkSmMac = EMVGenerateMAC.this.getField(2);
            this.pan = EMVGenerateMAC.this.getField(3);
            this.panSequenceNumber = EMVGenerateMAC.this.getField(4);
            this.diversificationData = EMVGenerateMAC.this.getField(5);
            switch (this.macLengthType = EMVGenerateMAC.this.getField(6)) {
                case "1": {
                    this.macLength = 8;
                    break;
                }
                case "2": {
                    this.macLength = 12;
                    break;
                }
                case "3": {
                    this.macLength = 16;
                    break;
                }
                default: {
                    this.macLength = 0;
                }
            }
            this.continuationIV = EMVGenerateMAC.this.getField(7);
            this.paddedData = EMVGenerateMAC.this.getField(8);
        }

        public String getDerivationType() {
            return this.derivationType;
        }

        public void setDerivationType(String derivationType) {
            this.derivationType = derivationType;
        }

        public String getImkSmMac() {
            return this.imkSmMac;
        }

        public void setImkSmMac(String imkSmMac) {
            this.imkSmMac = imkSmMac;
        }

        public String getPan() {
            return this.pan;
        }

        public void setPan(String pan) {
            this.pan = pan;
        }

        public String getPanSequenceNumber() {
            return this.panSequenceNumber;
        }

        public void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        public String getDiversificationData() {
            return this.diversificationData;
        }

        public void setDiversificationData(String diversificationData) {
            this.diversificationData = diversificationData;
        }

        public String getMacLengthType() {
            return this.macLengthType;
        }

        public void setMacLengthType(String macLengthType) {
            this.macLengthType = macLengthType;
        }

        public int getMacLength() {
            return this.macLength;
        }

        public void setMacLength(int macLength) {
            this.macLength = macLength;
        }

        public String getContinuationIV() {
            return this.continuationIV;
        }

        public void setContinuationIV(String continuationIV) {
            this.continuationIV = continuationIV;
        }

        public String getPaddedData() {
            return this.paddedData;
        }

        public void setPaddedData(String paddedData) {
            this.paddedData = paddedData;
        }
    }
}

