/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.util.Arrays;

public abstract class SSLBaseConfig {
    private String tlsProtocol = "TLSv1.2";
    private String keyStore;
    private String keyStoreFormat = "PKCS12";
    private char[] keyStorePassword;
    private char[] keyManagerPassword;
    private boolean includeSystem = true;
    private boolean erasePasswords = true;

    protected void erasePasswords() {
        if (this.erasePasswords && this.keyStorePassword != null) {
            Arrays.fill(this.keyStorePassword, '\u0000');
            this.keyStorePassword = null;
        }
        if (this.erasePasswords && this.keyManagerPassword != null) {
            Arrays.fill(this.keyManagerPassword, '\u0000');
            this.keyManagerPassword = null;
        }
    }

    public String getTlsProtocol() {
        return this.tlsProtocol;
    }

    public void setTlsProtocol(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public boolean isIncludeSystem() {
        return this.includeSystem;
    }

    public void setIncludeSystem(boolean includeSystem) {
        this.includeSystem = includeSystem;
    }

    public boolean isErasePasswords() {
        return this.erasePasswords;
    }

    public void setErasePasswords(boolean erasePasswords) {
        this.erasePasswords = erasePasswords;
    }
}

