/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.thales.simulator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.hsm.Simulator;
import net.e6tech.elements.security.hsm.thales.Command;
import net.e6tech.elements.security.hsm.thales.simulator.CommandProcessor;

public class ThalesSimulator
extends Simulator {
    static Logger logger = Logger.getLogger();
    private int headerLength = 4;
    private boolean enveloped = false;

    public ThalesSimulator() {
        this.setPort(1500);
    }

    @Override
    protected void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] length = new byte[2];
        BufferedInputStream in = new BufferedInputStream(inputStream);
        Throwable throwable = null;
        try {
            try {
                BufferedOutputStream out = new BufferedOutputStream(outputStream);
                Throwable throwable2 = null;
                try {
                    try {
                        while (true) {
                            int envelopeSize = 0;
                            int envelopeOffset = 0;
                            int stx = 2;
                            if (this.enveloped) {
                                stx = in.read();
                                envelopeSize = 3;
                                envelopeOffset = 1;
                            }
                            this.read(in, length, 0);
                            short len = Command.decodeLength(length);
                            byte[] buffer = new byte[len + envelopeSize + 2];
                            this.read(in, buffer, envelopeOffset + 2);
                            if (this.enveloped) {
                                buffer[0] = (byte)stx;
                            }
                            for (int i = 0; i < 2; ++i) {
                                buffer[i + envelopeOffset] = length[i];
                            }
                            Command cmd = Command.fromBytes(buffer, this.headerLength);
                            CommandProcessor commandProcessor = CommandProcessor.forCommand(cmd);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (out != null) {
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                        } else {
                            out.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            if (in != null) {
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                } else {
                    in.close();
                }
            }
            throw throwable7;
        }
    }

    protected void read(InputStream in, byte[] buffer, int offset) throws IOException {
        int r;
        int read = offset;
        while ((read += (r = in.read(buffer, read, buffer.length - read))) < buffer.length) {
        }
    }
}

