/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.AtallaSimulator;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;
import net.e6tech.elements.security.hsm.atalla.simulator.MasterCardARQC;

class VisaCVN10ARQC
extends MasterCardARQC {
    public VisaCVN10ARQC(AtallaSimulator simulator) {
        super(simulator);
    }

    @Override
    protected String process() throws CommandException {
        boolean verified;
        String arpc;
        if (this.arc == null || this.arc.length() == 0) {
            throw new CommandException(8, (Throwable)new IllegalArgumentException("ARC is null"));
        }
        String mk = this.pan + this.cardSequence;
        int pad = 16 - mk.length();
        if (pad > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < pad; ++i) {
                builder.append("0");
            }
            mk = builder.toString() + mk;
        }
        if (mk.length() > 16) {
            mk = mk.substring(mk.length() - 16);
        }
        byte[] mkBytes = Hex.toBytes(mk);
        try {
            byte[] leftMK = this.simulator.encrypt(this.imk, mkBytes);
            byte[] rightMK = this.simulator.encrypt(this.imk, Hex.invert(mkBytes));
            this.leftSessionKey = new SecretKeySpec(AKB.normalizeKey(leftMK), "DESede");
            this.rightSessionKey = new SecretKeySpec(AKB.normalizeKey(rightMK), "DESede");
            byte[] iccMasterKeyBytes = new byte[leftMK.length + rightMK.length];
            System.arraycopy(leftMK, 0, iccMasterKeyBytes, 0, leftMK.length);
            System.arraycopy(rightMK, 0, iccMasterKeyBytes, leftMK.length, rightMK.length);
            this.sessionKey = new SecretKeySpec(AKB.normalizeKey(iccMasterKeyBytes), "DESede");
            this.sessionKeyCheckDigit = AKB.calculateCheckDigits(iccMasterKeyBytes);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(3, (Throwable)e);
        }
        this.computedARQC = this.computeARQC();
        if (!this.computedARQC.equals(this.arqc)) {
            if (this.failureCode == null || this.failureCode.length() == 0) {
                return "450##" + this.sessionKeyCheckDigit + "#" + this.imk.getCheckDigits();
            }
            arpc = this.computeARPC(this.failureCode);
            verified = false;
        } else {
            arpc = this.computeARPC(this.arc);
            verified = true;
        }
        String result = "450#" + arpc + "#" + this.sessionKeyCheckDigit + "#" + this.imk.getCheckDigits();
        if (this.failureCode != null && this.failureCode.length() > 0) {
            result = result + (verified ? "#Y" : "#N");
        }
        return result;
    }

    @Override
    protected String computeARPC(String code) throws CommandException {
        int i;
        byte[] bytes = Hex.toBytes(this.arqc);
        byte[] codeBytes = Hex.toBytes(code);
        byte[] arcBytes = new byte[bytes.length];
        System.arraycopy(codeBytes, 0, arcBytes, 0, codeBytes.length);
        for (i = codeBytes.length; i < arcBytes.length; ++i) {
            arcBytes[i] = 0;
        }
        for (i = 0; i < arcBytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] ^ arcBytes[i]);
        }
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, this.leftSessionKey);
            bytes = cipher.doFinal(bytes);
            cipher.init(2, this.rightSessionKey);
            bytes = cipher.doFinal(bytes);
            cipher.init(1, this.leftSessionKey);
            bytes = cipher.doFinal(bytes);
            return Hex.toString(cipher.doFinal(bytes));
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(6, (Throwable)e);
        }
    }
}

