/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.GeneralSecurityException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.Simulator;
import net.e6tech.elements.security.hsm.atalla.Message;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;

public class AtallaSimulator
extends Simulator {
    static String MASTER_KEY = "2ABC3DEF4567018998107645FED3CBA20123456789ABCDEF";
    static String IMK_ARQC = "1mENE000,0123 4567 89AB CDEF FEDC BA98 7654 3210";
    static String IMK_SM_MAC = "1mENE00M,ABCD ABCD EF01 EF01 10FE 10FE DCBA DCBA";
    static String IMK_SM_ENC = "1mENE00E,1234 1234 5678 5678 8765 8765 4321 4321";
    static String KPV_VISA = "1VVNE000,3333 3333 3333 3333 4444 4444 4444 4444";
    static String KPV_IBM3624 = "1V3NE000,3333 3333 3333 3333 4444 4444 4444 4444";
    static String KPE_INTERCHANGE = "1PUNE000,5555 5555 5555 5555 6666 6666 6666 6666";
    static String KPE_BANK = "1PUNE000,1111 1111 1111 1111 2222 2222 2222 2222";
    static String KCVV = "1CDNE000,0123 4567 89AB CDEF FEDC BA98 7654 3210";
    static String KEK_KPE = "1PUNE000,0123 4567 89AB CDEF FEDC BA98 7654 3210";
    static String DEC = "1nCNE000,0123456789012345";
    static Logger logger = Logger.getLogger();
    private byte[] masterKey = Hex.toBytes(MASTER_KEY);
    protected Map<String, String> keys = new LinkedHashMap<String, String>();

    public AtallaSimulator() throws GeneralSecurityException {
        Field[] fields;
        for (Field f : fields = AtallaSimulator.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().isAssignableFrom(String.class)) continue;
            f.setAccessible(true);
            try {
                String value = (String)f.get(null);
                String[] keyComponents = value.split(",");
                if (keyComponents.length != 2) continue;
                this.keys.put(f.getName(), value);
            }
            catch (IllegalAccessException e) {
                Logger.suppress((Throwable)e);
            }
        }
        this.setPort(7000);
    }

    public String getMasterKey() {
        return Hex.toString(this.masterKey);
    }

    public void setMasterKey(String mkey) {
        this.masterKey = Hex.toBytes(mkey);
    }

    byte[] masterKeyBytes() {
        return this.masterKey;
    }

    public AKB getKey(String keyType) throws GeneralSecurityException {
        String key = this.keys.get(keyType);
        if (key == null) {
            return null;
        }
        return this.asAKB(key);
    }

    public AKB asAKB(String headerAndKey) throws GeneralSecurityException {
        String[] fields = headerAndKey.split(",");
        return new AKB(fields[0].trim(), this.masterKey, Hex.toBytes(fields[1]));
    }

    public AKB asAKB(String header, byte[] key) throws GeneralSecurityException {
        return new AKB(header, this.masterKey, key);
    }

    public byte[] decryptKey(AKB akb) throws GeneralSecurityException {
        return akb.decryptKey(this.masterKey);
    }

    public byte[] decrypt(AKB akb, String encrypted) throws GeneralSecurityException {
        return this.decrypt(akb, Hex.toBytes(encrypted));
    }

    public byte[] decrypt(AKB akb, byte[] encrypted) throws GeneralSecurityException {
        byte[] key = akb.decryptKey(this.masterKey);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(AKB.normalizeKey(key), "DESede");
        cipher.init(2, secretKey);
        return cipher.doFinal(encrypted);
    }

    public byte[] encrypt(AKB akb, String clearText) throws GeneralSecurityException {
        return this.encrypt(akb, Hex.toBytes(clearText));
    }

    public byte[] encrypt(AKB akb, byte[] clearText) throws GeneralSecurityException {
        byte[] key = akb.decryptKey(this.masterKey);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(AKB.normalizeKey(key), "DESede");
        cipher.init(1, secretKey);
        return cipher.doFinal(clearText);
    }

    public AKB importKey(AKB akb, byte[] encryptedKey) throws GeneralSecurityException {
        String header = akb.getHeader().substring(0, 5) + "000";
        byte[] plainKey = this.decrypt(akb, encryptedKey);
        return this.asAKB(header, plainKey);
    }

    @Override
    protected void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
             PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                Command request = Command.createInstance(line, this);
                Message response = request.process();
                writer.println(response);
                writer.flush();
            }
            logger.info("{} client exited", (Object)this.getClass().getSimpleName());
        }
    }

    public static void main(String ... args) throws Exception {
        AtallaSimulator simulator = new AtallaSimulator();
        for (String keyType : simulator.keys.keySet()) {
            AKB akb = simulator.getKey(keyType);
            String headerAndKey = simulator.keys.get(keyType);
            String[] fields = headerAndKey.split(",");
            System.out.println("Key: " + keyType);
            System.out.println("Key 1: " + fields[1]);
            System.out.println("Check Digits: " + akb.getCheckDigits());
            System.out.println();
        }
        AKB akb = simulator.asAKB("1mENE000,9E15204313F7318A CB79B90BD986AD29");
        System.out.println("Key: 9E15204313F7318A CB79B90BD986AD29");
        System.out.println("Check Digits: " + akb.getCheckDigits());
        System.out.println();
        simulator.start();
    }
}

