/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.Password;
import net.e6tech.elements.security.RNG;
import net.e6tech.elements.security.SymmetricCipher;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class JavaKeyStore {
    public static final String JCEKS_FORMAT = "JCEKS";
    public static final String JKS_FORMAT = "JKS";
    public static final String PKCS12_FORMAT = "PKCS12";
    public static final String DEFAULT_FORMAT = "PKCS12";
    KeyStore keyStore;
    KeyManager[] keyManagers = null;
    TrustManager[] trustManagersWithSystem;
    TrustManager[] trustManagers;
    boolean includeSystem = true;

    public JavaKeyStore() throws GeneralSecurityException {
        this.keyStore = JavaKeyStore.createKeyStore("PKCS12");
    }

    public JavaKeyStore(String format) throws GeneralSecurityException {
        if (format == null) {
            format = "PKCS12";
        }
        this.keyStore = JavaKeyStore.createKeyStore(format);
    }

    public JavaKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public JavaKeyStore(String file, char[] password, String format) throws GeneralSecurityException, IOException {
        if (file != null) {
            if (format == null) {
                format = "PKCS12";
            }
            this.keyStore = KeyStore.getInstance(format);
            this.keyStore.load(new FileInputStream(file), password);
        }
    }

    public JavaKeyStore(InputStream inputStream, char[] password, String format) throws GeneralSecurityException, IOException {
        if (inputStream != null) {
            if (format == null) {
                format = "PKCS12";
            }
            this.keyStore = KeyStore.getInstance(format);
            this.keyStore.load(inputStream, password);
        }
    }

    public static SecretKey generateSecretKey(String keyType, int keySize) throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(keyType, "BC");
        keyGenerator.init(keySize, RNG.getSecureRandom());
        return keyGenerator.generateKey();
    }

    public static KeyPair generateKeyPair(String keyType, int keySize) throws GeneralSecurityException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(keyType, "BC");
        keyPairGen.initialize(keySize, RNG.getSecureRandom());
        return keyPairGen.generateKeyPair();
    }

    public static X509Certificate generateSelfSignedCertificate(String info, KeyPair pair, int years) {
        try {
            X500Principal principal = new X500Principal(info);
            Date notBefore = new Date(System.currentTimeMillis() - 86400000L);
            Date notAfter = new Date(System.currentTimeMillis() + (long)(years * 365 * 24 * 60 * 60) * 1000L);
            BigInteger serial = BigInteger.valueOf(System.currentTimeMillis());
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(principal, serial, notBefore, notAfter, principal, pair.getPublic());
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(pair.getPrivate());
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(sigGen));
            cert.checkValidity(new Date());
            cert.verify(cert.getPublicKey());
            return cert;
        }
        catch (Exception t) {
            throw new SystemException("Failed to generate self-signed certificate!", (Throwable)t);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public JavaKeyStore init(char[] password) throws GeneralSecurityException {
        if (password != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.keyStore, password);
            this.keyManagers = factory.getKeyManagers();
        }
        this.initTrustManagers();
        return this;
    }

    public boolean isIncludeSystem() {
        return this.includeSystem;
    }

    public void setIncludeSystem(boolean includeSystem) {
        this.includeSystem = includeSystem;
    }

    public JavaKeyStore includeSystem(boolean includeSystem) {
        this.setIncludeSystem(includeSystem);
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    protected TrustManager[] initTrustManagers() throws GeneralSecurityException {
        TrustManagerFactory factory;
        if (this.trustManagers == null) {
            if (this.keyStore != null) {
                factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(this.keyStore);
                this.trustManagers = factory.getTrustManagers();
            }
            if (this.trustManagers == null) {
                this.trustManagers = new TrustManager[0];
            }
        }
        if (this.includeSystem) {
            if (this.trustManagersWithSystem == null) {
                factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init((KeyStore)null);
                TrustManager[] system = factory.getTrustManagers();
                this.trustManagersWithSystem = new TrustManager[system.length + this.trustManagers.length];
                System.arraycopy(this.trustManagers, 0, this.trustManagersWithSystem, 0, this.trustManagers.length);
                System.arraycopy(system, 0, this.trustManagersWithSystem, this.trustManagers.length, system.length);
            }
            return this.trustManagersWithSystem;
        }
        return this.trustManagers;
    }

    public SSLSocketFactory createSocketFactory(String tlsProtocol) throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance(tlsProtocol);
        ctx.init(this.getKeyManagers(), this.getTrustManagers(), null);
        return ctx.getSocketFactory();
    }

    public SSLServerSocketFactory createServerSocketFactory(String tlsProtocol) throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance(tlsProtocol);
        ctx.init(this.getKeyManagers(), this.getTrustManagers(), null);
        return ctx.getServerSocketFactory();
    }

    public Key getKey(String alias, char[] password) throws GeneralSecurityException {
        return this.keyStore.getKey(alias, password);
    }

    public void setKey(String alias, SecretKey secretKey, char[] password) throws GeneralSecurityException {
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(password);
        KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(secretKey);
        this.keyStore.setEntry(alias, secretKeyEntry, protectionParameter);
    }

    public X509Certificate getCertificate(String alias) throws GeneralSecurityException {
        return (X509Certificate)this.keyStore.getCertificate(alias);
    }

    public void setCertificate(String name, X509Certificate certificate) throws GeneralSecurityException {
        this.keyStore.setCertificateEntry(name, certificate);
    }

    public void remove(String name) throws GeneralSecurityException {
        this.keyStore.deleteEntry(name);
    }

    public boolean isEntry(String name) throws GeneralSecurityException {
        return this.keyStore.isCertificateEntry(name) || this.keyStore.isKeyEntry(name);
    }

    public static KeyStore createKeyStore(String format) throws GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(format);
        try {
            keyStore.load(null, null);
        }
        catch (IOException e) {
            Logger.suppress((Throwable)e);
        }
        return keyStore;
    }

    public void createSelfSignedCertificate(String alias, String info, char[] password, int years) throws GeneralSecurityException {
        KeyPair pair = JavaKeyStore.generateKeyPair("RSA", 2048);
        X509Certificate cert = JavaKeyStore.generateSelfSignedCertificate(info, pair, years);
        this.keyStore.setKeyEntry(alias, pair.getPrivate(), password, new Certificate[]{cert});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File keyStoreFile, char[] password) throws IOException, GeneralSecurityException {
        try (FileOutputStream fos = new FileOutputStream(keyStoreFile);){
            this.keyStore.store(fos, password);
        }
    }

    public void save(OutputStream output, char[] password) throws GeneralSecurityException, IOException {
        try {
            this.keyStore.store(output, password);
        }
        finally {
            output.close();
        }
    }

    public static void main(String ... args) throws Exception {
        char[] password = "password".toCharArray();
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(password);
        KeyPair pair = JavaKeyStore.generateKeyPair("RSA", 2048);
        X509Certificate cert = JavaKeyStore.generateSelfSignedCertificate("CN=www.nowhere.com,OU=IT,O=No Where,L=Austin,ST=Texas,C=US", pair, 10);
        KeyStore keyStore = JavaKeyStore.createKeyStore("PKCS12");
        keyStore.setKeyEntry("alias", pair.getPrivate(), password, new Certificate[]{cert});
        Key privKey = keyStore.getKey("alias", password);
        String hashed = Password.getSaltedHash("password".toCharArray());
        X509Certificate cert2 = JavaKeyStore.generateSelfSignedCertificate("CN=futeh kao,UID=" + hashed, pair, 2);
        keyStore.setCertificateEntry("cert2", cert2);
        cert2 = (X509Certificate)keyStore.getCertificate("cert2");
        String dn = cert2.getIssuerDN().getName();
        String[] names = dn.split(",");
        Properties props = new Properties();
        for (String n : names) {
            String[] keyvalue = n.trim().split("=");
            props.put(keyvalue[0], keyvalue[1]);
        }
        hashed = props.getProperty("UID");
        boolean check = Password.check("password".toCharArray(), hashed);
        JavaKeyStore javaKeyStore = new JavaKeyStore(keyStore);
        javaKeyStore.init(password);
        KeyManager[] keyManagers = javaKeyStore.getKeyManagers();
        TrustManager[] trustManagers = javaKeyStore.getTrustManagers();
        SecretKey secretKey = JavaKeyStore.generateSecretKey("AES", 256);
        SecretKey key2 = JavaKeyStore.generateSecretKey("AES", 256);
        SymmetricCipher encryption = SymmetricCipher.getInstance("AES");
        byte[] bytes = encryption.encryptBytes(secretKey, key2.getEncoded(), null);
        SecretKeySpec encryptedKey = new SecretKeySpec(bytes, "AES");
        javaKeyStore.setKey("encryptedKey", encryptedKey, password);
        SecretKey encryptedKey2 = (SecretKey)javaKeyStore.getKey("encryptedKey", password);
        bytes = encryption.decryptBytes(secretKey, encryptedKey2.getEncoded(), null);
        SecretKeySpec decryptedKey = new SecretKeySpec(bytes, "AES");
        System.out.println(((Object)decryptedKey).equals(key2));
        SecretKeySpec junk = new SecretKeySpec(new byte[2567], "JUNK");
        javaKeyStore.setKey("junk", junk, password);
        junk = (SecretKeySpec)javaKeyStore.getKey("junk", password);
    }

    static {
        SymmetricCipher.initialize();
    }
}

