/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.SSLServerSocketConfig;

public abstract class Simulator {
    static Logger logger = Logger.getLogger();
    private ServerSocket serverSocket;
    private int port = 7000;
    private boolean stopped = true;
    private ExecutorService threadPool;
    private SSLServerSocketConfig sslConfig = new SSLServerSocketConfig();

    public boolean isStopped() {
        return this.stopped;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public SSLServerSocketConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SSLServerSocketConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void start() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(null, runnable, this.getClass().getSimpleName());
                thread.setName(this.getClass().getSimpleName() + "-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        Thread thread = new Thread(this::startServer);
        thread.start();
    }

    protected void startServer() {
        try {
            this.serverSocket = this.sslConfig.createServerSocket(this.port);
            this.stopped = false;
            while (!this.stopped) {
                Socket socket = this.serverSocket.accept();
                this.threadPool.execute(() -> {
                    try {
                        this.process(socket.getInputStream(), socket.getOutputStream());
                        logger.info("{} client exited", (Object)this.getClass().getSimpleName());
                    }
                    catch (Exception e) {
                        logger.trace(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
        catch (Exception th) {
            throw logger.systemException((Throwable)th);
        }
    }

    public void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Logger.suppress((Throwable)e);
            }
            finally {
                this.stopped = true;
            }
        }
    }

    protected abstract void process(InputStream var1, OutputStream var2) throws IOException;
}

