/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.SSLBaseConfig;

public class SSLSocketConfig
extends SSLBaseConfig {
    private boolean skipCertCheck = false;
    private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];
    private SSLSocketFactory sslSocketFactory;

    public SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        if (this.sslSocketFactory != null) {
            return this.sslSocketFactory;
        }
        KeyManager[] keyManagers = null;
        if (this.getKeyStore() != null) {
            JavaKeyStore javaKeyStore = new JavaKeyStore(this.getKeyStore(), this.getKeyStorePassword(), this.getKeyStoreFormat()).includeSystem(this.isIncludeSystem()).init(this.getKeyManagerPassword());
            trustManagers = javaKeyStore.getTrustManagers();
            keyManagers = javaKeyStore.getKeyManagers();
        } else {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            trustManagers = trustManagerFactory.getTrustManagers();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(null, null);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        if (this.skipCertCheck) {
            trustManagers = new TrustManager[]{new AcceptAllTrustManager()};
        }
        this.erasePasswords();
        SSLContext ctx = SSLContext.getInstance(this.getTlsProtocol());
        ctx.init(keyManagers, trustManagers, null);
        this.sslSocketFactory = ctx.getSocketFactory();
        return this.sslSocketFactory;
    }

    public boolean isSkipCertCheck() {
        return this.skipCertCheck;
    }

    public void setSkipCertCheck(boolean skipCertCheck) {
        this.skipCertCheck = skipCertCheck;
    }

    public class AcceptAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_CERTIFICATES;
        }
    }
}

