/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

public class PasswordValidator {
    public static final String SPECIAL_CHARACTERS = "!@#$%^&*()~`-=_+[]{}|:\";',./<>?";
    private int minPasswordLength;
    private int maxPasswordLength;
    private int minNumberOfGroups;
    private static final PasswordValidator DEFAULT_VALIDATOR = new PasswordValidator(8, 32, 3);

    public PasswordValidator() {
    }

    public PasswordValidator(int minPasswordLength, int maxPasswordLength, int minNumberOfGroups) {
        this.minPasswordLength = minPasswordLength;
        this.maxPasswordLength = maxPasswordLength;
        this.minNumberOfGroups = minNumberOfGroups;
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public int getMaxPasswordLength() {
        return this.maxPasswordLength;
    }

    public void setMaxPasswordLength(int maxPasswordLength) {
        this.maxPasswordLength = maxPasswordLength;
    }

    public int getMinNumberOfGroups() {
        return this.minNumberOfGroups;
    }

    public void setMinNumberOfGroups(int minNumberOfGroups) {
        this.minNumberOfGroups = minNumberOfGroups;
    }

    public boolean check(String pwd) {
        char[] aC;
        String password = pwd;
        if (password == null || password.length() == 0) {
            return false;
        }
        password = password.trim();
        int len = password.length();
        if (this.minPasswordLength > 0 && len < this.minPasswordLength) {
            return false;
        }
        if (this.maxPasswordLength > 0 && len > this.maxPasswordLength) {
            return false;
        }
        int nLowerCase = 0;
        int nUpperCase = 0;
        int nSpecial = 0;
        int nDigits = 0;
        for (char c : aC = password.toCharArray()) {
            if (Character.isUpperCase(c)) {
                ++nUpperCase;
                continue;
            }
            if (Character.isLowerCase(c)) {
                ++nLowerCase;
                continue;
            }
            if (Character.isDigit(c)) {
                ++nDigits;
                continue;
            }
            if (SPECIAL_CHARACTERS.indexOf(String.valueOf(c)) >= 0) {
                ++nSpecial;
                continue;
            }
            return false;
        }
        int count = 0;
        if (nUpperCase > 0) {
            ++count;
        }
        if (nLowerCase > 0) {
            ++count;
        }
        if (nSpecial > 0) {
            ++count;
        }
        if (nDigits > 0) {
            ++count;
        }
        return count >= this.minNumberOfGroups;
    }

    public static boolean validate(String password) {
        return DEFAULT_VALIDATOR.check(password);
    }
}

