/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Retry;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Secret;
import net.e6tech.elements.security.vault.Vault;
import net.e6tech.elements.security.vault.VaultFormat;
import net.e6tech.elements.security.vault.VaultImpl;
import net.e6tech.elements.security.vault.VaultStore;

public class DBVaultStore
implements VaultStore {
    private String tableName = "h3_vault";
    private long latestRefreshPeriod = 600000L;
    private Map<String, DBVault> vaults = new HashMap<String, DBVault>();
    private DataSource dataSource;
    @Inject(optional=true)
    private Retry retry;

    public DBVaultStore() {
    }

    public DBVaultStore(DataSource ds) {
        this.dataSource = ds;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long getLatestRefreshPeriod() {
        return this.latestRefreshPeriod;
    }

    public void setLatestRefreshPeriod(long latestRefreshPeriod) {
        this.latestRefreshPeriod = latestRefreshPeriod;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public VaultStore manage(String ... vaultNames) {
        if (vaultNames == null) {
            return this;
        }
        for (String vaultName : vaultNames) {
            this.vaults.computeIfAbsent(vaultName, key -> new DBVault(vaultName));
        }
        return this;
    }

    @Override
    public VaultStore unmanage(String vaultName) {
        this.vaults.remove(vaultName);
        return this;
    }

    protected Retry getRetry() {
        if (this.retry == null) {
            this.retry = new Retry(){

                public boolean shouldRetry(Throwable th) {
                    return false;
                }
            };
        }
        return this.retry;
    }

    @Override
    public Vault getVault(String vaultName) {
        return this.vaults.get(vaultName);
    }

    @Override
    public void backup(String version) throws IOException {
        this.copy(true, version);
    }

    @Override
    public void restore(String version) throws IOException {
        this.copy(false, version);
    }

    private void commitOrAbort(Connection connection, Exception exception) throws Exception {
        if (connection != null) {
            if (exception == null) {
                connection.commit();
            } else {
                connection.rollback();
            }
            connection.close();
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(boolean backup, String version) throws IOException {
        try {
            this.getRetry().retry(() -> {
                Connection connection = null;
                SQLException exception = null;
                try {
                    connection = this.dataSource.getConnection();
                    for (Map.Entry<String, DBVault> entry : this.vaults.entrySet()) {
                        if (backup) {
                            entry.getValue().backup(connection, version);
                            continue;
                        }
                        entry.getValue().restore(connection, version);
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                finally {
                    this.commitOrAbort(connection, exception);
                }
                return null;
            });
        }
        catch (Throwable th) {
            throw new IOException(th);
        }
    }

    @Override
    public void save() throws IOException {
        if (this.dataSource == null) {
            throw new IOException("null data source");
        }
        try {
            this.getRetry().retry(() -> {
                SQLException exception = null;
                Connection connection = null;
                try {
                    connection = this.dataSource.getConnection();
                    for (Map.Entry<String, DBVault> entry : this.vaults.entrySet()) {
                        entry.getValue().save(connection);
                    }
                }
                catch (SQLException ex) {
                    exception = ex;
                }
                finally {
                    this.commitOrAbort(connection, exception);
                }
                return null;
            });
        }
        catch (Throwable th) {
            throw new IOException(th);
        }
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)this.dataSource);
            closeable.close();
        }
    }

    @Override
    public String writeString() throws IOException {
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            LinkedHashMap<String, VaultImpl> result = new LinkedHashMap<String, VaultImpl>();
            connection = this.dataSource.getConnection();
            pstmt = connection.prepareStatement("select v.secret from " + this.tableName + " v where v.name = ? ");
            for (DBVault v : this.vaults.values()) {
                VaultImpl impl = new VaultImpl();
                pstmt.setString(1, v.getName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String encoded = rs.getString(1);
                    try {
                        Secret secret = (Secret)Constants.mapper.readValue(encoded, Secret.class);
                        impl.addSecret(secret);
                    }
                    catch (IOException e) {
                        throw new SystemException((Throwable)e);
                    }
                }
                result.put(v.getName(), impl);
                rs.close();
            }
            String string = Constants.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VaultFormat(result));
            return string;
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        catch (SQLException e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.suppress((Throwable)ex);
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException ex) {
                    Logger.suppress((Throwable)ex);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    Logger.suppress((Throwable)ex);
                }
            }
        }
    }

    private class SecretEntry {
        long timestamp = System.currentTimeMillis();
        Secret secret;

        SecretEntry(Secret secret) {
            this.secret = secret;
        }
    }

    private class DBVault
    implements Vault {
        List<Secret> addedSecrets = Collections.synchronizedList(new ArrayList());
        String name;
        Map<String, SortedMap<String, SecretEntry>> cache = new HashMap<String, SortedMap<String, SecretEntry>>();
        Map<String, SecretEntry> latestSecrets = new ConcurrentHashMap<String, SecretEntry>();
        volatile long lastTrim = System.currentTimeMillis();

        DBVault(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Secret getSecret(String alias, String version) {
            Secret secret;
            if (version != null) {
                Map<String, SortedMap<String, SecretEntry>> map = this.cache;
                synchronized (map) {
                    SecretEntry l;
                    SortedMap<String, SecretEntry> versions = this.cache.get(alias);
                    if (versions != null && (l = (SecretEntry)versions.get(version)) != null && l.timestamp > System.currentTimeMillis() - DBVaultStore.this.latestRefreshPeriod) {
                        this.trimCache();
                        return l.secret;
                    }
                }
            } else {
                SecretEntry l = this.latestSecrets.get(alias);
                if (l != null && l.timestamp > System.currentTimeMillis() - DBVaultStore.this.latestRefreshPeriod) {
                    this.trimCache();
                    return l.secret;
                }
            }
            try {
                secret = (Secret)DBVaultStore.this.getRetry().retry(() -> {
                    Secret ret;
                    Connection connection = null;
                    Statement select = null;
                    ResultSet rs = null;
                    try {
                        connection = DBVaultStore.this.dataSource.getConnection();
                        if (version != null) {
                            select = connection.prepareStatement("select v.secret from " + DBVaultStore.this.tableName + " v where v.name = ? and v.alias = ? and v.version = ? ");
                            select.setLong(3, Long.parseLong(version));
                        } else {
                            select = connection.prepareStatement("select v.secret from " + DBVaultStore.this.tableName + " v where v.name = ? and v.alias = ? and v.version = (select max(v1.version) from " + DBVaultStore.this.tableName + " v1 where v1.name = ? and v1.alias = ?)");
                            select.setString(3, this.name);
                            select.setString(4, alias);
                        }
                        select.setString(1, this.name);
                        select.setString(2, alias);
                        rs = select.executeQuery();
                        String str = null;
                        if (rs.next()) {
                            str = rs.getString(1);
                        }
                        if (str == null) {
                            Secret secret = null;
                            return secret;
                        }
                        try {
                            ret = (Secret)Constants.mapper.readValue(str, Secret.class);
                        }
                        catch (IOException e) {
                            throw new SystemException((Throwable)e);
                        }
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (select != null) {
                            try {
                                select.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.commit();
                                connection.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                    }
                    return ret;
                });
            }
            catch (Throwable th) {
                throw new SystemException(th);
            }
            this.updateCache(secret);
            if (version == null) {
                this.updateLatest(secret);
            }
            this.trimCache();
            return secret;
        }

        @Override
        public void addSecret(Secret secret) {
            this.addedSecrets.add(secret);
            this.updateCache(secret);
            this.updateLatest(secret);
            this.trimCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trimCache() {
            if (this.lastTrim < System.currentTimeMillis() - DBVaultStore.this.latestRefreshPeriod) {
                Map<String, SortedMap<String, SecretEntry>> map = this.cache;
                synchronized (map) {
                    for (SortedMap<String, SecretEntry> versions : this.cache.values()) {
                        versions.entrySet().removeIf(e -> ((SecretEntry)e.getValue()).timestamp < System.currentTimeMillis() - DBVaultStore.this.latestRefreshPeriod);
                    }
                    this.cache.entrySet().removeIf(e -> ((SortedMap)e.getValue()).isEmpty());
                }
                this.latestSecrets.entrySet().removeIf(e -> ((SecretEntry)e.getValue()).timestamp < System.currentTimeMillis() - DBVaultStore.this.latestRefreshPeriod);
                this.lastTrim = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSecret(String alias, String version) {
            if (DBVaultStore.this.dataSource == null) {
                throw new SystemException("null data source");
            }
            try {
                DBVaultStore.this.getRetry().retry(() -> {
                    SQLException exception = null;
                    Connection connection = null;
                    Statement removeVersion = null;
                    Statement removeAll = null;
                    try {
                        connection = DBVaultStore.this.dataSource.getConnection();
                        if (version != null) {
                            removeVersion = connection.prepareStatement("delete from " + DBVaultStore.this.tableName + " where name = ? and alias = ? and version = ? ");
                            removeVersion.setString(1, this.name);
                            removeVersion.setString(2, alias);
                            removeVersion.setLong(3, Long.parseLong(version));
                            removeAll.executeUpdate();
                        } else {
                            removeAll = connection.prepareStatement("delete from " + DBVaultStore.this.tableName + " where name = ? and alias = ?");
                            removeAll.setString(1, this.name);
                            removeAll.setString(2, alias);
                            removeAll.executeUpdate();
                        }
                        connection.commit();
                    }
                    catch (SQLException ex) {
                        exception = ex;
                    }
                    finally {
                        if (removeVersion != null) {
                            try {
                                removeVersion.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (removeAll != null) {
                            try {
                                removeAll.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        DBVaultStore.this.commitOrAbort(connection, exception);
                    }
                    return null;
                });
            }
            catch (Throwable th) {
                throw new SystemException(th);
            }
            Iterator<Secret> secrets = this.addedSecrets.iterator();
            while (secrets.hasNext()) {
                Secret secret = secrets.next();
                if (!alias.equals(secret.alias()) || version != null && !version.equals(secret.version())) continue;
                secrets.remove();
            }
            Map<String, Object> map = this.cache;
            synchronized (map) {
                SortedMap<String, SecretEntry> versions = this.cache.get(alias);
                if (versions != null) {
                    if (version == null) {
                        this.cache.remove(alias);
                    } else {
                        versions.remove(version);
                    }
                }
            }
            map = this.latestSecrets;
            synchronized (map) {
                SecretEntry latest = this.latestSecrets.get(alias);
                if (latest != null && (version == null || version.equals(latest.secret.version()))) {
                    this.latestSecrets.remove(alias);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(Secret secret) {
            if (secret == null) {
                return;
            }
            Map<String, SortedMap<String, SecretEntry>> map = this.cache;
            synchronized (map) {
                SortedMap<String, SecretEntry> versions = this.cache.get(secret.alias());
                if (versions == null) {
                    versions = new TreeMap<String, SecretEntry>();
                    this.cache.put(secret.alias(), versions);
                }
                versions.put(secret.version(), new SecretEntry(secret));
            }
        }

        private void updateLatest(Secret secret) {
            if (secret == null) {
                return;
            }
            this.latestSecrets.put(secret.alias(), new SecretEntry(secret));
        }

        @Override
        public Set<String> aliases() {
            if (DBVaultStore.this.dataSource == null) {
                throw new SystemException("null data source");
            }
            HashSet<String> aliases = new HashSet<String>();
            for (Secret secret2 : this.addedSecrets) {
                aliases.add(secret2.alias());
            }
            try {
                DBVaultStore.this.getRetry().retry(() -> {
                    Connection connection = null;
                    Statement pstmt = null;
                    ResultSet rs = null;
                    try {
                        connection = DBVaultStore.this.dataSource.getConnection();
                        pstmt = connection.prepareStatement("select distinct v.alias from " + DBVaultStore.this.tableName + " v where v.name = ? ");
                        pstmt.setString(1, this.name);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            String alias = rs.getString(1);
                            aliases.add(alias);
                        }
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                    }
                    return null;
                });
            }
            catch (Throwable th) {
                throw new SystemException(th);
            }
            this.addedSecrets.forEach(secret -> aliases.add(secret.alias()));
            return aliases;
        }

        @Override
        public Set<Long> versions(String alias) {
            Set versions;
            if (DBVaultStore.this.dataSource == null) {
                throw new SystemException("null data source");
            }
            try {
                versions = (Set)DBVaultStore.this.getRetry().retry(() -> {
                    Connection connection = null;
                    Statement pstmt = null;
                    ResultSet rs = null;
                    LinkedHashSet<Long> vers = new LinkedHashSet<Long>();
                    try {
                        connection = DBVaultStore.this.dataSource.getConnection();
                        pstmt = connection.prepareStatement("select v.version from " + DBVaultStore.this.tableName + " v where v.name = ? and v.alias = ? ");
                        pstmt.setString(1, this.name);
                        pstmt.setString(2, alias);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Long version = rs.getLong(1);
                            vers.add(version);
                        }
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException ex) {
                                Logger.suppress((Throwable)ex);
                            }
                        }
                    }
                    return vers;
                });
            }
            catch (Throwable th) {
                throw new SystemException(th);
            }
            this.addedSecrets.forEach(secret -> {
                if (secret.alias().equals(alias)) {
                    versions.add(Long.parseLong(secret.version()));
                }
            });
            return versions;
        }

        @Override
        public int size() {
            return this.aliases().size();
        }

        public void backup(Connection connection, String version) {
            this.copy(connection, this.name, this.name + "." + version);
        }

        public void restore(Connection connection, String version) {
            this.copy(connection, this.name + "." + version, this.name);
            this.latestSecrets.clear();
            this.cache.clear();
        }

        public void copy(Connection connection, String from, String to) {
            Statement select = null;
            Statement remove = null;
            Statement insert = null;
            ResultSet rs = null;
            try {
                remove = connection.prepareStatement("delete from " + DBVaultStore.this.tableName + " where name = ? ");
                remove.setString(1, to);
                remove.executeUpdate();
                insert = connection.prepareStatement("insert into " + DBVaultStore.this.tableName + "(name, alias, version, secret) values(?,?,?,?)");
                select = connection.prepareStatement("select v.name, v.alias, v.version, v.secret from " + DBVaultStore.this.tableName + " v where v.name = ? ");
                select.setString(1, from);
                rs = select.executeQuery();
                while (rs.next()) {
                    String alias = rs.getString(2);
                    Long ver = rs.getLong(3);
                    String secret = rs.getString(4);
                    insert.setString(1, to);
                    insert.setString(2, alias);
                    insert.setLong(3, ver);
                    insert.setString(4, secret);
                    insert.executeUpdate();
                    insert.clearParameters();
                }
            }
            catch (SQLException ex) {
                throw new SystemException((Throwable)ex);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                if (select != null) {
                    try {
                        select.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                if (remove != null) {
                    try {
                        remove.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                if (insert != null) {
                    try {
                        insert.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
            }
        }

        public void save(Connection connection) {
            Statement count = null;
            Statement update = null;
            Statement insert = null;
            try {
                count = connection.prepareStatement("select count(*) from " + DBVaultStore.this.tableName + " v where v.name = ? and v.alias = ? and v.version = ? ");
                update = connection.prepareStatement("update " + DBVaultStore.this.tableName + " set secret = ? where name = ? and alias = ? and version = ? ");
                insert = connection.prepareStatement("insert into " + DBVaultStore.this.tableName + "(name, alias, version, secret) values(?,?,?,?)");
                for (Secret secret : this.addedSecrets) {
                    count.setString(1, this.getName());
                    count.setString(2, secret.alias());
                    count.setLong(3, Long.parseLong(secret.version()));
                    ResultSet rs = count.executeQuery();
                    Throwable throwable = null;
                    try {
                        int c = 0;
                        if (rs.next()) {
                            c = rs.getInt(1);
                        }
                        String encoded = null;
                        try {
                            encoded = Constants.mapper.writeValueAsString((Object)secret);
                        }
                        catch (JsonProcessingException e) {
                            throw new SystemException((Throwable)e);
                        }
                        if (c == 0) {
                            insert.setString(1, this.name);
                            insert.setString(2, secret.alias());
                            insert.setLong(3, Long.parseLong(secret.version()));
                            insert.setString(4, encoded);
                            insert.executeUpdate();
                            insert.clearParameters();
                            continue;
                        }
                        update.setString(1, encoded);
                        update.setString(2, this.name);
                        update.setString(3, secret.alias());
                        update.setLong(4, Long.parseLong(secret.version()));
                        update.executeUpdate();
                        update.clearParameters();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                this.addedSecrets.clear();
            }
            catch (SQLException ex) {
                throw new SystemException((Throwable)ex);
            }
            finally {
                if (count != null) {
                    try {
                        count.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                if (update != null) {
                    try {
                        update.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
                if (insert != null) {
                    try {
                        insert.close();
                    }
                    catch (SQLException ex) {
                        Logger.suppress((Throwable)ex);
                    }
                }
            }
        }
    }
}

