/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.thales.simulator;

import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.hsm.thales.Command;
import net.e6tech.elements.security.hsm.thales.Echo;
import net.e6tech.elements.security.hsm.thales.GenerateCVV;

public class CommandProcessor<T extends Command> {
    private static Map<Class<? extends Command>, Class<? extends CommandProcessor>> processors = new HashMap<Class<? extends Command>, Class<? extends CommandProcessor>>();
    private T command;

    public static CommandProcessor forCommand(Command command) {
        Class<? extends CommandProcessor> cls = processors.get(command.getClass());
        try {
            CommandProcessor processor = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            processor.setCommand(command);
            return processor;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public T getCommand() {
        return this.command;
    }

    public void setCommand(T command) {
        this.command = command;
    }

    static {
        processors.put(Echo.class, CommandProcessor.class);
        processors.put(GenerateCVV.class, CommandProcessor.class);
    }
}

