/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.RNG;

public class Hash {
    private static final int ITERATIONS = 20000;

    public static String pbkdf2_256(String text, byte[] salt) throws GeneralSecurityException {
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        SecretKey key = f.generateSecret(new PBEKeySpec(text.toCharArray(), salt, 20000, 256));
        return Hex.toString(key.getEncoded());
    }

    public static String pbkdf2_512(String text, byte[] salt) throws GeneralSecurityException {
        SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        SecretKey key = f.generateSecret(new PBEKeySpec(text.toCharArray(), salt, 20000, 512));
        return Hex.toString(key.getEncoded());
    }

    public static String sha256(String text) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        return Hash.digest(sha256, text);
    }

    public static String sha512(String text) throws NoSuchAlgorithmException {
        MessageDigest sha512 = MessageDigest.getInstance("SHA-512");
        return Hash.digest(sha512, text);
    }

    public static String digest(MessageDigest md, String text) {
        md.update(text.getBytes(StandardCharsets.UTF_8));
        byte[] byteData = md.digest();
        return Hex.toString(byteData);
    }

    public static void main(String ... args) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 50; ++i) {
            builder.append((char)i);
        }
        String str = "";
        byte[] salt = RNG.getSecureRandom().generateSeed(32);
        long start = System.currentTimeMillis();
        str = Hash.pbkdf2_256(builder.toString(), salt);
        System.out.println("time=" + (System.currentTimeMillis() - start) + "ms");
        System.out.println("length=" + str.length() + " " + str);
        start = System.currentTimeMillis();
        str = Hash.pbkdf2_512(builder.toString(), salt);
        System.out.println("time=" + (System.currentTimeMillis() - start) + "ms");
        System.out.println("length=" + str.length() + " " + str);
        start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            str = Hash.sha256(builder.toString());
        }
        System.out.println("sha256 time=" + (System.currentTimeMillis() - start) + "ms");
        System.out.println("length=" + str.length() + " " + str);
    }
}

