/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.AnsiPinBlock;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;

public class TranslatePINBlock
extends Command {
    @Override
    protected String doProcess() throws CommandException {
        if (!"1".equals(this.getField(2))) {
            throw new CommandException(2, (Throwable)new IllegalArgumentException("only ANSI pin block is supported"));
        }
        if (!"1".equals(this.getField(4))) {
            throw new CommandException(4, (Throwable)new IllegalArgumentException("only ANSI pin block is supported"));
        }
        AnsiPinBlock pinBlock = this.getPinBlock(5, 7, 8);
        AnsiPinBlock outgoing = new AnsiPinBlock(this.getField(9), pinBlock.getPIN());
        AKB kpeIn = new AKB(this.getField(5));
        AKB kpeOut = new AKB(this.getField(6));
        TranslatePINBlock.run(5, () -> this.simulator.decryptKey(kpeIn));
        TranslatePINBlock.run(6, () -> this.simulator.decryptKey(kpeOut));
        byte[] encrypted = TranslatePINBlock.run(6, () -> this.simulator.encrypt(new AKB(this.getField(6)), outgoing.getEncoding()));
        return "435#" + Hex.toString(encrypted) + "#Y#" + kpeIn.getCheckDigits() + "#" + kpeOut.getCheckDigits() + "##";
    }
}

