/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.AtallaSimulator;
import net.e6tech.elements.security.hsm.atalla.simulator.CommandException;

class MasterCardARQC {
    private static final String ALGORITHM = "DESede";
    private String pan;
    private String cardSequence = "00";
    private String diversification;
    private AtallaSimulator simulator;
    private AKB imk;
    private SecretKey iccMasterKey;
    private SecretKey leftSessionKey;
    private SecretKey rightSessionKey;
    private SecretKey sessionKey;
    private String sessionKeyCheckDigit;
    private String arqc;
    private String arc;
    private String failureCode;
    private String dataBlock;
    private int derivationType = 0;
    private String computedARQC;

    MasterCardARQC(AtallaSimulator simulator) {
        this.simulator = simulator;
    }

    MasterCardARQC derivationType(int derivationType) {
        this.derivationType = derivationType;
        return this;
    }

    MasterCardARQC pan(String pan) {
        this.pan = pan;
        return this;
    }

    MasterCardARQC cardSequence(String cardSequence) {
        this.cardSequence = cardSequence;
        if (cardSequence.length() == 0) {
            this.cardSequence = "00";
        }
        return this;
    }

    MasterCardARQC diversification(String diversification) {
        this.diversification = diversification;
        return this;
    }

    MasterCardARQC imk(AKB imk) {
        this.imk = imk;
        return this;
    }

    MasterCardARQC arqc(String arqc) {
        this.arqc = arqc;
        return this;
    }

    MasterCardARQC dataBlock(String dataBlock) {
        this.dataBlock = dataBlock;
        return this;
    }

    MasterCardARQC arc(String arc) {
        this.arc = arc;
        return this;
    }

    MasterCardARQC failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    public String getComputedARQC() {
        return this.computedARQC;
    }

    protected String process() throws CommandException {
        boolean verified;
        String arpc;
        if (this.arc == null || this.arc.length() == 0) {
            throw new CommandException(8, (Throwable)new IllegalArgumentException("ARC is null"));
        }
        String mk = this.pan + this.cardSequence;
        int pad = 16 - mk.length();
        if (pad > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < pad; ++i) {
                builder.append("0");
            }
            mk = builder.toString() + mk;
        }
        if (mk.length() > 16) {
            mk = mk.substring(mk.length() - 16);
        }
        byte[] mkBytes = Hex.toBytes(mk);
        try {
            byte[] leftMK = this.simulator.encrypt(this.imk, mkBytes);
            byte[] rightMK = this.simulator.encrypt(this.imk, Hex.invert(mkBytes));
            byte[] iccMasterKeyBytes = new byte[leftMK.length + rightMK.length];
            System.arraycopy(leftMK, 0, iccMasterKeyBytes, 0, leftMK.length);
            System.arraycopy(rightMK, 0, iccMasterKeyBytes, leftMK.length, rightMK.length);
            this.iccMasterKey = new SecretKeySpec(AKB.normalizeKey(iccMasterKeyBytes), ALGORITHM);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(3, (Throwable)e);
        }
        this.deriveSessionKey();
        this.computedARQC = this.computeARQC();
        if (!this.computedARQC.equals(this.arqc)) {
            if (this.failureCode == null || this.failureCode.length() == 0) {
                return "450##" + this.sessionKeyCheckDigit + "#" + this.imk.getCheckDigits();
            }
            arpc = this.computeARPC(this.failureCode);
            verified = false;
        } else {
            arpc = this.computeARPC(this.arc);
            verified = true;
        }
        String result = "450#" + arpc + "#" + this.sessionKeyCheckDigit + "#" + this.imk.getCheckDigits();
        if (this.failureCode != null && this.failureCode.length() > 0) {
            result = result + (verified ? "#Y" : "#N");
        }
        return result;
    }

    private void deriveSessionKey() throws CommandException {
        byte[] diverse = Hex.toBytes(this.diversification);
        byte[] leftDiverse = Arrays.copyOf(diverse, diverse.length);
        leftDiverse[2] = -16;
        byte[] rightDiverse = Arrays.copyOf(diverse, diverse.length);
        rightDiverse[2] = 15;
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, this.iccMasterKey);
            byte[] leftSK = cipher.doFinal(leftDiverse);
            cipher.init(1, this.iccMasterKey);
            byte[] rightSK = cipher.doFinal(rightDiverse);
            this.leftSessionKey = new SecretKeySpec(AKB.normalizeKey(leftSK), ALGORITHM);
            this.rightSessionKey = new SecretKeySpec(AKB.normalizeKey(rightSK), ALGORITHM);
            byte[] sessionKeyBytes = new byte[leftSK.length + rightSK.length];
            System.arraycopy(leftSK, 0, sessionKeyBytes, 0, leftSK.length);
            System.arraycopy(rightSK, 0, sessionKeyBytes, leftSK.length, rightSK.length);
            this.sessionKey = new SecretKeySpec(AKB.normalizeKey(sessionKeyBytes), ALGORITHM);
            this.sessionKeyCheckDigit = AKB.calculateCheckDigits(sessionKeyBytes);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(5, (Throwable)e);
        }
    }

    private String computeARQC() throws CommandException {
        byte[] bytes = Hex.toBytes(this.dataBlock);
        if (bytes.length % 8 != 0 || bytes.length == 0) {
            throw new CommandException(7, (Throwable)new IllegalArgumentException("data block is not multiple of 8 bytes"));
        }
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, this.leftSessionKey);
            byte[] input = new byte[8];
            System.arraycopy(bytes, 0, input, 0, 8);
            for (int i = 1; i < bytes.length / 8; ++i) {
                input = cipher.doFinal(input);
                for (int j = 0; j < 8; ++j) {
                    input[j] = (byte)(input[j] ^ bytes[i * 8 + j]);
                }
            }
            input = cipher.doFinal(input);
            cipher.init(2, this.rightSessionKey);
            input = cipher.doFinal(input);
            cipher.init(1, this.leftSessionKey);
            input = cipher.doFinal(input);
            return Hex.toString(input);
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(7, (Throwable)e);
        }
    }

    private String computeARPC(String code) throws CommandException {
        int i;
        byte[] bytes = Hex.toBytes(this.arqc);
        byte[] codeBytes = Hex.toBytes(code);
        byte[] arcBytes = new byte[bytes.length];
        System.arraycopy(codeBytes, 0, arcBytes, 0, codeBytes.length);
        for (i = codeBytes.length; i < arcBytes.length; ++i) {
            arcBytes[i] = 0;
        }
        for (i = 0; i < arcBytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] ^ arcBytes[i]);
        }
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            if (this.derivationType == 0) {
                cipher.init(1, this.iccMasterKey);
            } else if (this.derivationType == 2) {
                cipher.init(1, this.sessionKey);
            } else {
                throw new CommandException(1, (Throwable)new IllegalArgumentException("Invalid derivation type"));
            }
            return Hex.toString(cipher.doFinal(bytes));
        }
        catch (GeneralSecurityException e) {
            throw new CommandException(6, (Throwable)e);
        }
    }

    public static void main(String ... args) throws Exception {
        AtallaSimulator simulator = new AtallaSimulator();
        MasterCardARQC mc = new MasterCardARQC(simulator);
        mc.imk(simulator.asAKB(AtallaSimulator.IMK_ARQC)).pan("9901234567890123").cardSequence("45").diversification("1234567890123456").arqc("922F3E83125EB46B").dataBlock("0123456789ABCDEF0123456789ABCDEF").arc("0000").process();
    }
}

