/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.StringUtil;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;

public class IBM3624PINOffset {
    Map<Character, Character> decimalizationTable = new HashMap<Character, Character>();

    public IBM3624PINOffset() {
        try {
            this.setDecimalizationTable("0123456789012345");
        }
        catch (GeneralSecurityException e) {
            Logger.suppress((Throwable)e);
        }
    }

    public void setDecimalizationTable(String decString) throws GeneralSecurityException {
        if (decString.length() != 16) {
            throw new GeneralSecurityException("Must be 16 digits");
        }
        for (int i = 0; i < 16; ++i) {
            char c = decString.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new GeneralSecurityException("Must be all digits");
        }
        String hexString = "0123456789ABCDEF";
        this.decimalizationTable.clear();
        for (int i = 0; i < decString.length(); ++i) {
            this.decimalizationTable.put(Character.valueOf(hexString.charAt(i)), Character.valueOf(decString.charAt(i)));
        }
    }

    public String generateOffset(byte[] pvvKey, String acctNum, char pad, String pin) throws GeneralSecurityException {
        int i;
        if (pin.length() < 4) {
            throw new GeneralSecurityException("pin length too short");
        }
        if (pin.length() > 12) {
            throw new GeneralSecurityException("pin length too long");
        }
        for (int i2 = 0; i2 < pin.length(); ++i2) {
            char c = pin.charAt(i2);
            if (c >= '0' && c <= '9') continue;
            throw new GeneralSecurityException("PIN must be all digits");
        }
        byte[] pvvKeyNormalized = pvvKey;
        pvvKeyNormalized = AKB.normalizeKey(pvvKeyNormalized);
        SecretKeySpec pvv = new SecretKeySpec(pvvKeyNormalized, "DESede");
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        StringBuilder builder = new StringBuilder();
        String paddedAcctNum = StringUtil.padRight((String)acctNum, (int)16, (char)pad);
        cipher.init(1, pvv);
        byte[] acctNo = Hex.toBytes(paddedAcctNum);
        byte[] encrypted = cipher.doFinal(acctNo);
        String ipin = Hex.toString(encrypted);
        for (i = 0; i < ipin.length(); ++i) {
            builder.append(this.decimalizationTable.get(Character.valueOf(ipin.charAt(i))));
        }
        ipin = builder.toString();
        builder.setLength(0);
        for (i = 0; i < pin.length(); ++i) {
            int ipinDigit;
            int pinDidigit = Integer.parseInt(Character.toString(pin.charAt(i)));
            int offset = pinDidigit - (ipinDigit = Integer.parseInt(Character.toString(ipin.charAt(i))));
            if (offset < 0) {
                offset += 10;
            }
            builder.append(Integer.toString(offset %= 10));
        }
        return builder.toString();
    }

    public static void main(String ... args) throws Throwable {
        IBM3624PINOffset ibm = new IBM3624PINOffset();
        ibm.setDecimalizationTable("8351296477461538");
        byte[] pvvKeyBytes = Hex.toBytes("89B07B35A1B3F47E89B07B35A1B3F47E89B07B35A1B3F47E");
        String offset = ibm.generateOffset(pvvKeyBytes, "33333333", 'D', "361436");
        System.out.println("pin offset=" + offset + " should be 756694");
        ibm.setDecimalizationTable("0123456789012345");
        pvvKeyBytes = Hex.toBytes("3333 3333 3333 3333");
        offset = ibm.generateOffset(pvvKeyBytes, "123456123456", 'F', "1234");
        System.out.println("pin offset=" + offset + " should be 3053");
        offset = ibm.generateOffset(pvvKeyBytes, "123456123456", 'F', "4321");
        System.out.println("pin offset=" + offset + " should be 6140");
    }
}

