/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.thales;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.hsm.thales.ChangePIN_IBM;
import net.e6tech.elements.security.hsm.thales.Echo;
import net.e6tech.elements.security.hsm.thales.EncryptPIN_IBM;
import net.e6tech.elements.security.hsm.thales.GenerateCVV;
import net.e6tech.elements.security.hsm.thales.VerifyPIN_ZPK_IBM;

public abstract class Command {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static Map<String, Class<? extends Command>> commandClass = new HashMap<String, Class<? extends Command>>();
    private static Map<Class<? extends Command>, String> classCommand = new HashMap<Class<? extends Command>, String>();
    private static Map<String, Integer> keyTypes = new HashMap<String, Integer>();
    public static final int LENGTH_BYTES = 2;
    private int headerLength = 4;
    private String command = classCommand.get(this.getClass());
    private String header = "0000";
    private String response;
    private String trailer;
    private int bufferSegmentSize = 256;
    private ByteBuffer packed;
    private ByteBuffer unpacked;
    private String lmkId;
    private boolean enveloped = false;

    public static Command fromBytes(byte[] bytes, int headerLength) {
        int offset = 3 + headerLength;
        byte[] commandBytes = Arrays.copyOfRange(bytes, offset, offset + 2);
        String command = new String(commandBytes, 0, 2, StandardCharsets.US_ASCII);
        Class<? extends Command> cls = commandClass.get(command);
        try {
            Command cmd = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return cmd.headerLength(headerLength).decode(bytes);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Command command(String command) {
        this.command = command;
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Command enveloped(boolean e) {
        this.enveloped = e;
        return this;
    }

    public boolean isEnveloped() {
        return this.enveloped;
    }

    public void setEnveloped(boolean enveloped) {
        this.enveloped = enveloped;
    }

    public Command header(String header) {
        this.header = header;
        return this;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Command headerLength(int length) {
        this.headerLength = length;
        return this;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public Command lmkId(String lmkId) {
        this.setLmkId(lmkId);
        return this;
    }

    public String getLmkId() {
        return this.lmkId;
    }

    public void setLmkId(String lmkId) {
        this.lmkId = lmkId;
    }

    public Command trailer(String trailer) {
        this.trailer = trailer;
        return this;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String trailer) {
        this.trailer = trailer;
    }

    public int getBufferSegmentSize() {
        return this.bufferSegmentSize;
    }

    public void setBufferSegmentSize(int bufferSegmentSize) {
        this.bufferSegmentSize = bufferSegmentSize;
    }

    public String response() {
        if (this.response != null) {
            return this.response;
        }
        char n = (char)(this.getCommand().charAt(1) + '\u0001');
        this.response = "" + this.getCommand().charAt(0) + n;
        return this.response;
    }

    protected Command pack(Object ... objects) {
        for (Object object : objects) {
            byte[] bytes = null;
            if (object instanceof String) {
                bytes = ((String)object).getBytes(StandardCharsets.US_ASCII);
            } else if (object instanceof byte[]) {
                bytes = (byte[])object;
            } else {
                throw new IllegalArgumentException("Cannot encode " + object.getClass());
            }
            this.encodeBytes(bytes);
        }
        return this;
    }

    private void encodeBytes(byte[] bytes) {
        this.expandBuffer(bytes.length);
        this.packed.put(bytes);
    }

    private void expandBuffer(int additionalSpace) {
        if (this.packed == null) {
            this.packed = ByteBuffer.allocate(((additionalSpace + this.bufferSegmentSize / 2) / this.bufferSegmentSize + 1) * this.bufferSegmentSize);
        }
        if (additionalSpace > this.packed.remaining()) {
            int size = this.packed.position();
            int newSize = ((size + additionalSpace + this.bufferSegmentSize / 2) / this.bufferSegmentSize + 1) * this.bufferSegmentSize;
            byte[] newBuff = new byte[newSize];
            this.packed.flip();
            this.packed.get(newBuff, 0, size);
            this.packed = ByteBuffer.wrap(newBuff);
            this.packed.position(size);
        }
    }

    protected void packFields() {
    }

    protected void packLmkId() {
        if (this.lmkId != null) {
            this.pack("%", this.lmkId);
        }
    }

    protected byte[] encode() {
        int envelopeSize = this.enveloped ? 3 : 0;
        int envelopeOffset = this.enveloped ? 1 : 0;
        this.packFields();
        this.packLmkId();
        int trailerLength = 0;
        if (this.trailer != null) {
            trailerLength = this.trailer.length() + 1;
        }
        if (this.packed == null) {
            this.packed = ByteBuffer.wrap(EMPTY_BYTES);
        }
        int bodyLength = this.packed.position();
        byte[] commandBytes = this.getCommand().getBytes(StandardCharsets.US_ASCII);
        byte[] headerBytes = this.header.getBytes(StandardCharsets.US_ASCII);
        short payloadSize = (short)(headerBytes.length + commandBytes.length + bodyLength + trailerLength);
        byte[] bytes = new byte[envelopeSize + 2 + payloadSize];
        int lcr = 0;
        if (this.enveloped) {
            bytes[0] = 2;
            bytes[bytes.length - 1] = 3;
        }
        byte[] len = Command.encodeLength(payloadSize);
        int offset = envelopeOffset;
        System.arraycopy(len, 0, bytes, offset, len.length);
        System.arraycopy(headerBytes, 0, bytes, offset += len.length, headerBytes.length);
        System.arraycopy(commandBytes, 0, bytes, offset += headerBytes.length, commandBytes.length);
        int size = this.packed.position();
        this.packed.flip();
        this.packed.get(bytes, offset += commandBytes.length, size);
        offset += size;
        if (this.trailer != null) {
            bytes[offset] = 25;
            byte[] trailerBytes = this.trailer.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(trailerBytes, 0, bytes, ++offset, trailerBytes.length);
        }
        if (this.enveloped) {
            for (int i = 3; i < bytes.length - 2; ++i) {
                lcr ^= bytes[i];
            }
            bytes[bytes.length - 2] = (byte)lcr;
        }
        return bytes;
    }

    protected void unpackFields() {
    }

    protected String unpackString(int len) {
        byte[] buffer = new byte[len];
        this.unpacked.get(buffer, 0, len);
        return new String(buffer, StandardCharsets.US_ASCII);
    }

    protected String peekString(int len) {
        byte[] buffer = new byte[len];
        this.unpacked.mark();
        this.unpacked.get(buffer, 0, len);
        this.unpacked.reset();
        return new String(buffer, StandardCharsets.US_ASCII);
    }

    protected String unpackKey() {
        String keyType = this.peekString(1);
        Integer size = keyTypes.get(keyType);
        if (size != null) {
            this.unpackString(1);
            return this.unpackString(size);
        }
        return this.unpackString(32);
    }

    protected String unpackDelimited(char delimiter) {
        int start = this.unpacked.position();
        this.unpacked.mark();
        int end = -1;
        while (this.unpacked.position() < this.unpacked.limit()) {
            int ch = this.unpacked.get();
            if ((ch = 0xFF & ch) != delimiter) continue;
            end = this.unpacked.position();
            break;
        }
        this.unpacked.reset();
        if (end >= 0) {
            String str = this.unpackString(end - start - 1);
            this.unpacked.get();
            return str;
        }
        return "";
    }

    protected byte[] unpackBytes(int len) {
        byte[] buffer = new byte[len];
        this.unpacked.get(buffer, 0, len);
        return buffer;
    }

    protected Command decode(byte[] bytes) {
        int envelopeOffset;
        int offset = envelopeOffset = this.enveloped ? 1 : 0;
        byte[] len = Arrays.copyOfRange(bytes, offset, offset + 2);
        short length = Command.decodeLength(len);
        byte[] headerByte = Arrays.copyOfRange(bytes, offset += 2, offset + this.headerLength);
        this.header = new String(headerByte, StandardCharsets.US_ASCII);
        byte[] commandBytes = Arrays.copyOfRange(bytes, offset += this.headerLength, offset + 2);
        this.command = new String(commandBytes, 0, 2, StandardCharsets.US_ASCII);
        byte[] body = Arrays.copyOfRange(bytes, offset += 2, offset + length - this.headerLength - 2);
        int trailerIndex = body.length;
        for (int i = body.length - 1; i >= 0 && i >= body.length - 34; --i) {
            if (body[i] != 25) continue;
            trailerIndex = i;
            break;
        }
        if (trailerIndex < body.length) {
            this.trailer = new String(body, trailerIndex + 1, body.length - trailerIndex - 1, StandardCharsets.US_ASCII);
        }
        this.unpacked = ByteBuffer.wrap(body, 0, trailerIndex);
        this.unpackFields();
        return this;
    }

    public static byte[] encodeLength(short len) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        return byteBuffer.putShort(len).array();
    }

    public static short decodeLength(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getShort();
    }

    static {
        commandClass.put("B2", Echo.class);
        commandClass.put("CW", GenerateCVV.class);
        commandClass.put("EA", VerifyPIN_ZPK_IBM.class);
        commandClass.put("DU", ChangePIN_IBM.class);
        commandClass.put("DU", EncryptPIN_IBM.class);
        for (Map.Entry<String, Class<? extends Command>> entry : commandClass.entrySet()) {
            classCommand.put(entry.getValue(), entry.getKey());
        }
        keyTypes.put("Z", 16);
        keyTypes.put("U", 32);
        keyTypes.put("T", 48);
        keyTypes.put("X", 32);
        keyTypes.put("Y", 48);
    }
}

