/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.thales.simulator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.hsm.Simulator;
import net.e6tech.elements.security.hsm.thales.Command;
import net.e6tech.elements.security.hsm.thales.simulator.CommandProcessor;

public class ThalesSimulator
extends Simulator {
    static Logger logger = Logger.getLogger();
    private int lengthBytes = 2;
    private int headerLength = 4;
    private boolean enveloped = false;

    public ThalesSimulator() {
        this.setPort(1500);
    }

    @Override
    protected void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] length = new byte[this.lengthBytes];
        while (true) {
            BufferedInputStream in = new BufferedInputStream(inputStream);
            Throwable throwable = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream(outputStream);
                Throwable throwable2 = null;
                try {
                    int envelopeSize = 0;
                    int envelopeOffset = 0;
                    int stx = 2;
                    if (this.enveloped) {
                        stx = in.read();
                        envelopeSize = 3;
                        envelopeOffset = 1;
                    }
                    this.read(in, length, 0);
                    int len = this.bcd(length);
                    byte[] buffer = new byte[len + envelopeSize + this.lengthBytes];
                    this.read(in, buffer, envelopeOffset + this.lengthBytes);
                    if (this.enveloped) {
                        buffer[0] = (byte)stx;
                    }
                    for (int i = 0; i < this.lengthBytes; ++i) {
                        buffer[i + envelopeOffset] = length[i];
                    }
                    Command cmd = Command.fromBytes(buffer, this.lengthBytes, this.headerLength);
                    CommandProcessor commandProcessor = CommandProcessor.forCommand(cmd);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    out.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
                continue;
            }
            break;
        }
    }

    protected int bcd(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append((b & 0xF0) >>> 4).append(b & 0xF);
        }
        return Integer.parseInt(builder.toString());
    }

    protected void read(InputStream in, byte[] buffer, int offset) throws IOException {
        int r;
        int read = offset;
        while ((read += (r = in.read(buffer, read, buffer.length - read))) < buffer.length) {
        }
    }
}

