/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.RNG;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SymmetricCipher {
    public static final String ALGORITHM_AES = "AES";
    static volatile boolean initialized = false;
    static final Logger logger = Logger.getLogger();
    private String algorithm;
    private String transformation;
    private int keyLength;
    private boolean base64 = false;

    protected SymmetricCipher(String algorithm, int keyLength) {
        this.algorithm = algorithm;
        this.transformation = algorithm + "/CBC/PKCS7PADDING";
        this.keyLength = keyLength;
        this.generateKeySpec();
    }

    public static SymmetricCipher getInstance(String algorithm) {
        return SymmetricCipher.getInstance(algorithm, 256);
    }

    public static SymmetricCipher getInstance(String algorithm, int keyLength) {
        if (ALGORITHM_AES.equalsIgnoreCase(algorithm)) {
            return new SymmetricCipher(ALGORITHM_AES, keyLength);
        }
        throw new IllegalArgumentException(algorithm + " is not supported");
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static void initialize() {
        int major;
        if (initialized) {
            return;
        }
        initialized = true;
        Security.addProvider((Provider)new BouncyCastleProvider());
        String version = System.getProperty("java.version");
        String[] components = version.split("\\.");
        if (components[0].equals("1")) {
            try {
                major = Integer.valueOf(components[1]);
            }
            catch (NumberFormatException ex) {
                major = 8;
            }
        } else {
            try {
                major = Integer.valueOf(components[0]);
            }
            catch (NumberFormatException ex) {
                major = 9;
            }
        }
        if (major >= 9) {
            SymmetricCipher.unlimitedCrypto9();
        } else {
            SymmetricCipher.unlimitedCrypto8();
        }
    }

    private static void unlimitedCrypto9() {
    }

    private static void unlimitedCrypto8() {
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field isRestrictedField = jceSecurity.getDeclaredField("isRestricted");
            isRestrictedField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            int origMod = isRestrictedField.getModifiers();
            modifiersField.setInt(isRestrictedField, isRestrictedField.getModifiers() & 0xFFFFFFEF);
            isRestrictedField.set(null, false);
            modifiersField.setInt(isRestrictedField, origMod);
            Field defaultPolicyField = jceSecurity.getDeclaredField("defaultPolicy");
            defaultPolicyField.setAccessible(true);
            PermissionCollection defaultPolicy = (PermissionCollection)defaultPolicyField.get(null);
            Field perms = cryptoPermissions.getDeclaredField("perms");
            perms.setAccessible(true);
            ((Map)perms.get(defaultPolicy)).clear();
            Field instance = cryptoAllPermission.getDeclaredField("INSTANCE");
            instance.setAccessible(true);
            defaultPolicy.add((Permission)instance.get(null));
            logger.info("Successfully removed cryptography restrictions");
        }
        catch (Exception e) {
            logger.warn("Failed to remove cryptography restrictions", (Throwable)e);
        }
    }

    public boolean isBase64() {
        return this.base64;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    public byte[] toBytes(String string) {
        if (this.base64) {
            return Base64.getDecoder().decode(string);
        }
        return Hex.toBytes(string);
    }

    public String toString(byte[] bytes) {
        if (this.base64) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return Hex.toString(bytes);
    }

    public String encrypt(SecretKey key, byte[] plain, String iv) throws GeneralSecurityException {
        byte[] ivBytes = null;
        if (iv != null) {
            ivBytes = this.toBytes(iv);
        }
        byte[] encrypted = this.encryptBytes(key, plain, ivBytes);
        return this.toString(encrypted);
    }

    public byte[] encryptBytes(SecretKey key, byte[] plain, byte[] initVector) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        byte[] iv = initVector;
        if (iv != null) {
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
        } else {
            iv = new byte[16];
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = 0;
            }
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(plain);
    }

    public byte[] decrypt(SecretKey key, String encrypted, String initVector) throws GeneralSecurityException {
        byte[] ivBytes = null;
        if (initVector != null) {
            ivBytes = this.toBytes(initVector);
        }
        byte[] decodedBytes = this.toBytes(encrypted);
        return this.decryptBytes(key, decodedBytes, ivBytes);
    }

    public byte[] decryptBytes(SecretKey key, byte[] encrypted, byte[] initVector) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation, "BC");
        byte[] iv = initVector;
        if (iv != null) {
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
        } else {
            iv = new byte[16];
            for (int i = 0; i < iv.length; ++i) {
                iv[i] = 0;
            }
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
        }
        return cipher.doFinal(encrypted);
    }

    public SecretKey generateKeySpec() {
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemException((Throwable)e);
        }
        keyGen.init(this.keyLength);
        return keyGen.generateKey();
    }

    public SecretKey getKeySpec(byte[] bytes) {
        return new SecretKeySpec(bytes, this.algorithm);
    }

    public byte[] generateIVBytes() {
        return RNG.generateSeed(16);
    }

    public String generateIV() {
        byte[] iv = this.generateIVBytes();
        if (this.base64) {
            return Base64.getEncoder().encodeToString(iv);
        }
        return Hex.toString(iv);
    }

    static {
        SymmetricCipher.initialize();
    }
}

