/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security;

import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import net.e6tech.elements.security.JavaKeyStore;
import net.e6tech.elements.security.Password;

public class SelfSignedCert {
    private String alias = "cert";
    private String dn = "CN=localhost.net,OU=IT,O=Unemployed,L=Austin,ST=Texas,C=US";
    private int expiration = 3;
    private JavaKeyStore javaKeyStore;
    private String format = "PKCS12";

    public void init() throws GeneralSecurityException {
        char[] password = Password.generateRandomPassword(9, 15);
        this.javaKeyStore = new JavaKeyStore();
        this.javaKeyStore.createSelfSignedCertificate(this.alias, this.dn, password, this.expiration);
        this.javaKeyStore.init(password);
    }

    public void init(JavaKeyStore javaKeyStore) {
        this.javaKeyStore = javaKeyStore;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        this.dn = dn;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public KeyManager[] getKeyManagers() {
        return this.javaKeyStore.getKeyManagers();
    }

    public TrustManager[] getTrustManagers() {
        return this.javaKeyStore.getTrustManagers();
    }
}

