/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.Terminal;
import net.e6tech.elements.security.vault.Credential;

public class DualEntry {
    Credential user1;
    Credential user2;
    boolean newUserMode = false;

    public DualEntry() {
    }

    public DualEntry(String user, char[] password) {
        this.user1 = new Credential(user, password);
    }

    public DualEntry(String user, char[] password, String user2, char[] password2) {
        this.user1 = new Credential(user, password);
        this.user2 = new Credential(user2, password2);
    }

    public boolean isNewUserMode() {
        return this.newUserMode;
    }

    public void setNewUserMode(boolean newUserMode) {
        this.newUserMode = newUserMode;
    }

    public void setUser1(Credential user1) {
        this.user1 = user1;
    }

    public void setUser2(Credential user2) {
        this.user2 = user2;
    }

    public void run(String text, int port) {
        while (!this.nestedRun(text, port)) {
        }
    }

    public void run(String text, ServerSocket serverSocket) {
        Terminal terminal = new Terminal();
        while (!this._user1(terminal, text, serverSocket)) {
        }
        while (!this._user2(terminal, serverSocket)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nestedRun(String text, int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception ex) {
                Logger.suppress((Throwable)ex);
            }
            throw new SystemException((Throwable)e);
        }
        Terminal terminal = new Terminal();
        try {
            if (!this._user1(terminal, text, serverSocket)) {
                boolean ex = false;
                return ex;
            }
            boolean ex = this._user2(terminal, serverSocket);
            return ex;
        }
        catch (Exception ex) {
            Logger.suppress((Throwable)ex);
            boolean bl = true;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    Logger.suppress((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _user1(Terminal terminal, String text, ServerSocket serverSocket) {
        if (this.user1 == null || this.user2 == null || this.user1.getUser() == null || this.user2.getUser() == null) {
            terminal.println(text);
        }
        if (this.user1 == null || this.user1.getUser() == null) {
            try (Terminal t = null;){
                t = new Terminal(serverSocket);
                String u1 = t.readLine("Username: ");
                char[] pwd = t.readPassword("Password: ");
                while (u1.length() == 0 || pwd.length == 0) {
                    if (u1.length() == 0) {
                        t.println("user name is empty...try again\n");
                    } else if (pwd.length == 0) {
                        t.println("password is empty...try again\n");
                    }
                    u1 = t.readLine("Username: ");
                    pwd = t.readPassword("Password: ");
                }
                if (!this.verifyPassword(t, pwd)) {
                    boolean bl = false;
                    return bl;
                }
                this.user1 = new Credential(u1, pwd);
                t.println("Please have user2 connect to port " + serverSocket.getLocalPort() + " to provide user name and password");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _user2(Terminal terminal, ServerSocket serverSocket) {
        while (this.user2 == null || this.user2.getUser() == null) {
            Terminal t = null;
            try {
                t = new Terminal(serverSocket);
                String u2 = t.readLine("Username:");
                char[] pwd = t.readPassword("Password:");
                if (u2 == null || pwd == null) {
                    terminal.println("Connection to user2 reset.");
                    continue;
                }
                while (u2.equalsIgnoreCase(this.user1.getUser()) || u2.length() == 0 || pwd.length == 0) {
                    if (u2.equalsIgnoreCase(this.user1.getUser())) {
                        t.println("user1 cannot be the same as user2...try again\n");
                    } else if (u2.length() == 0) {
                        t.println("user name is empty...try again\n");
                    } else if (pwd.length == 0) {
                        t.println("password is empty...try again\n");
                    }
                    u2 = t.readLine("Username:");
                    pwd = t.readPassword("Password:");
                }
                if (!this.verifyPassword(t, pwd)) {
                    boolean bl = false;
                    return bl;
                }
                this.user2 = new Credential(u2, pwd);
            }
            catch (Exception e) {
                Logger.suppress((Throwable)e);
                terminal.println("Error getting user2 name and password: " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        return true;
    }

    private boolean verifyPassword(Terminal terminal, char[] pwd) {
        char[] pwd2;
        if (this.newUserMode && !Arrays.equals(pwd, pwd2 = terminal.readPassword("Retype password: "))) {
            terminal.println("Passwords do not match");
            return false;
        }
        return true;
    }

    public Credential getUser1() {
        return this.user1;
    }

    public Credential getUser2() {
        return this.user2;
    }

    public void clear() {
        if (this.user1 != null) {
            this.user1.clear();
        }
        if (this.user2 != null) {
            this.user2.clear();
        }
        this.user2 = null;
        this.user1 = null;
    }
}

