/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.login.LoginException;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.AsymmetricCipher;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.RNG;
import net.e6tech.elements.security.SymmetricCipher;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Credential;
import net.e6tech.elements.security.vault.DualEntry;
import net.e6tech.elements.security.vault.FileStore;
import net.e6tech.elements.security.vault.KeyProtected;
import net.e6tech.elements.security.vault.PasswordProtected;
import net.e6tech.elements.security.vault.Secret;
import net.e6tech.elements.security.vault.Vault;
import net.e6tech.elements.security.vault.VaultManagerState;
import net.e6tech.elements.security.vault.VaultStore;

public class VaultManager {
    private static Logger logger = Logger.getLogger();
    public static final String KEY_VAULT = "key-vault";
    public static final String USER_VAULT = "user-vault";
    public static final String DATA_VAULT = "data-vault";
    public static final String LOCAL_VAULT = "local-vault";
    private SymmetricCipher symmetricCipher;
    private AsymmetricCipher asymmetricCipher;
    private long authorizationDuration = 900000L;
    private VaultStore userLocalStore;
    private boolean userLocalOpened = false;
    private VaultStore keyDataStore;
    private boolean keyDataOpened = false;
    private PasswordProtected pwd = new PasswordProtected();
    private KeyProtected keyEncryption = new KeyProtected();
    private VaultManagerState state = new VaultManagerState();
    private Random random = new Random();

    public VaultManager() {
        this.symmetricCipher = SymmetricCipher.getInstance("AES");
        this.symmetricCipher.setBase64(false);
        this.asymmetricCipher = AsymmetricCipher.getInstance("RSA");
        this.userLocalStore = this.keyDataStore = new FileStore();
        this.userLocalStore.manage(USER_VAULT, LOCAL_VAULT);
        this.keyDataStore.manage(KEY_VAULT, DATA_VAULT);
    }

    public long getAuthorizationDuration() {
        return this.authorizationDuration;
    }

    public void setAuthorizationDuration(long authorizationDuration) {
        this.authorizationDuration = authorizationDuration;
    }

    public VaultStore getKeyDataStore() {
        return this.keyDataStore;
    }

    public void setKeyDataStore(VaultStore keyDataStore) {
        this.keyDataStore = keyDataStore;
    }

    public VaultStore getUserLocalStore() {
        return this.userLocalStore;
    }

    public void setUserLocalStore(VaultStore userLocalStore) {
        this.userLocalStore = userLocalStore;
    }

    public SymmetricCipher getSymmetricCipher() {
        return this.symmetricCipher;
    }

    public AsymmetricCipher getAsymmetricCipher() {
        return this.asymmetricCipher;
    }

    private ClearText generateInternalKeyPair(String alias) throws GeneralSecurityException {
        KeyPair keyPair = this.asymmetricCipher.generateKeySpec();
        KeyFactory fact = this.asymmetricCipher.getKeyFactory();
        RSAPublicKeySpec pub = fact.getKeySpec(keyPair.getPublic(), RSAPublicKeySpec.class);
        RSAPrivateKeySpec priv = fact.getKeySpec(keyPair.getPrivate(), RSAPrivateKeySpec.class);
        ClearText ct = new ClearText();
        ct.alias(alias);
        BigInteger mod = priv.getModulus();
        BigInteger exp = priv.getPrivateExponent();
        String encoded = mod.toString(16) + "$" + exp.toString(16);
        try {
            ct.setBytes(encoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
        }
        ct.setProperty("type", "key-pair");
        ct.setProperty("algorithm", this.asymmetricCipher.getAlgorithm());
        ct.setProperty("public-key-mod", pub.getModulus().toString(16));
        ct.setProperty("public-key-exp", pub.getPublicExponent().toString(16));
        ct.protect();
        return ct;
    }

    private ClearText generateSignature() throws GeneralSecurityException {
        ClearText ct = new ClearText();
        byte[] bytes = RNG.generateSeed(16);
        ct.setBytes(bytes);
        ct.alias("signature");
        ct.setProperty("signature", Hex.toString(bytes));
        ct.setProperty("type", "signature");
        ct.setProperty("signature-format", "1.0");
        ct.protect();
        return ct;
    }

    private ClearText getPassphrase() throws GeneralSecurityException {
        Secret secret = this.getLocal("passphrase", null);
        return this.pwd.unsealUserOrPassphrase(secret, this.state.getPassword());
    }

    private ClearText getPassphrase(Secret secret) throws GeneralSecurityException {
        Secret passphraseSecrect;
        String[] components = secret.getSecret().split("\\$");
        if (components.length >= 5) {
            String keyVersion = components[4];
            passphraseSecrect = this.getLocal("passphrase", keyVersion);
        } else {
            passphraseSecrect = this.getLocal("passphrase", null);
        }
        return this.pwd.unsealUserOrPassphrase(passphraseSecrect, this.state.getPassword());
    }

    private ClearText generatePassphrase(char[] password) throws GeneralSecurityException {
        ClearText ct = new ClearText();
        try {
            ct.setBytes(new String(password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
        }
        ct.alias("passphrase");
        ct.setProperty("type", "passphrase");
        ct.protect();
        return ct;
    }

    private ClearText generateInternalKey(String alias) throws GeneralSecurityException {
        SecretKey secretKey = this.symmetricCipher.generateKeySpec();
        ClearText ct = new ClearText();
        ct.setBytes(secretKey.getEncoded());
        ct.alias(alias);
        ct.setProperty("type", "key");
        ct.setProperty("algorithm", "AES");
        ct.protect();
        return ct;
    }

    private ZonedDateTime setCreationTimeVersion(ClearText ct) {
        ZonedDateTime now = ZonedDateTime.now();
        String dateTime = now.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        if (ct.version() == null) {
            ct.setProperty("creation-date-time", dateTime);
            ct.setProperty("creation-time", Long.toString(now.toInstant().toEpochMilli()));
            ct.version(Long.toString(now.toInstant().toEpochMilli()));
        }
        return now;
    }

    public RSAPublicKeySpec getPublicKey() throws GeneralSecurityException {
        KeyFactory fact = this.asymmetricCipher.getKeyFactory();
        ClearText key = this.getKey("asy-key", null);
        if (key == null) {
            return null;
        }
        return fact.getKeySpec(key.asKeyPair().getPublic(), RSAPublicKeySpec.class);
    }

    public boolean validateUser(String user, char[] password) {
        try {
            if (user == null || password == null) {
                return false;
            }
            ClearText ct1 = this.getUser(new Credential(user, password));
            if (ct1 == null) {
                return false;
            }
            return ct1.getProperty("type").equals("user");
        }
        catch (Exception th) {
            Logger.suppress((Throwable)th);
            return false;
        }
    }

    public String authorize(Credential credential) throws GeneralSecurityException {
        this.checkAccess(credential);
        long now = System.currentTimeMillis();
        String token = "" + Long.toString(now) + "-" + this.random.nextInt(1000000);
        try {
            return this._encrypt("auth-key", token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
            return null;
        }
    }

    public String renew(String token) throws GeneralSecurityException {
        this.checkToken(token);
        long now = System.currentTimeMillis();
        String nextToken = "" + Long.toString(now) + "-" + this.random.nextInt(1000000);
        try {
            return this._encrypt("auth-key", nextToken.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
            return null;
        }
    }

    private void checkToken(String token) throws GeneralSecurityException {
        if (token == null) {
            throw new LoginException();
        }
        byte[] decrypted = this._decrypt(token);
        try {
            String plain = new String(decrypted, "UTF-8");
            int index = plain.indexOf(45);
            if (index < 0) {
                throw new LoginException("Invalid toke format");
            }
            long time = Long.parseLong(plain.substring(0, index));
            if (System.currentTimeMillis() - time > this.authorizationDuration) {
                Date date = new Date(time);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HHmmss");
                throw new LoginException("Token issued on " + format.format(date) + " expired.  Current time is " + format.format(new Date()));
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.suppress((Throwable)e);
            throw new LoginException();
        }
    }

    public void addKeyPair(String alias, DualEntry dualEntry) throws GeneralSecurityException {
        this.checkAccess(dualEntry);
        ClearText ct = this.generateInternalKeyPair(alias);
        this.addData(ct);
    }

    public void addSecretData(String alias, ClearText ct, DualEntry dualEntry) throws GeneralSecurityException {
        this.checkAccess(dualEntry);
        ct.alias(alias);
        ct.setProperty("type", "secret");
        ct.setProtectedProperty("type", "secret");
        this.addData(ct);
    }

    public ClearText getSecretData(String token, String alias) throws GeneralSecurityException {
        return this.getSecretData(token, alias, null);
    }

    public ClearText getSecretData(String token, String alias, String version) throws GeneralSecurityException {
        this.checkToken(token);
        Secret secret = this.getData(alias, version);
        if (secret == null) {
            return null;
        }
        String[] components = this.encryptedComponents(secret.getSecret());
        String keyAlias = components[2];
        String keyVersion = components[3];
        return this.keyEncryption.unseal(secret, this.getKey(keyAlias, keyVersion));
    }

    public ClearText getSecretData(Credential credential, String alias) throws GeneralSecurityException {
        return this.getSecretData(credential, alias, null);
    }

    public ClearText getSecretData(Credential credential, String alias, String version) throws GeneralSecurityException {
        this.checkAccess(credential);
        Secret secret = this.getData(alias, version);
        if (secret == null) {
            return null;
        }
        String[] components = this.encryptedComponents(secret.getSecret());
        String keyAlias = components[2];
        String keyVersion = components[3];
        return this.keyEncryption.unseal(secret, this.getKey(keyAlias, keyVersion));
    }

    private String[] encryptedComponents(String encoded) {
        String[] components = encoded.split("\\$");
        if (components.length != 4) {
            throw new IllegalStateException("Invalid encryption format");
        }
        return components;
    }

    public String generateKey(DualEntry dualEntry) throws GeneralSecurityException {
        byte[] plain = this.symmetricCipher.generateKeySpec().getEncoded();
        this.checkAccess(dualEntry);
        return this._encrypt("m-key", plain);
    }

    public String encrypt(String token, String key, byte[] data, String iv) throws GeneralSecurityException {
        this.checkToken(token);
        byte[] keyBytes = this._decrypt(key);
        SecretKey secretKey = this.symmetricCipher.getKeySpec(keyBytes);
        return this.symmetricCipher.encrypt(secretKey, data, iv);
    }

    public byte[] decrypt(String token, String key, String secret, String iv) throws GeneralSecurityException {
        this.checkToken(token);
        byte[] keyBytes = this._decrypt(key);
        SecretKey secretKey = this.symmetricCipher.getKeySpec(keyBytes);
        return this.symmetricCipher.decrypt(secretKey, secret, iv);
    }

    public byte[] decrypt(String token, String secret) throws GeneralSecurityException {
        this.checkToken(token);
        return this._decrypt(secret);
    }

    public String encryptPublic(byte[] data) throws GeneralSecurityException {
        ClearText key = this.getKey("asy-key", null);
        if (key == null) {
            throw new GeneralSecurityException("Public/Private key not set up");
        }
        return this.asymmetricCipher.encrypt(key.asKeyPair().getPublic(), data);
    }

    public byte[] decryptPrivate(String secret) throws GeneralSecurityException {
        ClearText key = this.getKey("asy-key", null);
        if (key == null) {
            throw new GeneralSecurityException("Public/Private key not set up");
        }
        return this.asymmetricCipher.decrypt(key.asKeyPair().getPrivate(), secret);
    }

    private ClearText getUser(Credential credential) throws GeneralSecurityException {
        Secret user = this.getUser(credential.getUser(), null);
        if (user == null) {
            return null;
        }
        return this.pwd.unsealUserOrPassphrase(user, credential.getPassword());
    }

    private void newUser(byte[] component, Credential credential, String group) throws GeneralSecurityException {
        Secret user = this.getUser(credential.getUser(), null);
        if (user != null) {
            throw new GeneralSecurityException("User exists: " + credential.getUser());
        }
        ClearText ct1 = new ClearText();
        ct1.alias(credential.getUser());
        ct1.setBytes(component);
        ct1.setProperty("username", credential.getUser());
        ct1.setProperty("guardian", group);
        ct1.setProperty("type", "user");
        this.setCreationTimeVersion(ct1);
        ct1.protect();
        this.addUser(this.pwd.sealUser(ct1, credential.getPassword()));
    }

    public void addUser(Credential newUser, Credential existingUser) throws GeneralSecurityException {
        this.checkAccess(existingUser);
        ClearText ct1 = this.getUser(existingUser);
        if (ct1 == null) {
            throw new GeneralSecurityException("Existing user not found: " + existingUser.getUser());
        }
        this.newUser(ct1.getBytes(), newUser, ct1.getProperty("guardian"));
    }

    public void changePassword(String user, char[] oldPwd, char[] newPwd) throws GeneralSecurityException {
        Vault userVault = this.userLocalStore.getVault(USER_VAULT);
        Set<Long> versions = userVault.versions(user);
        for (Long version : versions) {
            Secret secret = this.getUser(user, "" + version);
            ClearText ct = this.pwd.unsealUserOrPassphrase(secret, oldPwd);
            this.addUser(this.pwd.sealUser(ct, newPwd));
        }
    }

    public void passphraseLock(String alias, ClearText ct, DualEntry dualEntry) throws GeneralSecurityException {
        ClearText clearPassphrase;
        ct.alias(alias);
        if (alias.equals("passphrase")) {
            clearPassphrase = this.generatePassphrase(this.getPassphrase(dualEntry));
            clearPassphrase.version("0");
        } else {
            Secret passphrase = this.getLocal("passphrase", null);
            clearPassphrase = this.pwd.unsealUserOrPassphrase(passphrase, this.getPassphrase(dualEntry));
        }
        this.addLocal(ct, clearPassphrase);
    }

    public ClearText passphraseUnlock(String alias, Credential credential) throws GeneralSecurityException {
        this.checkAccess(credential);
        Secret secret = this.getLocal(alias, null);
        if (secret == null) {
            return null;
        }
        return this.pwd.unseal(secret, this.getPassphrase());
    }

    public ClearText passphraseUnlock(String token, String alias) throws GeneralSecurityException {
        this.checkToken(token);
        Secret secret = this.getLocal(alias, null);
        if (secret == null) {
            return null;
        }
        return this.pwd.unseal(secret, this.getPassphrase());
    }

    public void newMasterKey(DualEntry dualEntry) throws GeneralSecurityException {
        this.getPassphrase(dualEntry);
        this.addKey(this.generateInternalKey("m-key"));
    }

    private void checkAccess(Credential credential) throws GeneralSecurityException {
        ClearText ct = this.getUser(credential);
        if (ct == null) {
            throw new GeneralSecurityException("Cannot find user " + credential.getUser());
        }
        if (!ct.getProperty("guardian").equals("group-1") && !ct.getProperty("guardian").equals("group-2")) {
            throw new GeneralSecurityException("User " + ct.getProperty("username") + " is not a guardian");
        }
        if (!ct.getProperty("guardian").equals(ct.getProtectedProperty("guardian"))) {
            throw new GeneralSecurityException("User " + ct.getProperty("username") + " guardian property has been tempered");
        }
    }

    private void checkAccess(DualEntry dualEntry) throws GeneralSecurityException {
        ClearText ct1 = this.getUser(dualEntry.getUser1());
        ClearText ct2 = this.getUser(dualEntry.getUser2());
        if (ct1 == null) {
            throw new GeneralSecurityException("Bad user name " + dualEntry.getUser1());
        }
        if (ct2 == null) {
            throw new GeneralSecurityException("Bad user name " + dualEntry.getUser2());
        }
        if (ct1.getProperty("guardian") == null || !ct1.getProperty("guardian").equals("group-1") && !ct1.getProperty("guardian").equals("group-2")) {
            throw new SystemException("User " + ct1.getProperty("username") + " is not a guardian");
        }
        if (ct2.getProperty("guardian") == null || !ct2.getProperty("guardian").equals("group-1") && !ct2.getProperty("guardian").equals("group-2")) {
            throw new GeneralSecurityException("User " + ct2.getProperty("username") + " is not a guardian");
        }
        if (ct1.getProperty("guardian").equals(ct2.getProperty("guardian"))) {
            throw new SystemException("User1 " + ct1.getProperty("username") + " and user 2 " + ct2.getProperty("username") + " cannot be in the same group");
        }
        if (!ct1.getProperty("guardian").equals(ct1.getProtectedProperty("guardian"))) {
            throw new GeneralSecurityException("User " + ct1.getProperty("username") + " guardian property has been tempered");
        }
        if (!ct2.getProperty("guardian").equals(ct2.getProtectedProperty("guardian"))) {
            throw new GeneralSecurityException("User " + ct2.getProperty("username") + " guardian property has been tempered");
        }
    }

    private char[] getPassphrase(DualEntry dualEntry) throws GeneralSecurityException {
        ClearText ct1 = this.getUser(dualEntry.getUser1());
        if (ct1 == null) {
            throw new GeneralSecurityException("Cannot find user " + dualEntry.getUser1());
        }
        ClearText ct2 = this.getUser(dualEntry.getUser2());
        if (ct2 == null) {
            throw new GeneralSecurityException("Cannot find user " + dualEntry.getUser2());
        }
        this.checkAccess(dualEntry);
        byte[] comp1 = ct1.getBytes();
        byte[] comp2 = ct2.getBytes();
        byte[] pwdBytes = new byte[comp1.length];
        for (int i = 0; i < comp1.length; ++i) {
            pwdBytes[i] = (byte)((comp1[i] ^ comp2[i]) & 0xFF);
        }
        return Hex.toString(pwdBytes).toCharArray();
    }

    public void changePassphrase(DualEntry dualEntry) throws GeneralSecurityException {
        this.checkAccess(dualEntry);
        VaultManagerState oldState = this.state.clone();
        String currentVersion = this.state.getSignature().version();
        try {
            this.userLocalStore.backup(currentVersion);
            this.keyDataStore.backup(currentVersion);
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex);
        }
        try {
            ClearText ct;
            byte[] comp1 = RNG.generateSeed(16);
            byte[] comp2 = RNG.generateSeed(16);
            ClearText ct1 = this.getUser(dualEntry.getUser1());
            ClearText ct2 = this.getUser(dualEntry.getUser2());
            ct1.setBytes(comp1);
            ct2.setBytes(comp2);
            this.addUser(this.pwd.sealUser(ct1, dualEntry.getUser1().getPassword()));
            this.addUser(this.pwd.sealUser(ct2, dualEntry.getUser2().getPassword()));
            ClearText passphrase = this.generatePassphrase(this.getPassphrase(dualEntry));
            this.passphraseLock("passphrase", passphrase, dualEntry);
            Vault localVault = this.userLocalStore.getVault(LOCAL_VAULT);
            localVault.removeSecret("signature", null);
            Set<String> aliases = localVault.aliases();
            for (String string : aliases) {
                Set<Long> versions = localVault.versions(string);
                for (Long version : versions) {
                    Secret secret = this.getLocal(string, "" + version);
                    ct = this.pwd.unseal(secret, passphrase);
                    this.addLocal(ct, passphrase);
                }
            }
            Vault keyVault = this.keyDataStore.getVault(KEY_VAULT);
            aliases = keyVault.aliases();
            for (String alias : aliases) {
                Set<Long> versions = keyVault.versions(alias);
                for (Long version : versions) {
                    ct = this.getKey(alias, "" + version);
                    Secret secret = this.pwd.seal(ct, passphrase);
                    keyVault.addSecret(secret);
                }
            }
            this.keyDataStore.getVault(DATA_VAULT).removeSecret("signature", null);
            aliases = this.listUsers();
            for (String alias : aliases) {
                if (dualEntry.getUser1().getUser().equals(alias) || dualEntry.getUser2().getUser().equals(alias)) continue;
                this.removeUser(alias, null);
            }
            ClearText clearText = this.generateSignature();
            this.addLocal(clearText, passphrase);
            this.state.getCachedKeys().clear();
            this.state.setPassword(new String(passphrase.getBytes(), "UTF-8").toCharArray());
            this.addData(clearText);
            this.state.setSignature(clearText);
        }
        catch (Exception th) {
            this.state = oldState;
            try {
                this.userLocalStore.restore(currentVersion);
                this.keyDataStore.restore(currentVersion);
            }
            catch (IOException ex) {
                throw new GeneralSecurityException(ex);
            }
            throw new GeneralSecurityException(th);
        }
        try {
            this.userLocalStore.save();
        }
        catch (Exception th) {
            this.restoreState(currentVersion, oldState);
            throw new GeneralSecurityException(th);
        }
        try {
            this.keyDataStore.save();
        }
        catch (Exception th) {
            this.restoreState(currentVersion, oldState);
            this.state = oldState;
            throw new GeneralSecurityException(th);
        }
    }

    private void restoreState(String currentVersion, VaultManagerState oldState) throws GeneralSecurityException {
        try {
            this.restore(currentVersion);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        this.state = oldState;
    }

    private void restore(String version) throws IOException {
        this.userLocalStore.restore(version);
        this.keyDataStore.restore(version);
    }

    private String _encrypt(String keyAlias, byte[] plain) throws GeneralSecurityException {
        ClearText ct = this.getKey(keyAlias, null);
        if (ct == null) {
            throw new GeneralSecurityException("No key for keyAlias=" + keyAlias);
        }
        String iv = this.symmetricCipher.generateIV();
        String encrypted = this.symmetricCipher.encrypt(ct.asSecretKey(), plain, iv);
        return iv + "$" + encrypted + "$" + keyAlias + "$" + ct.version();
    }

    public byte[] _decrypt(String encoded) throws GeneralSecurityException {
        String version;
        String[] components = this.encryptedComponents(encoded);
        String alias = components[2];
        ClearText ct = this.getKey(alias, version = components[3]);
        if (ct == null) {
            throw new GeneralSecurityException("No key for keyAlias=" + alias);
        }
        return this.symmetricCipher.decrypt(ct.asSecretKey(), components[1], components[0]);
    }

    public void save() throws IOException {
        this.userLocalStore.save();
        this.keyDataStore.save();
    }

    public void close() throws IOException {
        this.userLocalStore.close();
        this.keyDataStore.close();
    }

    public void open(DualEntry dualEntry) throws GeneralSecurityException {
        if (this.userLocalOpened) {
            return;
        }
        try {
            this.userLocalStore.open();
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        this.userLocalOpened = true;
        boolean modified = false;
        if (this.userLocalStore.getVault(USER_VAULT).size() == 0) {
            byte[] comp1 = RNG.generateSeed(16);
            byte[] comp2 = RNG.generateSeed(16);
            this.newUser(comp1, dualEntry.getUser1(), "group-1");
            this.newUser(comp2, dualEntry.getUser2(), "group-2");
            try {
                this.state.setPassword(this.getPassphrase(dualEntry));
            }
            catch (GeneralSecurityException ex) {
                throw new GeneralSecurityException("Bad user name or password to unlock the vault", ex);
            }
            ClearText passphrase = this.generatePassphrase(this.getPassphrase(dualEntry));
            this.passphraseLock("passphrase", passphrase, dualEntry);
            ClearText signature = this.generateSignature();
            this.passphraseLock("signature", signature, dualEntry);
            modified = true;
        }
        if (modified) {
            try {
                this.userLocalStore.save();
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
        try {
            this.state.setPassword(this.getPassphrase(dualEntry));
        }
        catch (GeneralSecurityException ex) {
            throw new GeneralSecurityException("Bad user name or password to unlock the vault", ex);
        }
        this.state.setSignature(this.passphraseUnlock("signature", dualEntry.getUser1()));
    }

    private void openKeyData() throws GeneralSecurityException {
        if (this.keyDataOpened) {
            return;
        }
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        try {
            this.keyDataStore.open();
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        this.keyDataOpened = true;
        boolean modified = false;
        Secret keyStoreSigSecret = this.getData("signature", null);
        if (keyStoreSigSecret == null) {
            this.initKeys();
            this.addData(this.state.getSignature());
            modified = true;
        } else {
            String signatureFormat = this.state.getSignature().getProperty("signature-format");
            String dataSignatureFormat = keyStoreSigSecret.getProperty("signature-format");
            boolean restore = false;
            if (signatureFormat != null) {
                if (!signatureFormat.equals(dataSignatureFormat) || !this.state.getSignature().getProperty("signature").equals(keyStoreSigSecret.getProperty("signature"))) {
                    restore = true;
                }
            } else if (dataSignatureFormat != null) {
                restore = true;
            }
            if (restore) {
                try {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Restoring key data store to version {}", (Object)this.state.getSignature().version());
                    }
                    this.keyDataStore.restore(this.state.getSignature().version());
                    keyStoreSigSecret = this.getData("signature", null);
                }
                catch (IOException e) {
                    throw new GeneralSecurityException("Property signature do not match.  Local store vault signature does not match key store signature", e);
                }
            }
            modified = this.initKeys();
            String[] components = this.encryptedComponents(keyStoreSigSecret.getSecret());
            String keyAlias = components[2];
            String keyVersion = components[3];
            ClearText keyStoreSig = this.keyEncryption.unseal(keyStoreSigSecret, this.getKey(keyAlias, keyVersion));
            if (!Arrays.equals(this.state.getSignature().getBytes(), keyStoreSig.getBytes())) {
                try {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Restoring key data store to version {}", (Object)this.state.getSignature().version());
                    }
                    this.keyDataStore.restore(this.state.getSignature().version());
                }
                catch (IOException e) {
                    throw new GeneralSecurityException("Local store vault signature does not match key store signature", e);
                }
            }
        }
        if (modified) {
            try {
                this.keyDataStore.save();
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    private boolean initKeys() throws GeneralSecurityException {
        boolean modified = false;
        if (this.getKey("m-key", null) == null) {
            this.addKey(this.generateInternalKey("m-key"));
            modified = true;
        }
        if (this.getKey("auth-key", null) == null) {
            this.addKey(this.generateInternalKey("auth-key"));
            modified = true;
        }
        if (this.getKey("asy-key", null) == null) {
            this.addKey(this.generateInternalKeyPair("asy-key"));
            modified = true;
        }
        return modified;
    }

    private ClearText getKey(String keyAlias, String version) throws GeneralSecurityException {
        ClearText ct;
        Object key;
        this.openKeyData();
        if (version != null) {
            key = keyAlias + ":" + version;
            ct = this.state.getCachedKeys().get(key);
            if (ct != null) {
                return ct;
            }
        }
        if ((key = this.keyDataStore.getVault(KEY_VAULT).getSecret(keyAlias, version)) == null) {
            return null;
        }
        ct = this.pwd.unseal((Secret)key, this.getPassphrase((Secret)key));
        this.state.getCachedKeys().put(ct.alias() + ":" + ct.version(), ct);
        return ct;
    }

    private void addKey(ClearText ct) throws GeneralSecurityException {
        this.openKeyData();
        this.setCreationTimeVersion(ct);
        ClearText passphrase = this.getPassphrase();
        Secret secret = this.pwd.seal(ct, passphrase);
        this.keyDataStore.getVault(KEY_VAULT).addSecret(secret);
        this.state.getCachedKeys().put(ct.alias() + ":" + ct.version(), ct);
    }

    private void addData(ClearText ct) throws GeneralSecurityException {
        this.openKeyData();
        this.setCreationTimeVersion(ct);
        ClearText key = this.getKey("m-key", null);
        Secret secret = this.keyEncryption.seal(ct.alias(), ct, key);
        this.keyDataStore.getVault(DATA_VAULT).addSecret(secret);
    }

    private Secret getData(String alias, String version) throws GeneralSecurityException {
        this.openKeyData();
        return this.keyDataStore.getVault(DATA_VAULT).getSecret(alias, version);
    }

    private void addUser(Secret secret) throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        this.userLocalStore.getVault(USER_VAULT).addSecret(secret);
    }

    private Secret getUser(String alias, String version) throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        return this.userLocalStore.getVault(USER_VAULT).getSecret(alias, version);
    }

    private void removeUser(String alias, String version) throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        this.userLocalStore.getVault(USER_VAULT).removeSecret(alias, version);
    }

    public Set<String> listUsers() throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        return this.userLocalStore.getVault(USER_VAULT).aliases();
    }

    private void addLocal(ClearText ct, ClearText passphrase) throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        this.setCreationTimeVersion(ct);
        Secret secret = this.pwd.seal(ct, passphrase);
        this.userLocalStore.getVault(LOCAL_VAULT).addSecret(secret);
    }

    private Secret getLocal(String alias, String version) throws GeneralSecurityException {
        if (!this.userLocalOpened) {
            throw new GeneralSecurityException("user local store is not open.  Please call open() first");
        }
        return this.userLocalStore.getVault(LOCAL_VAULT).getSecret(alias, version);
    }
}

