/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.security.PasswordEncrypted;
import net.e6tech.elements.security.PasswordEncryption;
import net.e6tech.elements.security.vault.ClearText;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Secret;

public class PasswordProtected {
    private static final String UTF8 = "UTF-8";

    public Secret sealUser(ClearText clear, char[] password) throws GeneralSecurityException {
        ClearText passphrase = new ClearText();
        passphrase.version("0");
        passphrase.alias("passphrase");
        try {
            passphrase.setBytes(new String(password).getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        return this.seal(clear, passphrase);
    }

    public Secret seal(ClearText clear, ClearText passphrase) throws GeneralSecurityException {
        if (clear.alias() == null) {
            throw new SystemException("null alias");
        }
        clear.setProtectedProperty("alias", clear.alias());
        PasswordEncryption pwdEnc = null;
        try {
            pwdEnc = new PasswordEncryption(new String(passphrase.getBytes(), UTF8).toCharArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
        PasswordEncrypted encrypted = pwdEnc.encrypt(clear.getBytes(), passphrase.alias(), passphrase.version());
        Secret secret = new Secret();
        secret.setProperties((Properties)clear.getProperties().clone());
        secret.setSecret(encrypted.toHex());
        if (clear.getProtectedProperties() != null) {
            try {
                String str = Constants.mapper.writeValueAsString((Object)clear.getProtectedProperties());
                encrypted = pwdEnc.encrypt(str.getBytes(UTF8), passphrase.alias(), passphrase.version());
                secret.setProtectedProperties(encrypted.toHex());
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        return secret;
    }

    public ClearText unsealUserOrPassphrase(Secret secret, char[] password) throws GeneralSecurityException {
        ClearText passphrase = new ClearText();
        passphrase.version("0");
        passphrase.alias("passphrase");
        try {
            passphrase.setBytes(new String(password).getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        return this.unseal(secret, passphrase);
    }

    public ClearText unseal(Secret secret, ClearText passphrase) throws GeneralSecurityException {
        PasswordEncrypted encrypted = new PasswordEncrypted(secret.getSecret());
        PasswordEncryption pwdEnc = null;
        try {
            pwdEnc = new PasswordEncryption(new String(passphrase.getBytes(), UTF8).toCharArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
        byte[] plain = pwdEnc.decrypt(encrypted);
        ClearText ct = new ClearText();
        ct.setBytes(plain);
        ct.setProperties((Properties)secret.getProperties().clone());
        if (secret.getProtectedProperties() != null) {
            byte[] props = pwdEnc.decrypt(new PasswordEncrypted(secret.getProtectedProperties()));
            Properties properties = null;
            try {
                properties = (Properties)Constants.mapper.readValue(new String(props, UTF8), Properties.class);
            }
            catch (IOException e) {
                throw new SystemException((Throwable)e);
            }
            ct.setProtectedProperties(properties);
        }
        return ct;
    }
}

