/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.vault.Constants;
import net.e6tech.elements.security.vault.Vault;
import net.e6tech.elements.security.vault.VaultFormat;
import net.e6tech.elements.security.vault.VaultImpl;
import net.e6tech.elements.security.vault.VaultStore;

public class FileStore
implements VaultStore {
    private static Logger logger = Logger.getLogger();
    private Map<String, VaultImpl> vaults = new LinkedHashMap<String, VaultImpl>();
    private Set<String> managedVaults = new HashSet<String>();
    private String fileName;
    private boolean backup = false;

    public FileStore() {
    }

    public FileStore(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public VaultStore manage(String ... vaultNames) {
        if (vaultNames == null) {
            return this;
        }
        for (String vaultName : vaultNames) {
            this.vaults.computeIfAbsent(vaultName, key -> new VaultImpl());
            this.managedVaults.add(vaultName);
        }
        return this;
    }

    @Override
    public VaultStore unmanage(String vaultName) {
        this.vaults.remove(vaultName);
        this.managedVaults.remove(vaultName);
        return this;
    }

    @Override
    public Vault getVault(String vaultName) {
        Vault vault = this.vaults.get(vaultName);
        if (vault == null && this.managedVaults.contains(vaultName)) {
            this.manage(vaultName);
            return (Vault)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Vault.class}, (InvocationHandler)new VaultInvocationHandler(vaultName));
        }
        if (vault == null) {
            return null;
        }
        return (Vault)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Vault.class}, (InvocationHandler)new VaultInvocationHandler(vaultName));
    }

    @Override
    public void backup(String version) throws IOException {
        this.copy(true, version);
    }

    @Override
    public void restore(String version) throws IOException {
        this.copy(false, version);
        this.open();
    }

    protected void copy(boolean backup, String version) throws IOException {
        File file;
        String backupFile;
        int index = this.fileName.lastIndexOf(46);
        if (index > 0) {
            String extension = this.fileName.substring(index);
            backupFile = this.fileName.substring(0, index) + "_" + version + extension;
        } else {
            backupFile = this.fileName + "_" + version;
        }
        if (backup) {
            file = new File(this.fileName);
            if (!file.exists()) {
                throw new IOException("Vault file does not exist: " + this.fileName);
            }
            if (!Files.exists(Paths.get(backupFile, new String[0]), new LinkOption[0])) {
                Files.copy(Paths.get(this.fileName, new String[0]), Paths.get(backupFile, new String[0]), new CopyOption[0]);
            }
        } else {
            file = new File(backupFile);
            if (!file.exists()) {
                throw new IOException("Backup vault file does not exist: " + this.fileName);
            }
            Files.copy(Paths.get(backupFile, new String[0]), Paths.get(this.fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public void save() throws IOException {
        if (this.fileName == null) {
            throw new IOException("null fileName");
        }
        if (!this.backup) {
            File file = new File(this.fileName);
            if (file.exists()) {
                String backupFile;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
                int index = this.fileName.lastIndexOf(46);
                if (index > 0) {
                    String extension = this.fileName.substring(index);
                    backupFile = this.fileName.substring(0, index) + "-" + format.format(new Date()) + extension;
                } else {
                    backupFile = this.fileName + "-" + format.format(new Date());
                }
                Files.copy(Paths.get(this.fileName, new String[0]), Paths.get(backupFile, new String[0]), new CopyOption[0]);
            }
            this.backup = true;
        }
        Constants.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(this.fileName), (Object)new VaultFormat(this.vaults));
    }

    @Override
    public void open() throws IOException {
        if (this.fileName == null) {
            throw new IOException("null fileName");
        }
        logger.info("Opening file vault " + this.fileName);
        File file = new File(this.fileName);
        if (!file.exists()) {
            for (String v : this.managedVaults) {
                this.vaults.put(v, new VaultImpl());
            }
            return;
        }
        VaultFormat format = (VaultFormat)Constants.mapper.readValue(new File(this.fileName), VaultFormat.class);
        format.checkVersion();
        for (String v : this.managedVaults) {
            VaultImpl impl = format.getVaults().get(v);
            if (impl == null) continue;
            this.vaults.put(v, impl);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String writeString() throws IOException {
        try {
            return Constants.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VaultFormat(this.vaults));
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    private class VaultInvocationHandler
    implements InvocationHandler {
        String vaultName;

        public VaultInvocationHandler(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            VaultImpl impl = (VaultImpl)FileStore.this.vaults.get(this.vaultName);
            Object ret = null;
            ret = "getSecretData".equals(method.getName()) && ret == null ? null : method.invoke((Object)impl, args);
            return ret;
        }
    }
}

