/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;

public class GenerateCVV
extends Command {
    @Override
    public String doProcess() {
        if (!"3".equals(this.getField(1))) {
            return "00#000100";
        }
        try {
            AKB akb = new AKB(this.getField(2));
            byte[] kcvv = akb.decryptKey(this.simulator.masterKeyBytes());
            String cvv = this.generateVisaCVV(this.getField(4), kcvv, 8);
            return "6D#" + cvv + "#" + akb.checkDigit + "##";
        }
        catch (GeneralSecurityException e) {
            Logger.suppress((Throwable)e);
            return "00#000000";
        }
    }

    public String generateVisaCVV(String verificationData, byte[] desKey, int length) throws GeneralSecurityException {
        char c;
        int i;
        if (length < 3) {
            throw new GeneralSecurityException("length must be more than 3.");
        }
        if (desKey.length != 16) {
            throw new GeneralSecurityException("Must be a dual length DES key.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(verificationData);
        while (builder.length() < 32) {
            builder.append("0");
        }
        String verification = builder.toString();
        byte[] blockA = Hex.toBytes(verification.substring(0, 16));
        byte[] blockB = Hex.toBytes(verification.substring(16));
        SecretKeySpec key = new SecretKeySpec(desKey, 0, 8, "DES");
        Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
        cipher.init(1, key);
        byte[] encrypted = cipher.doFinal(blockA);
        for (int i2 = 0; i2 < 8; ++i2) {
            encrypted[i2] = (byte)(encrypted[i2] ^ blockB[i2]);
        }
        byte[] tdesKey = new byte[24];
        System.arraycopy(desKey, 0, tdesKey, 0, 16);
        System.arraycopy(desKey, 0, tdesKey, 16, 8);
        key = new SecretKeySpec(tdesKey, "DESede");
        cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        cipher.init(1, key);
        encrypted = cipher.doFinal(encrypted);
        String result = Hex.toString(encrypted);
        builder = new StringBuilder();
        for (i = 0; i < result.length(); ++i) {
            c = result.charAt(i);
            if (c < '0' || c > '9') continue;
            builder.append(c);
        }
        for (i = 0; i < result.length(); ++i) {
            c = result.charAt(i);
            if (c < 'A' || c > 'F') continue;
            builder.append("" + (c - 65));
        }
        return builder.toString().substring(0, length);
    }
}

