/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.hsm.atalla.simulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.security.Hex;
import net.e6tech.elements.security.hsm.atalla.Message;
import net.e6tech.elements.security.hsm.atalla.simulator.AKB;
import net.e6tech.elements.security.hsm.atalla.simulator.Command;

public class AtallaSimulator {
    static String MASTER_KEY = "2ABC3DEF4567018998107645FED3CBA20123456789ABCDEF";
    static String IMK_ARQC = "1mENN000,5555 5555 5555 5555 6666 6666 6666 6666";
    static String IMK_SM_MAC = "1mENN00M,ABCD ABCD EF01 EF01 10FE 10FE DCBA DCBA";
    static String IMK_SM_ENC = "1mENN00E,1234 1234 5678 5678 8765 8765 4321 4321";
    static String KPV_VISA = "1VVNE000,3333 3333 3333 3333 4444 4444 4444 4444";
    static String KPV_IBM3624 = "1V3NE000,3333 3333 3333 3333 4444 4444 4444 4444";
    static String KPE_INTERCHANGE = "1PUNE000,5555 5555 5555 5555 6666 6666 6666 6666";
    static String KPE_BANK = "1PUNE000,1111 1111 1111 1111 2222 2222 2222 2222";
    static String KCVV = "1CDNE000,0123 4567 89AB CDEF FEDC BA98 7654 3210";
    static String KEK_KPE = "1KDEE000,0123 4567 89AB CDEF FEDC BA98 7654 3210";
    static String DEC = "1nCNE000,0123456789012345";
    static Logger logger = Logger.getLogger();
    private ExecutorService threadPool;
    private ServerSocket serverSocket;
    private int port = 7000;
    private byte[] masterKey = Hex.toBytes(MASTER_KEY);
    private boolean stopped = true;
    protected Map<String, String> keys = new Hashtable<String, String>();

    public static void main(String ... args) throws Exception {
        byte[] kekKey = Hex.toBytes("0123456789ABCDEFFEDCBA9876543210");
        String header = "1KDEE000";
        AtallaSimulator atalla = new AtallaSimulator();
        AKB akb = new AKB(header, atalla.masterKey, kekKey);
        byte[] recoveredKek = akb.decryptKey(atalla.masterKey);
        System.out.println(Arrays.equals(kekKey, recoveredKek));
    }

    public AtallaSimulator() throws GeneralSecurityException {
        Field[] fields;
        for (Field f : fields = AtallaSimulator.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().isAssignableFrom(String.class)) continue;
            f.setAccessible(true);
            try {
                this.keys.put(f.getName(), (String)f.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public String getMasterKey() {
        return Hex.toString(this.masterKey);
    }

    public void setMasterKey(String mkey) {
        this.masterKey = Hex.toBytes(mkey);
    }

    byte[] masterKeyBytes() {
        return this.masterKey;
    }

    public AKB getKey(String keyType) throws GeneralSecurityException {
        String key = this.keys.get(keyType);
        if (key == null) {
            return null;
        }
        return this.asAKB(key);
    }

    public AKB asAKB(String headerAndKey) throws GeneralSecurityException {
        String[] fields = headerAndKey.split(",");
        AKB akb = new AKB(fields[0].trim(), this.masterKey, Hex.toBytes(fields[1]));
        return akb;
    }

    public AKB asAKB(String header, byte[] key) throws GeneralSecurityException {
        AKB akb = new AKB(header, this.masterKey, key);
        return akb;
    }

    public byte[] decryptKey(AKB akb) throws GeneralSecurityException {
        return akb.decryptKey(this.masterKey);
    }

    public byte[] decrypt(AKB akb, String encrypted) throws GeneralSecurityException {
        return this.decrypt(akb, Hex.toBytes(encrypted));
    }

    public byte[] decrypt(AKB akb, byte[] encrypted) throws GeneralSecurityException {
        byte[] key = akb.decryptKey(this.masterKey);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(AKB.normalizeKey(key), "DESede");
        cipher.init(2, secretKey);
        return cipher.doFinal(encrypted);
    }

    public byte[] encrypt(AKB akb, String clearText) throws GeneralSecurityException {
        return this.decrypt(akb, Hex.toBytes(clearText));
    }

    public byte[] encrypt(AKB akb, byte[] clearText) throws GeneralSecurityException {
        byte[] key = akb.decryptKey(this.masterKey);
        Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
        SecretKeySpec secretKey = new SecretKeySpec(AKB.normalizeKey(key), "DESede");
        cipher.init(1, secretKey);
        return cipher.doFinal(clearText);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void start() {
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "AtallaSimulator");
                thread.setName("AtallaSimulator-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        Thread thread = new Thread(this::startServer);
        thread.start();
    }

    protected void startServer() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.stopped = false;
            while (!this.stopped) {
                Socket socket = this.serverSocket.accept();
                this.threadPool.execute(() -> {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                         PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            line = line.trim();
                            Command request = Command.createInstance(line, this);
                            Message response = request.process();
                            writer.println(response);
                            writer.flush();
                        }
                        System.out.println("Atalla client exited");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Throwable th) {
            throw logger.runtimeException(th);
        }
    }

    public void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.stopped = true;
            }
        }
    }
}

