/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.security.vault;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.e6tech.elements.security.vault.Secret;
import net.e6tech.elements.security.vault.Vault;

public class VaultImpl
implements Vault,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3384640081249910052L;
    private Map<String, SortedMap<Long, Secret>> secrets = new LinkedHashMap<String, SortedMap<Long, Secret>>();
    private String name;
    private transient VersionComparator comparator = new VersionComparator();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Secret getSecret(String alias, String version) {
        SortedMap<Long, Secret> versions = this.secrets.get(alias);
        if (versions == null) {
            return null;
        }
        Secret secret = null;
        secret = version == null ? (Secret)versions.get(versions.lastKey()) : (Secret)versions.get(new Long(version));
        return secret;
    }

    @Override
    public void addSecret(Secret secret) {
        String alias = secret.alias();
        SortedMap versions = this.secrets.computeIfAbsent(alias, key -> new TreeMap(this.comparator));
        String version = secret.version();
        if (version == null) {
            version = "0";
        }
        versions.put(new Long(version), secret);
    }

    @Override
    public void removeSecret(String alias, String version) {
        SortedMap<Long, Secret> versions = this.secrets.get(alias);
        if (versions == null) {
            return;
        }
        if (version == null) {
            this.secrets.remove(alias);
        } else {
            versions.remove(new Long(version));
        }
    }

    @Override
    public Set<String> aliases() {
        HashSet<String> aliases = new HashSet<String>();
        aliases.addAll(this.secrets.keySet());
        return aliases;
    }

    @Override
    public Set<Long> versions(String alias) {
        SortedMap<Long, Secret> versions = this.secrets.get(alias);
        if (versions == null) {
            return new HashSet<Long>();
        }
        return versions.keySet();
    }

    @Override
    public int size() {
        return this.secrets.size();
    }

    public VaultImpl clone() {
        VaultImpl vault = new VaultImpl();
        LinkedHashMap<String, SortedMap<Long, Secret>> cloneSecrets = new LinkedHashMap<String, SortedMap<Long, Secret>>();
        for (Map.Entry<String, SortedMap<Long, Secret>> entry : this.secrets.entrySet()) {
            SortedMap<Long, Secret> versions = entry.getValue();
            TreeMap<Long, Secret> cloneVersions = new TreeMap<Long, Secret>(this.comparator);
            for (Map.Entry<Long, Secret> e : versions.entrySet()) {
                cloneVersions.put(e.getKey(), new Secret(e.getValue()));
            }
            cloneSecrets.put(entry.getKey(), cloneVersions);
        }
        vault.secrets = cloneSecrets;
        return vault;
    }

    public Map<String, SortedMap<Long, Secret>> getSecrets() {
        return this.secrets;
    }

    public class VersionComparator
    implements Comparator<Long> {
        @Override
        public int compare(Long o1, Long o2) {
            if (o1 > o2) {
                return 1;
            }
            if (o1 < o2) {
                return -1;
            }
            return 0;
        }
    }
}

